/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_join.h"

static const char       rcsid[] = "$Id: assign_output_dfile.c,v 1.2 2009/10/16 20:07:58 keith Exp $";

/*
** $Log: assign_output_dfile.c,v $
** Revision 1.2  2009/10/16 20:07:58  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/08 02:16:35  keith
** Initial revision
**
*/

/*
** This function assigns information from control structure.
*/
int assign_output_dfile( output_ctl_t *output_ctl, sexpr_t *sexpr, unsigned short tuple_cnt )
{
	static const char	func[] = "assign_output_dfile";
	char	*str;
	int	ret;

	assert( output_ctl != (output_ctl_t *)0 );

	DEBUG_FUNC_START;

	if ( SEXPR_CAR_TYPE( sexpr ) != string_sexpr ) {
		control_syntax_error( "expected a string", __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}

	str = SEXPR_CAR_STRING( sexpr );

	if ( Debug ) {
		fprintf( stderr, "str = [%s]\n", str );
	}

	assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );

	if ( strcasecmp( str, "tags" ) == 0 ) {
		ret = assign_tag( &output_ctl->tag, &output_ctl->tag_cnt, SEXPR_CDR_LIST( sexpr ), tuple_cnt );
		RETURN_INT( ret );
	}

	if ( strcasecmp( str, "blocks-per-buffer" ) == 0 ) {
		ret = assign_ushort( &output_ctl->blocks_per_buffer_cnt, SEXPR_CDR_LIST( sexpr ), tuple_cnt );
		RETURN_INT( ret );
	}

	if ( strcasecmp( str, "buffer-count" ) == 0 ) {
		ret = assign_ushort( &output_ctl->buffer_cnt, SEXPR_CDR_LIST( sexpr ), tuple_cnt );
		RETURN_INT( ret );
	}

	if ( strcasecmp( str, "where" ) == 0 ) {
		output_ctl->record_filter = sexpr;

		RETURN_INT( 0 );
	}

	if ( strcasecmp( str, "open-mode" ) == 0 ) {
		ret = assign_open_mode( &output_ctl->dfile_open_mode, SEXPR_CDR_LIST( sexpr ), tuple_cnt );
		RETURN_INT( ret );
	}

	RETURN_INT( -1 );
}
