/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_join.h"

static const char       rcsid[] = "$Id: assign_key_fields.c,v 1.2 2009/10/16 20:07:58 keith Exp $";

/*
** $Log: assign_key_fields.c,v $
** Revision 1.2  2009/10/16 20:07:58  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/07 23:46:13  keith
** Initial revision
**
*/

/*
** This function assigns information from control structure.
*/
int assign_key_fields( const char ***key_field_tbl, unsigned short *key_field_tbl_cnt, sexpr_t *sexpr, unsigned short tuple_cnt )
{
	static const char	func[] = "assign_key_fields";
	static const char	str_msg[] = "expected a string";
	sexpr_t	*field_sexpr;
	size_t	alloc_size;
	const char	**new;

	assert( key_field_tbl != (const char ***)0 );
	assert( key_field_tbl_cnt != (unsigned short *)0 );

	DEBUG_FUNC_START;

	if ( sexpr == (sexpr_t *)0 ) {
		control_syntax_error( "expected list", __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}

	field_sexpr = SEXPR_CAR_LIST( sexpr );
	*key_field_tbl_cnt = (unsigned short)0;
	*key_field_tbl = (const char **)0;

	while ( field_sexpr != (sexpr_t *)0 ) {
		if ( SEXPR_CAR_TYPE( field_sexpr ) != string_sexpr ) {
			control_syntax_error( str_msg, __FILE__, __LINE__, tuple_cnt );
			RETURN_INT( -1 );
		}

		alloc_size = sizeof( const char * ) * ( (size_t)*key_field_tbl_cnt + (size_t)1 );
		new = (const char **)realloc( (void *)*key_field_tbl, alloc_size );
		if ( new == (const char **)0 ) {
			UNIX_ERROR( "realloc() failed" );
			RETURN_INT( -1 );
		}

		*key_field_tbl = new;
		new += *key_field_tbl_cnt;
		++*key_field_tbl_cnt;

		strtoupper( SEXPR_CAR_STRING( field_sexpr ) );

		*new = (const char *)SEXPR_CAR_STRING( field_sexpr );

		if ( Debug ) {
			(void) fprintf( stderr, "field: [%s]\n", *new );
		}

		assert( SEXPR_CDR_TYPE( field_sexpr ) == list_sexpr );

		field_sexpr = SEXPR_CDR_LIST( field_sexpr );
	}

	assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );

	if ( SEXPR_CDR_LIST( sexpr ) != (sexpr_t *)0 ) {
		control_syntax_error( "too many items in list", __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
