/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_join.h"

static const char       rcsid[] = "$Id: assign_control_information.c,v 1.2 2009/10/16 20:07:58 keith Exp $";

/*
** $Log: assign_control_information.c,v $
** Revision 1.2  2009/10/16 20:07:58  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/07 18:14:04  keith
** Initial revision
**
*/

/*
** This function assigns information from control structure.
*/
int assign_control_information( input_ctl_t *input_ctl, join_ctl_t **join_ctl_tbl, unsigned short *join_ctl_tbl_cnt, output_ctl_t *output_ctl, const char *control_file, dfile_tag_t *dfile_tag_tbl, unsigned short dfile_tag_tbl_cnt )
{
	static const char	func[] = "assign_control_information";
	int	result;
	unsigned short	tuple_cnt;
	sexpr_t	*level0;

	assert( input_ctl != (input_ctl_t *)0 );
	assert( join_ctl_tbl != (join_ctl_t **)0 );
	assert( join_ctl_tbl_cnt != (unsigned short *)0 );

	DEBUG_FUNC_START;

	result = sexpr_load( &level0, control_file );
	if ( result != 0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "failed to load s-expression from file [", stderr );
		(void) fputs( control_file, stderr );
		(void) fputs( "]: [", stderr );
		(void) fputs( sexpr_error( result ), stderr );
		(void) fputs( "]\n", stderr );
		RETURN_INT( -1 );
	}

	tuple_cnt = (unsigned short)0;

	/*
	** Loop through each tuple at depth 1.
	*/
	while ( level0 != (sexpr_t *)0 ) {
		++tuple_cnt;
		if ( SEXPR_CAR_TYPE( level0 ) != list_sexpr ) {
			control_syntax_error( "expected a list", __FILE__, __LINE__, tuple_cnt );
			RETURN_INT( -1 );
		}

		result = level1_syntax( input_ctl, join_ctl_tbl, join_ctl_tbl_cnt, output_ctl, SEXPR_CAR_LIST( level0 ), tuple_cnt, dfile_tag_tbl, dfile_tag_tbl_cnt );
		if ( result != 0 ) {
			RETURN_INT( result );
		}

		assert( SEXPR_CDR_TYPE( level0 ) == list_sexpr );

		level0 = SEXPR_CDR_LIST( level0 );
	}

	if ( Debug ) {
		dump_input_ctl( input_ctl );
		dump_join_ctl( *join_ctl_tbl, *join_ctl_tbl_cnt );
		dump_output_ctl( output_ctl );
	}

	RETURN_INT( 0 );
}
