/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile_exec.h"

static const char       rcsid[] = "$Id: write_recovery_log.c,v 1.2 2009/10/16 20:05:35 keith Exp $";

/*
** $Log: write_recovery_log.c,v $
** Revision 1.2  2009/10/16 20:05:35  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/07 09:03:59  keith
** Initial revision
**
*/

/*
** This function write a recovery log.
*/
int write_recovery_log( job_t *job_tbl, unsigned short divvy_text_cnt, unsigned short input_fname_cnt, slice_method_t slice_method_flag, const char *recovery_log )
{
	static const char	func[] = "start_jobs";
	unsigned short	job_ndx, job_cnt;
	FILE	*fptr;
	static const char	msg1[] = "Failed to create recovery log [";
	static const char	msg2[] = "].\n";

	assert( job_tbl != (job_t *)0 );
	assert( slice_method_flag == File_slice || slice_method_flag == Parm_file_slice );

	DEBUG_FUNC_START;

	if ( recovery_log == (const char *)0 ) {
		/*
		** Not using recovery log.
		*/
		RETURN_INT( 0 );
	}

	if ( get_job_cnt( &job_cnt, divvy_text_cnt, input_fname_cnt, slice_method_flag ) == -1 ) {
		RETURN_INT( -1 );
	}

	fptr = fopen( recovery_log, "w+" );
	if ( fptr == (FILE *)0 ) {
		UNIX_ERROR( "fopen() failed" );
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Could not open recovery log [", stderr );
		(void) fputs( recovery_log, stderr );
		(void) fputs( "].\n", stderr );
		RETURN_INT( -1 );
	}

	/*
	** Cycle through job table looking for completed jobs.
	*/
	for ( job_ndx = (unsigned short)0; job_ndx < job_cnt; ++job_ndx, ++job_tbl ) {
		if ( job_tbl->pid == (pid_t)0 || job_tbl->status != 0 ) {
			/*
			** Job has not completed successfully.
			*/
			continue;
		}

		if ( fput_ushort( job_ndx, fptr ) == -1 ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( msg1, stderr );
			(void) fputs( recovery_log, stderr );
			(void) fputs( msg2, stderr );
			RETURN_INT( -1 );
		}

		if ( fputc( '\n', fptr ) == EOF ) {
			UNIX_ERROR( "fputc() failed" );
			(void) fputs( msg1, stderr );
			(void) fputs( recovery_log, stderr );
			(void) fputs( msg2, stderr );
			RETURN_INT( -1 );
		}
	}

	if ( fclose( fptr ) == EOF ) {
		UNIX_ERROR( "fclose() failed" );
		(void) fputs( msg1, stderr );
		(void) fputs( recovery_log, stderr );
		(void) fputs( msg2, stderr );
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
