/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile_exec.h"

static const char       rcsid[] = "$Id: substitute_tokens.c,v 1.2 2009/10/16 20:05:35 keith Exp $";

/*
** $Log: substitute_tokens.c,v $
** Revision 1.2  2009/10/16 20:05:35  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/07 08:17:50  keith
** Initial revision
**
*/

/*
** This function searches for %n and %s flags. These flags are replaced with
** slice sequence number and slice name respectively.
*/
int substitute_tokens( char *new_arg, size_t new_arg_size, const char *sequence, const char *slice_name )
{
	static const char	func[] = "substitute_tokens";

	assert( sequence != (const char *)0 );

	DEBUG_FUNC_START;

	if ( substitute_str( new_arg, new_arg_size, "%n", sequence ) == -1 ) {
		RETURN_INT( -1 );
	}

	if ( slice_name == (const char *)0 ) {
		/*
		** Wasn't defined.
		*/
		RETURN_INT( 0 );
	}

	if ( substitute_str( new_arg, new_arg_size, "%s", slice_name ) == -1 ) {
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
