/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "tbox.h"
#include "dfile_exec.h"

static const char       rcsid[] = "$Id: get_slice_method.c,v 1.2 2009/10/16 20:05:35 keith Exp $";

/*
** $Log: get_slice_method.c,v $
** Revision 1.2  2009/10/16 20:05:35  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/07 04:19:15  keith
** Initial revision
**
*/

/*
** This function chooses the divvying method.
*/
slice_method_t get_slice_method( unsigned short divvy_text_cnt, const char *input_file_pattern )

{
	if ( input_file_pattern != (const char *)0 ) {
		if ( divvy_text_cnt > (size_t)0 ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Cannot use input file pattern with PARM file divvy.\n", stderr );
			return Invalid_slice_method;
		}

		/*
		** Use pre-sliced data from files.
		*/
		return File_slice;
	}

	if ( divvy_text_cnt > (size_t)0 ) {
		return Parm_file_slice;
	}

	FPUT_SRC_CODE( stderr );
	(void) fputs( ": Slicing method is unknown.\n", stderr );
	return Invalid_slice_method;
}
