/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    int clientHandle;
    int labelHandle;
    String text = "";

    public Group(Composite composite, int n) {
        super(composite, Group.checkStyle(n));
    }

    static int checkStyle(int n) {
        return (n |= 0x80000) & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    int clientHandle() {
        return this.clientHandle;
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        Point point = super.computeSize(n, n2, bl);
        int n3 = this.computeNativeSize((int)this.handle, (int)-1, (int)-1, (boolean)false).x;
        point.x = Math.max(point.x, n3);
        return point;
    }

    @Override
    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.forceResize();
        int n5 = OS.GTK_WIDGET_X(this.clientHandle);
        int n6 = OS.GTK_WIDGET_Y(this.clientHandle);
        return new Rectangle(n -= n5, n2 -= n6, n3 += n5 + n5, n4 += n5 + n6);
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_frame_new(null);
        if (this.handle == 0) {
            this.error(2);
        }
        this.labelHandle = OS.gtk_label_new(null);
        if (this.labelHandle == 0) {
            this.error(2);
        }
        OS.g_object_ref(this.labelHandle);
        OS.gtk_object_sink(this.labelHandle);
        this.clientHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.clientHandle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        OS.gtk_container_add(this.handle, this.clientHandle);
        if ((this.style & 4) != 0) {
            OS.gtk_frame_set_shadow_type(this.handle, 1);
        }
        if ((this.style & 8) != 0) {
            OS.gtk_frame_set_shadow_type(this.handle, 2);
        }
        if ((this.style & 0x10) != 0) {
            OS.gtk_frame_set_shadow_type(this.handle, 3);
        }
        if ((this.style & 0x40) != 0) {
            OS.gtk_frame_set_shadow_type(this.handle, 4);
        }
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.clientHandle);
        this.display.removeWidget(this.labelHandle);
    }

    @Override
    void enableWidget(boolean bl) {
        OS.gtk_widget_set_sensitive(this.labelHandle, bl);
    }

    @Override
    int eventHandle() {
        return this.fixedHandle;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.closures[32], false);
        }
    }

    @Override
    boolean mnemonicHit(char c) {
        if (this.labelHandle == 0) {
            return false;
        }
        boolean bl = super.mnemonicHit(this.labelHandle, c);
        if (bl) {
            this.setFocus();
        }
        return bl;
    }

    @Override
    boolean mnemonicMatch(char c) {
        if (this.labelHandle == 0) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, c);
    }

    @Override
    int parentingHandle() {
        return this.fixedHandle;
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.clientHandle, this);
        this.display.addWidget(this.labelHandle, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
        this.clientHandle = 0;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.labelHandle != 0) {
            OS.g_object_unref(this.labelHandle);
        }
        this.text = null;
    }

    @Override
    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        this.setBackgroundColor(this.fixedHandle, gdkColor);
    }

    @Override
    void setFontDescription(int n) {
        super.setFontDescription(n);
        OS.gtk_widget_modify_font(this.labelHandle, n);
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        this.setForegroundColor(this.labelHandle, gdkColor);
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n = (this.style & 0x4000000) != 0 ? 2 : 1;
            OS.gtk_widget_set_direction(this.labelHandle, n);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        if (string.length() != 0) {
            if (OS.gtk_frame_get_label_widget(this.handle) == 0) {
                OS.gtk_frame_set_label_widget(this.handle, this.labelHandle);
            }
        } else {
            OS.gtk_frame_set_label_widget(this.handle, 0);
        }
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.clientHandle != 0) {
            OS.gtk_widget_show(this.clientHandle);
        }
        if (this.labelHandle != 0) {
            OS.gtk_widget_show(this.labelHandle);
        }
    }
}

