/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.log.Level;
import gde.utils.CalculationThread;
import java.util.logging.Logger;

public class QuasiLinearRegression
extends CalculationThread {
    private static final Logger log = Logger.getLogger(QuasiLinearRegression.class.getName());

    public QuasiLinearRegression(RecordSet currentRecordSet, String inRecordKey, String outRecordKey, int calcIntervalSec) {
        super(currentRecordSet, inRecordKey, outRecordKey, calcIntervalSec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.recordSet == null || this.sourceRecordKey == null || this.targetRecordKey == null) {
            log.log(Level.WARNING, "Slope can not be calculated -> recordSet == null || sourceRecordKey == null || targetRecordKey == null");
            return;
        }
        String string = CalculationThread.REGRESSION_INTERVAL_SEC;
        synchronized (string) {
            log.log(Level.FINE, "start data calculation for record = " + this.targetRecordKey);
            Record recordHeight = this.recordSet.get(this.sourceRecordKey);
            Record record = this.recordSet.get(this.targetRecordKey);
            if (record != null && !this.threadStop && recordHeight.getMaxTime_ms() * 1000.0 > (double)this.calcInterval_sec) {
                int i;
                record.clear();
                double timeStep_sec = recordHeight.getAverageTimeStep_ms() / 1000.0;
                int timeStepsPerInterval = Double.valueOf((double)this.calcInterval_sec / timeStep_sec).intValue();
                timeStepsPerInterval = timeStepsPerInterval <= 4 ? 4 : timeStepsPerInterval;
                int pointsPerInterval = timeStepsPerInterval + 1;
                log.log(Level.FINE, "calcInterval_sec = " + this.calcInterval_sec + " pointsPerInterval = " + pointsPerInterval);
                int pointInterval = 3;
                int numberDataPoints = recordHeight.realSize();
                int startPosition = 0;
                int frontPadding = timeStepsPerInterval / 5 * 4 - pointInterval;
                int modCounter = (numberDataPoints - (pointsPerInterval - pointInterval)) / pointInterval;
                for (int i2 = 0; i2 < frontPadding; ++i2) {
                    record.add(0);
                }
                double avgX = 0.0;
                for (int i3 = 0; i3 < timeStepsPerInterval; ++i3) {
                    avgX += 1.0 / timeStep_sec * (double)i3;
                }
                avgX /= (double)timeStepsPerInterval;
                double ssXX = 0.0;
                for (i = 1; i <= timeStepsPerInterval; ++i) {
                    ssXX += (1.0 / timeStep_sec * (double)i - avgX) * (1.0 / timeStep_sec * (double)i - avgX);
                }
                log.log(Level.FINEST, "avgX = " + avgX + " ssXX = " + (ssXX /= (double)timeStepsPerInterval));
                --modCounter;
                while (modCounter > 0 && !this.threadStop) {
                    double avgY = 0.0;
                    for (int i4 = 1; i4 <= timeStepsPerInterval; ++i4) {
                        avgY += (double)recordHeight.realGet(i4 + startPosition).intValue();
                    }
                    avgY /= (double)timeStepsPerInterval;
                    double sumYi_avgY = 0.0;
                    for (int i5 = 1; i5 <= timeStepsPerInterval; ++i5) {
                        sumYi_avgY += (double)recordHeight.realGet(i5 + startPosition).intValue() - avgY;
                    }
                    sumYi_avgY /= (double)timeStepsPerInterval;
                    double ssXY = 0.0;
                    for (int i6 = 1; i6 <= timeStepsPerInterval; ++i6) {
                        ssXY += (1.0 / timeStep_sec * (double)i6 - avgX) * ((double)recordHeight.realGet(i6 + startPosition).intValue() - avgY);
                    }
                    int slope = Double.valueOf((ssXY /= (double)timeStepsPerInterval) / ssXX / timeStep_sec / timeStep_sec).intValue();
                    for (int i7 = 0; i7 < pointInterval; ++i7) {
                        record.add(slope);
                    }
                    log.log(Level.FINEST, "slope = " + slope + " counter = " + (startPosition += pointInterval) + " modCounter = " + modCounter);
                    --modCounter;
                }
                for (i = record.realSize(); i < numberDataPoints; ++i) {
                    record.add(0);
                }
                log.log(Level.FINE, "counter = " + startPosition + " modCounter = " + modCounter);
                if (this.recordSet.get(this.sourceRecordKey) != null && this.recordSet.get(this.sourceRecordKey).isDisplayable()) {
                    record.setDisplayable(true);
                }
                if (this.application.getActiveRecordSet() != null && this.recordSet.getName().equals(Channels.getInstance().getActiveChannel().getActiveRecordSet().getName()) && record.isVisible()) {
                    this.application.updateGraphicsWindow();
                }
            }
            this.application.updateCurveSelectorTable();
            this.application.updateStatisticsData();
            this.application.updateDataTable(this.recordSet.getName(), true);
            log.log(Level.FINE, "finished data calculation for record = " + this.targetRecordKey);
        }
    }
}

