/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.smmodellbau.GPSLogger;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBException;

public class GPSLogger2
extends GPSLogger {
    public GPSLogger2(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
    }

    public GPSLogger2(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
    }

    @Override
    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        String[] recordKeys = recordSet.getRecordNames();
        StringBuilder sb = new StringBuilder().append(GDE.LINE_SEPARATOR);
        Vector<String> cleanedRecordNames = new Vector<String>();
        Vector<String> noneCalculationRecordNames = new Vector<String>();
        List<String> recordNamesList = Arrays.asList(recordKeys);
        try {
            switch (fileRecordsProperties.length) {
                case 20: 
                case 26: 
                case 29: 
                case 35: 
                case 37: 
                case 43: {
                    return super.crossCheckMeasurements(fileRecordsProperties, recordSet);
                }
                case 44: 
                case 52: {
                    int j = 0;
                    block10: for (int i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 15: 
                            case 16: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: {
                                sb.append(String.format("%02d added measurement set to isCalculation=true -> %s\n", i, recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block10;
                            }
                            default: {
                                if (j < fileRecordsProperties.length) {
                                    HashMap recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                    sb.append(String.format("%02d %19s match %19s isAvtive = %s\n", i, recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                    if (!recordKeys[i].equals(recordProps.get("_name")) && recordNamesList.contains(recordProps.get("_name"))) {
                                        log.log(Level.WARNING, "Found not unique recordName : " + (String)recordProps.get("_name") + " Index " + i + "/" + recordNamesList.indexOf(recordProps.get("_name")));
                                        int index = recordNamesList.indexOf(recordProps.get("_name")) > i ? recordNamesList.indexOf(recordProps.get("_name")) : i;
                                        String newRecordSetName = index + "_" + recordKeys[index];
                                        recordSet.replaceRecordName(recordSet.get((Object)recordKeys[index]), newRecordSetName);
                                        recordKeys[index] = newRecordSetName;
                                    }
                                    cleanedRecordNames.add(recordKeys[i]);
                                    noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                    if (fileRecordsProperties[j].contains("_isActive=false")) {
                                        sb.append(String.format("%02d measurement set to isActive==false -> %s\n", i, recordKeys[i]));
                                        recordSet.get(i).setActive(Boolean.valueOf(false));
                                    }
                                    ++j;
                                    continue block10;
                                }
                                sb.append(String.format("%02d added measurement set to isCalculation=true -> %s\n", i, recordKeys[i]));
                                recordSet.get(i).setActive(null);
                            }
                        }
                    }
                    break;
                }
                case 50: 
                case 58: {
                    int j = 0;
                    for (int i = 0; i < recordKeys.length; ++i) {
                        if (j < fileRecordsProperties.length) {
                            HashMap recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                            sb.append(String.format("%02d %19s match %19s isAvtive = %s\n", i, recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                            if (!recordKeys[i].equals(recordProps.get("_name")) && recordNamesList.contains(recordProps.get("_name"))) {
                                log.log(Level.WARNING, "Found not unique recordName : " + (String)recordProps.get("_name") + " Index " + i + "/" + recordNamesList.indexOf(recordProps.get("_name")));
                                int index = recordNamesList.indexOf(recordProps.get("_name")) > i ? recordNamesList.indexOf(recordProps.get("_name")) : i;
                                String newRecordSetName = index + "_" + recordKeys[index];
                                recordSet.replaceRecordName(recordSet.get((Object)recordKeys[index]), newRecordSetName);
                                recordKeys[index] = newRecordSetName;
                            }
                            cleanedRecordNames.add(recordKeys[i]);
                            noneCalculationRecordNames.add((String)recordProps.get("_name"));
                            if (fileRecordsProperties[j].contains("_isActive=false")) {
                                sb.append(String.format("%02d measurement set to isActive==false -> %s\n", i, recordKeys[i]));
                                recordSet.get(i).setActive(Boolean.valueOf(false));
                            }
                            ++j;
                            continue;
                        }
                        sb.append(String.format("%02d added measurement set to isCalculation=true -> %s\n", i, recordKeys[i]));
                        recordSet.get(i).setActive(null);
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < recordKeys.length; ++i) {
                        if (!fileRecordsProperties[i].contains("_isActive")) {
                            sb.append(String.format("%02d measurement set to isCalculation=true -> %s\n", i, recordKeys[i]));
                            recordSet.get(i).setActive(null);
                            cleanedRecordNames.add(recordKeys[i]);
                            continue;
                        }
                        HashMap recordProps = StringHelper.splitString((String)fileRecordsProperties[i], (String)"|-|", (String[])Record.propertyKeys);
                        sb.append(String.format("%02d %19s match %19s isAvtive = %s\n", i, recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                        if (!recordKeys[i].equals(recordProps.get("_name")) && recordNamesList.contains(recordProps.get("_name"))) {
                            log.log(Level.WARNING, "Found not unique recordName : " + (String)recordProps.get("_name") + " Index " + i + "/" + recordNamesList.indexOf(recordProps.get("_name")));
                            int index = recordNamesList.indexOf(recordProps.get("_name")) > i ? recordNamesList.indexOf(recordProps.get("_name")) : i;
                            String newRecordSetName = index + "_" + recordKeys[index];
                            recordSet.replaceRecordName(recordSet.get((Object)recordKeys[index]), newRecordSetName);
                            recordKeys[index] = newRecordSetName;
                        }
                        cleanedRecordNames.add(recordKeys[i]);
                        noneCalculationRecordNames.add((String)recordProps.get("_name"));
                        if (!fileRecordsProperties[i].contains("_isActive=false")) continue;
                        sb.append(String.format("%02d measurement set to isActive==false -> %s\n", i, recordKeys[i]));
                        recordSet.get(i).setActive(Boolean.valueOf(false));
                    }
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, String.format("recordKey to fileRecordsProperties mismatch, check:\n %s \nfileRecordsProperties.length = %d recordKeys.length = %d %s", e.getMessage(), fileRecordsProperties.length, recordKeys.length, sb.toString()));
        }
        recordKeys = cleanedRecordNames.toArray(new String[1]);
        recordSet.setNoneCalculationRecordNames(noneCalculationRecordNames.toArray(new String[1]));
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, sb.toString());
        }
        return recordKeys;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int i;
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.getNoneCalculationRecordNames().length];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        byte[] timeStampBuffer = new byte[timeStampBufferSize];
        if (!recordSet.isTimeStepConstant()) {
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
        }
        log.log(java.util.logging.Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (i = 0; i < recordDataSize; ++i) {
            log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((convertBuffer[0 + j * 4] & 0xFF) << 24) + ((convertBuffer[1 + j * 4] & 0xFF) << 16) + ((convertBuffer[2 + j * 4] & 0xFF) << 8) + ((convertBuffer[3 + j * 4] & 0xFF) << 0);
            }
            if (recordSet.isTimeStepConstant()) {
                recordSet.addNoneCalculationRecordsPoints(points);
            } else {
                recordSet.addNoneCalculationRecordsPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.updateVisibilityStatus(recordSet, true);
        recordSet.syncScaleOfSyncableRecords();
    }
}

