/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import com.sun.istack.Nullable;
import gde.Analyzer;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.ScoreLabelTypes;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.PackageLoss;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.ThrowableUtils;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.VaultCollector;
import gde.histo.device.UniversalSampler;
import gde.io.DataParser;
import gde.log.Level;
import gde.utils.StringHelper;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class HoTTbinHistoReader {
    private static final String $CLASS_NAME = HoTTbinHistoReader.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    protected static final int RECORD_TIMESPAN_MS = 10;
    protected static final int DATA_BLOCK_SIZE = 64;
    protected final HoTTAdapter.PickerParameters pickerParameters;
    protected final Analyzer analyzer;
    protected final boolean isChannelsChannelEnabled;
    protected final int initializeSamplingFactor;
    protected final boolean isFilterEnabled;
    protected final boolean isFilterTextModus;
    protected final int altitudeClimbSensorSelection;
    protected final Procedure initTimer;
    protected final Procedure readTimer;
    protected final Procedure reviewTimer;
    protected final Procedure addTimer;
    protected final Procedure pickTimer;
    protected final Procedure finishTimer;
    protected long nanoTime;
    protected long currentTime;
    protected long initiateTime;
    protected long readTime;
    protected long reviewTime;
    protected long addTime;
    protected long pickTime;
    protected long finishTime;
    protected long lastTime;
    protected EnumSet<HoTTAdapter.Sensor> detectedSensors;
    protected RecordSet tmpRecordSet;
    protected VaultCollector truss;

    public HoTTbinHistoReader(HoTTAdapter.PickerParameters pickerParameters) {
        this(pickerParameters, pickerParameters.analyzer.getActiveChannel().getNumber() == HoTTAdapter.Sensor.CHANNEL.getChannelNumber(), 1);
    }

    protected HoTTbinHistoReader(HoTTAdapter.PickerParameters pickerParameters, boolean isChannelsChannelEnabled, int initializeSamplingFactor) {
        this.pickerParameters = new HoTTAdapter.PickerParameters(pickerParameters);
        this.pickerParameters.isFilterEnabled = true;
        this.analyzer = pickerParameters.analyzer;
        this.isChannelsChannelEnabled = isChannelsChannelEnabled;
        this.initializeSamplingFactor = initializeSamplingFactor;
        this.isFilterEnabled = true;
        this.isFilterTextModus = true;
        this.altitudeClimbSensorSelection = 0;
        this.detectedSensors = EnumSet.noneOf(HoTTAdapter.Sensor.class);
        if (log.isLoggable(Level.TIME)) {
            this.initTimer = () -> {
                this.currentTime = System.nanoTime();
                this.initiateTime += this.currentTime - this.lastTime;
                this.lastTime = this.currentTime;
            };
            this.readTimer = () -> {
                this.currentTime = System.nanoTime();
                this.readTime += this.currentTime - this.lastTime;
                this.lastTime = this.currentTime;
            };
            this.reviewTimer = () -> {
                this.currentTime = System.nanoTime();
                this.reviewTime += this.currentTime - this.lastTime;
                this.lastTime = this.currentTime;
            };
            this.addTimer = () -> {
                this.currentTime = System.nanoTime();
                this.addTime += this.currentTime - this.lastTime;
                this.lastTime = this.currentTime;
            };
            this.pickTimer = () -> {
                this.currentTime = System.nanoTime();
                this.pickTime += this.currentTime - this.lastTime;
                this.lastTime = this.currentTime;
            };
            this.finishTimer = () -> {
                this.currentTime = System.nanoTime();
                this.finishTime += this.currentTime - this.lastTime;
                this.lastTime = this.currentTime;
            };
        } else {
            this.pickTimer = this.finishTimer = () -> {};
            this.addTimer = this.finishTimer;
            this.reviewTimer = this.finishTimer;
            this.readTimer = this.finishTimer;
            this.initTimer = this.finishTimer;
        }
    }

    public void read(Supplier<InputStream> inputStream, VaultCollector newTruss) throws IOException, DataTypeException, DataInconsitsentException {
        if (newTruss.getVault().getLogFileLength() <= 448000L) {
            return;
        }
        this.nanoTime = System.nanoTime();
        this.finishTime = 0L;
        this.pickTime = 0L;
        this.addTime = 0L;
        this.reviewTime = 0L;
        this.readTime = 0L;
        this.initiateTime = 0L;
        this.lastTime = System.nanoTime();
        this.truss = newTruss;
        IDevice device = this.analyzer.getActiveDevice();
        ExtendedVault vault = this.truss.getVault();
        long numberDatablocks = vault.getLogFileLength() / 64L;
        this.tmpRecordSet = RecordSet.createRecordSet((String)vault.getLogRecordsetBaseName(), (Analyzer)this.analyzer, (int)this.analyzer.getActiveChannel().getNumber(), (boolean)true, (boolean)true, (boolean)false);
        this.tmpRecordSet.setStartTimeStamp(HoTTbinReader.getStartTimeStamp(vault.getLoadFileAsPath().getFileName().toString(), vault.getLogFileLastModified(), numberDatablocks));
        this.tmpRecordSet.setRecordSetDescription(device.getName() + " - " + StringHelper.getFormatedTime((String)"yyyy-MM-dd HH:mm:ss.SSS", (long)this.tmpRecordSet.getStartTimeStamp()));
        this.tmpRecordSet.descriptionAppendFilename(vault.getLoadFileAsPath().getFileName().toString());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, " recordSetBaseName=" + vault.getLogRecordsetBaseName());
        }
        HashMap<String, String> header = null;
        try (BufferedInputStream info_in = new BufferedInputStream(inputStream.get());){
            header = new HoTTbinReader.InfoParser(s -> {}).getFileInfo(info_in, vault.getLoadFilePath(), vault.getLogFileLength());
            if (header == null || header.isEmpty()) {
                return;
            }
            this.detectedSensors = HoTTAdapter.Sensor.getSetFromDetected(header.get("DETECTED SENSOR"));
            if (!HoTTAdapter.Sensor.getChannelNumbers(this.detectedSensors).contains(this.truss.getVault().getVaultChannelNumber())) {
                return;
            }
            this.read(inputStream, Boolean.parseBoolean(header.get("SD_FORMAT")));
        }
        catch (DataTypeException e) {
            log.log(Level.WARNING, String.format("%s  %s", e.getMessage(), vault.getLoadFilePath()));
        }
        catch (InvalidObjectException invalidObjectException) {
            // empty catch block
        }
    }

    protected void read(Supplier<InputStream> inputStream, boolean isSdFormat) throws IOException, DataTypeException, DataInconsitsentException {
        try (BufferedInputStream in = new BufferedInputStream(inputStream.get());
             FilterInputStream data_in = isSdFormat ? new HoTTbinReader.SdLogInputStream(in, this.truss.getVault().getLogFileLength(), new HoTTbinReader.SdLogFormat(27, 323, 64)) : in;){
            int initializeBlockLimit = this.initializeSamplingFactor * 5500;
            int readLimitMark = initializeBlockLimit * 64 + 1;
            if (this.detectedSensors.size() <= 2) {
                ((InputStream)data_in).mark(readLimitMark);
                int activeChannelNumber = this.analyzer.getActiveChannel().getNumber();
                int[] points = new int[this.analyzer.getActiveDevice().getNumberOfMeasurements(activeChannelNumber)];
                UniversalSampler initSampler = UniversalSampler.createSampler((int)activeChannelNumber, (int[])points, (int)10, (Analyzer)this.analyzer);
                this.readSingle(data_in, initializeBlockLimit, initSampler);
                ((InputStream)data_in).reset();
                UniversalSampler sampler = UniversalSampler.createSampler((int)activeChannelNumber, (int[])initSampler.getMaxPoints(), (int[])initSampler.getMinPoints(), (int)10, (Analyzer)this.analyzer);
                this.readSingle(data_in, -1, sampler);
            } else {
                ((InputStream)data_in).mark(readLimitMark);
                int activeChannelNumber = this.analyzer.getActiveChannel().getNumber();
                int[] points = new int[this.analyzer.getActiveDevice().getNumberOfMeasurements(activeChannelNumber)];
                UniversalSampler initSampler = UniversalSampler.createSampler((int)activeChannelNumber, (int[])points, (int)10, (Analyzer)this.analyzer);
                this.readMultiple(data_in, initializeBlockLimit, initSampler);
                ((InputStream)data_in).reset();
                UniversalSampler sampler = UniversalSampler.createSampler((int)activeChannelNumber, (int[])initSampler.getMaxPoints(), (int[])initSampler.getMinPoints(), (int)10, (Analyzer)this.analyzer);
                this.readMultiple(data_in, -1, sampler);
            }
        }
    }

    protected void readSingle(InputStream data_in, int initializeBlocks, UniversalSampler histoRandomSample) throws DataInconsitsentException, IOException {
        HoTTbinReader.BinParser binParser;
        int[] points = histoRandomSample.getPoints();
        byte[] buf = new byte[64];
        byte[] buf0 = new byte[30];
        byte[] buf1 = new byte[30];
        byte[] buf2 = new byte[30];
        byte[] buf3 = new byte[30];
        byte[] buf4 = new byte[30];
        HoTTbinReader.BufCopier bufCopier = new HoTTbinReader.BufCopier(buf, buf0, buf1, buf2, buf3, buf4);
        long[] timeSteps_ms = new long[]{0L};
        boolean isSensorData = false;
        boolean isTextModusSignaled = false;
        int activeChannelNumber = this.analyzer.getActiveChannel().getNumber();
        if (activeChannelNumber == HoTTAdapter.Sensor.RECEIVER.getChannelNumber()) {
            binParser = HoTTAdapter.Sensor.RECEIVER.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        } else if (activeChannelNumber == HoTTAdapter.Sensor.CHANNEL.getChannelNumber()) {
            binParser = HoTTAdapter.Sensor.CHANNEL.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        } else if (activeChannelNumber == HoTTAdapter.Sensor.VARIO.getChannelNumber()) {
            binParser = HoTTAdapter.Sensor.VARIO.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        } else if (activeChannelNumber == HoTTAdapter.Sensor.GPS.getChannelNumber()) {
            binParser = HoTTAdapter.Sensor.GPS.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        } else if (activeChannelNumber == HoTTAdapter.Sensor.GAM.getChannelNumber()) {
            binParser = HoTTAdapter.Sensor.GAM.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        } else if (activeChannelNumber == HoTTAdapter.Sensor.EAM.getChannelNumber()) {
            binParser = HoTTAdapter.Sensor.EAM.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        } else if (activeChannelNumber == HoTTAdapter.Sensor.ESC.getChannelNumber()) {
            binParser = HoTTAdapter.Sensor.ESC.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        } else {
            throw new UnsupportedOperationException();
        }
        Procedure pointsAdder = initializeBlocks <= 0 ? () -> {
            this.readTimer.invoke();
            boolean isValidSample = histoRandomSample.capturePoints(timeSteps_ms[0]);
            this.reviewTimer.invoke();
            if (isValidSample) {
                try {
                    this.tmpRecordSet.addPoints(histoRandomSample.getSamplePoints(), (double)histoRandomSample.getSampleTimeStep_ms());
                }
                catch (DataInconsitsentException e) {
                    throw ThrowableUtils.rethrow((Throwable)e);
                }
                this.addTimer.invoke();
                this.pickTimer.invoke();
            }
        } : () -> histoRandomSample.capturePoints(timeSteps_ms[0]);
        this.initTimer.invoke();
        boolean doFullRead = initializeBlocks <= 0;
        boolean doDataSkip = this.detectedSensors.size() == 1 && !this.isChannelsChannelEnabled;
        int datablocksLimit = (doFullRead ? (int)this.truss.getVault().getLogFileLength() / 64 : initializeBlocks) / (doDataSkip ? 10 : 1);
        for (int i = 0; i < datablocksLimit; ++i) {
            data_in.read(buf);
            if (log.isLoggable(Level.FINE) && i % 10 == 0) {
                log.log(Level.FINE, StringHelper.fourDigitsRunningNumber((int)buf.length));
                log.log(Level.FINE, StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
            }
            if (!this.isFilterTextModus || (buf[6] & 1) == 0) {
                if (buf[33] >= 0 && buf[33] <= 4 && buf[3] != 0 && buf[4] != 0) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, String.format("Sensor %x Blocknummer : %d", buf[7], buf[33]));
                    }
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, StringHelper.byte2Hex2CharString((byte[])new byte[]{buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)buf[7], (boolean)false));
                    }
                    if (binParser instanceof HoTTbinReader.RcvBinParser) {
                        ((HoTTbinReader.RcvBinParser)binParser).trackPackageLoss(true);
                        if (buf[33] == 0 && (buf[38] & 0x80) != 128 && DataParser.parse2Short((byte[])buf, (int)40) >= 0 && binParser.parse()) {
                            pointsAdder.invoke();
                        }
                    } else if (binParser instanceof HoTTbinReader.ChnBinParser && binParser.parse()) {
                        pointsAdder.invoke();
                    }
                    if (doDataSkip) {
                        for (int j = 0; j < 9; ++j) {
                            data_in.read(buf);
                            timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                        }
                        isSensorData = true;
                    }
                    if (buf[33] == 0) {
                        bufCopier.copyToBuffer();
                    }
                    timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                    switch ((byte)(buf[7] & 0xFF)) {
                        case -119: 
                        case 55: {
                            if (!this.detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO)) break;
                            bufCopier.copyToVarioBuffer();
                            if (!bufCopier.is4BuffersFull()) break;
                            if (binParser instanceof HoTTbinReader.VarBinParser && binParser.parse()) {
                                pointsAdder.invoke();
                            }
                            isSensorData = true;
                            bufCopier.clearBuffers();
                            break;
                        }
                        case -118: 
                        case 56: {
                            if (!this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS)) break;
                            bufCopier.copyToFreeBuffer();
                            if (!bufCopier.is4BuffersFull()) break;
                            if (binParser instanceof HoTTbinReader.GpsBinParser && binParser.parse()) {
                                pointsAdder.invoke();
                            }
                            isSensorData = true;
                            bufCopier.clearBuffers();
                            break;
                        }
                        case -115: 
                        case 53: {
                            if (!this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM)) break;
                            bufCopier.copyToFreeBuffer();
                            if (!bufCopier.is4BuffersFull()) break;
                            if (binParser instanceof HoTTbinReader.GamBinParser && binParser.parse()) {
                                pointsAdder.invoke();
                            }
                            isSensorData = true;
                            bufCopier.clearBuffers();
                            break;
                        }
                        case -114: 
                        case 54: {
                            if (!this.detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM)) break;
                            bufCopier.copyToFreeBuffer();
                            if (!bufCopier.is4BuffersFull()) break;
                            if (binParser instanceof HoTTbinReader.EamBinParser && binParser.parse()) {
                                pointsAdder.invoke();
                            }
                            isSensorData = true;
                            bufCopier.clearBuffers();
                            break;
                        }
                        case -116: 
                        case 57: {
                            if (!this.detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC)) break;
                            bufCopier.copyToFreeBuffer();
                            if (!bufCopier.is4BuffersFull()) break;
                            if (binParser instanceof HoTTbinReader.EscBinParser && binParser.parse()) {
                                pointsAdder.invoke();
                            }
                            isSensorData = true;
                            bufCopier.clearBuffers();
                        }
                    }
                    if (!isSensorData) continue;
                    if (binParser instanceof HoTTbinReader.RcvBinParser) {
                        isSensorData = !((HoTTbinReader.RcvBinParser)binParser).updateLossStatistics();
                        continue;
                    }
                    isSensorData = false;
                    continue;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "-->> Found tx=rx=0 dBm");
                }
                if (binParser instanceof HoTTbinReader.RcvBinParser) {
                    ((HoTTbinReader.RcvBinParser)binParser).trackPackageLoss(false);
                }
                if (binParser instanceof HoTTbinReader.ChnBinParser && binParser.parse()) {
                    pointsAdder.invoke();
                }
                timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                continue;
            }
            if (isTextModusSignaled) continue;
            isTextModusSignaled = true;
        }
        if (doFullRead) {
            PackageLoss lostPackages = null;
            if (binParser instanceof HoTTbinReader.RcvBinParser) {
                ((HoTTbinReader.RcvBinParser)binParser).finalUpdateLossStatistics();
                lostPackages = ((HoTTbinReader.RcvBinParser)binParser).getLostPackages();
            }
            Integer[] scores = this.getScores(lostPackages, histoRandomSample, this.truss.getVault());
            HoTTAdapter device = (HoTTAdapter)this.analyzer.getActiveDevice();
            device.calculateInactiveRecords(this.tmpRecordSet);
            device.updateVisibilityStatus(this.tmpRecordSet, true);
            this.truss.promoteTruss(this.tmpRecordSet, scores);
            this.finishTimer.invoke();
            this.writeFinalLog(isTextModusSignaled, lostPackages, histoRandomSample, this.truss.getVault());
            this.tmpRecordSet.cleanup();
        }
        log.log(Level.FINER, " > ends <  doFullRead=", doFullRead);
    }

    protected void readMultiple(InputStream data_in, int initializeBlocks, UniversalSampler histoRandomSample) throws IOException, DataInconsitsentException {
        HoTTbinReader.BinParser binParser;
        int[] points = histoRandomSample.getPoints();
        byte[] buf = new byte[64];
        byte[] buf0 = new byte[30];
        byte[] buf1 = new byte[30];
        byte[] buf2 = new byte[30];
        byte[] buf3 = new byte[30];
        byte[] buf4 = new byte[30];
        HoTTbinReader.BufCopier bufCopier = new HoTTbinReader.BufCopier(buf, buf0, buf1, buf2, buf3, buf4);
        long[] timeSteps_ms = new long[]{0L};
        int actualSensor = -1;
        int lastSensor = -1;
        int logCountVario = 0;
        int logCountGPS = 0;
        int logCountGeneral = 0;
        int logCountElectric = 0;
        int logCountSpeedControl = 0;
        boolean isSensorData = false;
        boolean isTextModusSignaled = false;
        int activeChannelNumber = this.analyzer.getActiveChannel().getNumber();
        if (activeChannelNumber == HoTTAdapter.Sensor.RECEIVER.getChannelNumber()) {
            binParser = HoTTAdapter.Sensor.RECEIVER.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        } else if (activeChannelNumber == HoTTAdapter.Sensor.CHANNEL.getChannelNumber()) {
            binParser = HoTTAdapter.Sensor.CHANNEL.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        } else if (activeChannelNumber == HoTTAdapter.Sensor.VARIO.getChannelNumber() && this.detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO)) {
            binParser = HoTTAdapter.Sensor.VARIO.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        } else if (activeChannelNumber == HoTTAdapter.Sensor.GPS.getChannelNumber() && this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS)) {
            binParser = HoTTAdapter.Sensor.GPS.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        } else if (activeChannelNumber == HoTTAdapter.Sensor.GAM.getChannelNumber() && this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM)) {
            binParser = HoTTAdapter.Sensor.GAM.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        } else if (activeChannelNumber == HoTTAdapter.Sensor.EAM.getChannelNumber() && this.detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM)) {
            binParser = HoTTAdapter.Sensor.EAM.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        } else if (activeChannelNumber == HoTTAdapter.Sensor.ESC.getChannelNumber() && this.detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC)) {
            binParser = HoTTAdapter.Sensor.ESC.createBinParser(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        } else {
            throw new UnsupportedOperationException();
        }
        Procedure pointsAdder = initializeBlocks <= 0 ? () -> {
            this.readTimer.invoke();
            boolean isValidSample = histoRandomSample.capturePoints(timeSteps_ms[0]);
            this.reviewTimer.invoke();
            if (isValidSample) {
                try {
                    this.tmpRecordSet.addPoints(histoRandomSample.getSamplePoints(), (double)histoRandomSample.getSampleTimeStep_ms());
                }
                catch (DataInconsitsentException e) {
                    throw ThrowableUtils.rethrow((Throwable)e);
                }
                this.addTimer.invoke();
                this.pickTimer.invoke();
            }
        } : () -> histoRandomSample.capturePoints(timeSteps_ms[0]);
        this.initTimer.invoke();
        boolean doFullRead = initializeBlocks <= 0;
        int datablocksLimit = doFullRead ? (int)this.truss.getVault().getLogFileLength() / 64 : initializeBlocks;
        for (int i = 0; i < datablocksLimit; ++i) {
            data_in.read(buf);
            if (log.isLoggable(Level.FINEST) && i % 10 == 0) {
                log.log(Level.FINEST, StringHelper.fourDigitsRunningNumber((int)buf.length));
                log.log(Level.FINEST, StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
            }
            if (!this.isFilterTextModus || (buf[6] & 1) == 0) {
                if (buf[33] >= 0 && buf[33] <= 4 && buf[3] != 0 && buf[4] != 0) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, String.format("Sensor %x Blocknummer : %d", buf[7], buf[33]));
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, StringHelper.byte2Hex2CharString((byte[])new byte[]{buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)buf[7], (boolean)false));
                    }
                    if (binParser instanceof HoTTbinReader.RcvBinParser) {
                        ((HoTTbinReader.RcvBinParser)binParser).trackPackageLoss(true);
                        if (buf[33] == 0 && (buf[38] & 0x80) != 128 && DataParser.parse2Short((byte[])buf, (int)40) >= 0 && binParser.parse()) {
                            pointsAdder.invoke();
                        }
                    } else if (binParser instanceof HoTTbinReader.ChnBinParser && binParser.parse()) {
                        pointsAdder.invoke();
                    }
                    timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                    if (actualSensor == -1) {
                        byte by = (byte)(buf[7] & 0xFF);
                        actualSensor = by;
                        lastSensor = by;
                    } else {
                        actualSensor = (byte)(buf[7] & 0xFF);
                    }
                    if (actualSensor != lastSensor) {
                        if (logCountVario >= 5 || logCountGPS >= 5 || logCountGeneral >= 5 || logCountElectric >= 5 || logCountSpeedControl >= 5) {
                            switch (lastSensor) {
                                case -119: 
                                case 55: {
                                    if (!this.detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO)) break;
                                    if (binParser instanceof HoTTbinReader.VarBinParser && binParser.parse()) {
                                        pointsAdder.invoke();
                                    }
                                    isSensorData = true;
                                    break;
                                }
                                case -118: 
                                case 56: {
                                    if (!this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS)) break;
                                    if (binParser instanceof HoTTbinReader.GpsBinParser && binParser.parse()) {
                                        pointsAdder.invoke();
                                    }
                                    isSensorData = true;
                                    break;
                                }
                                case -115: 
                                case 53: {
                                    if (!this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM)) break;
                                    if (binParser instanceof HoTTbinReader.GamBinParser && binParser.parse()) {
                                        pointsAdder.invoke();
                                    }
                                    isSensorData = true;
                                    break;
                                }
                                case -114: 
                                case 54: {
                                    if (!this.detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM)) break;
                                    if (binParser instanceof HoTTbinReader.EamBinParser && binParser.parse()) {
                                        pointsAdder.invoke();
                                    }
                                    isSensorData = true;
                                    break;
                                }
                                case -116: 
                                case 57: {
                                    if (!this.detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC)) break;
                                    if (binParser instanceof HoTTbinReader.EscBinParser && binParser.parse()) {
                                        pointsAdder.invoke();
                                    }
                                    isSensorData = true;
                                }
                            }
                        }
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "logCountVario = " + logCountVario + " logCountGPS = " + logCountGPS + " logCountGeneral = " + logCountGeneral + " logCountElectric = " + logCountElectric + " logCountMotorDriver = " + logCountSpeedControl);
                        }
                        lastSensor = actualSensor;
                        logCountSpeedControl = 0;
                        logCountElectric = 0;
                        logCountGeneral = 0;
                        logCountGPS = 0;
                        logCountVario = 0;
                    }
                    switch (lastSensor) {
                        case -119: 
                        case 55: {
                            ++logCountVario;
                            break;
                        }
                        case -118: 
                        case 56: {
                            ++logCountGPS;
                            break;
                        }
                        case -115: 
                        case 53: {
                            ++logCountGeneral;
                            break;
                        }
                        case -114: 
                        case 54: {
                            ++logCountElectric;
                            break;
                        }
                        case -116: 
                        case 57: {
                            ++logCountSpeedControl;
                        }
                    }
                    bufCopier.copyToBuffer();
                    if (!isSensorData) continue;
                    if (binParser instanceof HoTTbinReader.RcvBinParser) {
                        isSensorData = !((HoTTbinReader.RcvBinParser)binParser).updateLossStatistics();
                        continue;
                    }
                    isSensorData = false;
                    continue;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "-->> Found tx=rx=0 dBm");
                }
                if (binParser instanceof HoTTbinReader.RcvBinParser) {
                    ((HoTTbinReader.RcvBinParser)binParser).trackPackageLoss(false);
                }
                if (binParser instanceof HoTTbinReader.ChnBinParser && binParser.parse()) {
                    pointsAdder.invoke();
                }
                timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                continue;
            }
            if (isTextModusSignaled) continue;
            isTextModusSignaled = true;
        }
        if (doFullRead) {
            if (binParser instanceof HoTTbinReader.RcvBinParser) {
                ((HoTTbinReader.RcvBinParser)binParser).finalUpdateLossStatistics();
            }
            PackageLoss lostPackages = binParser instanceof HoTTbinReader.RcvBinParser ? ((HoTTbinReader.RcvBinParser)binParser).getLostPackages() : null;
            Integer[] scores = this.getScores(lostPackages, histoRandomSample, this.truss.getVault());
            HoTTAdapter device = (HoTTAdapter)this.analyzer.getActiveDevice();
            device.calculateInactiveRecords(this.tmpRecordSet);
            device.updateVisibilityStatus(this.tmpRecordSet, true);
            this.truss.promoteTruss(this.tmpRecordSet, scores);
            this.finishTimer.invoke();
            this.writeFinalLog(isTextModusSignaled, lostPackages, histoRandomSample, this.truss.getVault());
            this.tmpRecordSet.cleanup();
        }
        log.log(Level.FINER, " > ends <  doFullRead=", doFullRead);
    }

    protected Integer[] getScores(@Nullable PackageLoss lostPackages, UniversalSampler histoRandomSample, ExtendedVault vault) {
        int lossTotal = lostPackages == null ? 0 : lostPackages.lossTotal;
        Integer[] scores = new Integer[ScoreLabelTypes.VALUES.length];
        scores[ScoreLabelTypes.TOTAL_READINGS.ordinal()] = histoRandomSample.getReadingCount();
        scores[ScoreLabelTypes.TOTAL_PACKAGES.ordinal()] = (int)vault.getLogFileLength() / 64;
        scores[ScoreLabelTypes.LOST_PACKAGES.ordinal()] = lossTotal;
        if (lostPackages != null) {
            scores[ScoreLabelTypes.LOST_PACKAGES_PER_MILLE.ordinal()] = (int)(lostPackages.percentage * 10000.0);
            scores[ScoreLabelTypes.LOST_PACKAGES_AVG_MS.ordinal()] = (int)lostPackages.getAvgValue() * 10 * 1000;
            scores[ScoreLabelTypes.LOST_PACKAGES_MAX_MS.ordinal()] = lostPackages.getMaxValue() * 10 * 1000;
            scores[ScoreLabelTypes.LOST_PACKAGES_MIN_MS.ordinal()] = lostPackages.getMinValue() * 10 * 1000;
            scores[ScoreLabelTypes.LOST_PACKAGES_SIGMA_MS.ordinal()] = (int)lostPackages.getSigmaValue() * 10 * 1000;
        } else {
            scores[ScoreLabelTypes.LOST_PACKAGES_PER_MILLE.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES_AVG_MS.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES_MAX_MS.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES_MIN_MS.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES_SIGMA_MS.ordinal()] = 0;
        }
        BitSet activeSensors = HoTTAdapter.Sensor.getSensors(this.detectedSensors);
        scores[ScoreLabelTypes.SENSORS.ordinal()] = (int)activeSensors.toLongArray()[0];
        scores[ScoreLabelTypes.SENSOR_VARIO.ordinal()] = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO) ? 1000 : 0;
        scores[ScoreLabelTypes.SENSOR_GPS.ordinal()] = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS) ? 1000 : 0;
        scores[ScoreLabelTypes.SENSOR_GAM.ordinal()] = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM) ? 1000 : 0;
        scores[ScoreLabelTypes.SENSOR_EAM.ordinal()] = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM) ? 1000 : 0;
        scores[ScoreLabelTypes.SENSOR_ESC.ordinal()] = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC) ? 1000 : 0;
        scores[ScoreLabelTypes.SENSOR_COUNT.ordinal()] = (this.detectedSensors.size() - 1) * 1000;
        scores[ScoreLabelTypes.LOG_DATA_VERSION.ordinal()] = 4000;
        scores[ScoreLabelTypes.LOG_DATA_EXPLORER_VERSION.ordinal()] = 0;
        scores[ScoreLabelTypes.LOG_FILE_VERSION.ordinal()] = 0;
        scores[ScoreLabelTypes.LOG_RECORD_SET_BYTES.ordinal()] = histoRandomSample.getReadingCount() * 64;
        scores[ScoreLabelTypes.LOG_FILE_BYTES.ordinal()] = (int)vault.getLogFileLength();
        scores[ScoreLabelTypes.LOG_FILE_RECORD_SETS.ordinal()] = (this.detectedSensors.size() + 1) * 1000;
        scores[ScoreLabelTypes.ELAPSED_HISTO_RECORD_SET_MS.ordinal()] = (int)TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - this.nanoTime);
        return scores;
    }

    protected void writeFinalLog(boolean isTextModusSignaled, @Nullable PackageLoss lostPackages, UniversalSampler histoRandomSample, ExtendedVault vault) {
        int lossTotal;
        int n = lossTotal = lostPackages == null ? 0 : lostPackages.lossTotal;
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, String.format("%s > packages:%,9d  readings:%,9d  sampled:%,9d  overSampled:%4d", this.tmpRecordSet.getChannelConfigName(), vault.getLogFileLength() / 64L, histoRandomSample.getReadingCount(), this.tmpRecordSet.getRecordDataSize(true), histoRandomSample.getOverSamplingCount()));
        }
        if (log.isLoggable(Level.TIME)) {
            log.log(Level.TIME, String.format("initiateTime: %,7d  readTime: %,7d  reviewTime: %,7d  addTime: %,7d  pickTime: %,7d  finishTime: %,7d", TimeUnit.NANOSECONDS.toMillis(this.initiateTime), TimeUnit.NANOSECONDS.toMillis(this.readTime), TimeUnit.NANOSECONDS.toMillis(this.reviewTime), TimeUnit.NANOSECONDS.toMillis(this.addTime), TimeUnit.NANOSECONDS.toMillis(this.pickTime), TimeUnit.NANOSECONDS.toMillis(this.finishTime)));
        }
        if (lostPackages != null) {
            if (this.tmpRecordSet.getMaxTime_ms() > 0.0) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("lost:%,9d perMille:%,4d total:%,9d   lostMax_ms:%,4d lostAvg_ms=%,4d", lossTotal, (int)((double)lossTotal / this.tmpRecordSet.getMaxTime_ms() * 1000.0 * 10.0), vault.getLogFileLength() / 64L, lostPackages.getMaxValue() * 10, (int)lostPackages.getAvgValue() * 10));
                }
            } else {
                log.log(Level.WARNING, String.format("RecordSet with unidentified data.  fileLength=%,11d   isTextModusSignaled=%b   %s", vault.getLogFileLength(), isTextModusSignaled, vault.getLoadFilePath()));
            }
        }
    }

    @FunctionalInterface
    static interface Procedure {
        public void invoke();
    }
}

