/*
 * Decompiled with CFR 0.152.
 */
package gde.device.igc;

import gde.device.igc.GpsLap;
import gde.utils.StringHelper;
import java.util.HashMap;
import java.util.Vector;

public class GpsTaskResult
extends HashMap<String, String> {
    private static final long serialVersionUID = 3386446540799897163L;
    private Vector<GpsLap> gpsLaps = new Vector();

    public GpsTaskResult() {
    }

    public GpsTaskResult(String input) {
        this.add(input);
    }

    public void addLap(GpsLap lap) {
        this.gpsLaps.add(lap);
    }

    public void add(String input) {
        String[] entries;
        for (String entry : entries = input.substring(input.indexOf(123) + 1, input.length() - 1).split(",")) {
            String[] value = entry.split(":");
            if (value.length != 2) continue;
            this.put(value[0].substring(1, value[0].length() - 1), value[1]);
        }
    }

    public double getAllTrianglesAvgSpeed() {
        if (this.get("allTrianglesAvgSpeed") != null) {
            return Double.parseDouble((String)this.get("allTrianglesAvgSpeed"));
        }
        if (this.get("speed") != null) {
            return Double.parseDouble((String)this.get("speed"));
        }
        return 0.0;
    }

    public int getAverageTriangleTime() {
        if (this.get("averageTriangleTime") != null) {
            return Double.valueOf((String)this.get("averageTriangleTime")).intValue();
        }
        return 0;
    }

    public long getCurrentTime() {
        if (this.get("currentTime") != null) {
            return Long.parseLong((String)this.get("currentTime"));
        }
        return 0L;
    }

    public double getDistanceCovered() {
        if (this.get("distanceCovered") != null) {
            return Double.parseDouble((String)this.get("distanceCovered"));
        }
        return 0.0;
    }

    public long getFlightStart() {
        if (this.get("flightStart") != null) {
            return Long.parseLong((String)this.get("flightStart"));
        }
        if (this.get("startTime") != null) {
            return Long.parseLong((String)this.get("startTime"));
        }
        return 0L;
    }

    public int getLaps() {
        if (this.get("laps") != null) {
            return Integer.parseInt((String)this.get("laps"));
        }
        return 0;
    }

    public Vector<GpsLap> getLapsStats() {
        return this.gpsLaps;
    }

    public void addGpsLap(GpsLap lap) {
        this.gpsLaps.add(lap);
    }

    public double getLastStartAltitude() {
        if (this.get("lastStartAltitude") != null) {
            return Double.parseDouble((String)this.get("lastStartAltitude"));
        }
        return 0.0;
    }

    public long getLastStartCrossing() {
        if (this.get("lastStartCrossing") != null) {
            return Long.parseLong((String)this.get("lastStartCrossing"));
        }
        return 0L;
    }

    public double getLastTriangleAvgSpeed() {
        if (this.get("lastTriangleAvgSpeed") != null) {
            return Double.parseDouble((String)this.get("lastTriangleAvgSpeed"));
        }
        return 0.0;
    }

    public double getLastTriangleIndex() {
        if (this.get("lastTriangleIndex") != null) {
            return Double.parseDouble((String)this.get("lastTriangleIndex"));
        }
        return 0.0;
    }

    public double getLastTriangleTime() {
        if (this.get("lastTriangleTime") != null) {
            return Double.parseDouble((String)this.get("lastTriangleTime"));
        }
        return 0.0;
    }

    public int getScoringCode() {
        if (this.get("scoringCode") != null) {
            return Integer.parseInt((String)this.get("scoringCode"));
        }
        return 0;
    }

    public double getStartAltitude() {
        if (this.get("startAltitude") != null) {
            return Double.parseDouble((String)this.get("startAltitude"));
        }
        if (this.get("startAlt") != null) {
            return Double.parseDouble((String)this.get("startAlt"));
        }
        return 0.0;
    }

    public double getStartEntryAlti() {
        if (this.get("startEntryAlti") != null) {
            return Double.parseDouble((String)this.get("startEntryAlti"));
        }
        if (this.get("startAlt") != null) {
            return Double.parseDouble((String)this.get("startAlt"));
        }
        return 0.0;
    }

    public double getStartEntrySpeed() {
        if (this.get("startEntrySpeed") != null) {
            return Double.parseDouble((String)this.get("startEntrySpeed"));
        }
        if (this.get("startSpeed") != null) {
            return Double.parseDouble((String)this.get("startSpeed"));
        }
        return 0.0;
    }

    public boolean getSignatureValid() {
        return Boolean.parseBoolean((String)this.get("signatureValid"));
    }

    public int getStartPenaltyPoints() {
        if (this.get("startPenaltyPoints") != null) {
            return Integer.parseInt((String)this.get("startPenaltyPoints"));
        }
        if (this.get("penaltyPoints") != null) {
            return Integer.parseInt((String)this.get("penaltyPoints"));
        }
        return 0;
    }

    public int getTaskHeight() {
        return Integer.parseInt((String)this.get("taskHeight"));
    }

    public int getTaskLength() {
        if (this.get("taskLength") != null) {
            return Integer.parseInt((String)this.get("taskLength"));
        }
        if (this.get("taskLen") != null) {
            return Integer.parseInt((String)this.get("taskLen"));
        }
        return 0;
    }

    public int getTimeElapsedSeconds() {
        if (this.get("timeElapsedSeconds") != null) {
            return Integer.parseInt((String)this.get("timeElapsedSeconds"));
        }
        if (this.get("flightTime") != null) {
            return Integer.parseInt((String)this.get("flightTime"));
        }
        return 0;
    }

    public double getTriangleAlt() {
        return Double.parseDouble((String)this.get("triangleAlt"));
    }

    public boolean getZoneEntered() {
        if (this.get("zoneEntered") != null) {
            return Boolean.parseBoolean((String)this.get("zoneEntered"));
        }
        if (this.get("penaltyZoneHit") != null) {
            return Boolean.parseBoolean((String)this.get("penaltyZoneHit"));
        }
        return false;
    }

    public String getFormatedTime(int time) {
        int minutes = time / 60;
        return String.format("%2d:%02d", minutes, time - minutes * 60);
    }

    public String toString(String taskType) {
        StringBuilder sb = new StringBuilder("\n\n");
        sb.append(String.format("Task: %s  Date Time: %s  Duration: %s [mm:ss]\n", taskType, StringHelper.getFormatedTime((String)"yyyy-MM-dd, HH:mm:ss", (long)this.getFlightStart()), this.getFormatedTime(this.getTimeElapsedSeconds())));
        sb.append(String.format("Start Alt/Speed: %3.0f m/%6.2f km/h  Penalty: %d  SavetyZoneHit: %b\n", this.getStartEntryAlti(), this.getStartEntrySpeed() * 3.6, this.getStartPenaltyPoints(), this.getZoneEntered()));
        if (this.getLaps() > 0) {
            if (this.get("averageTriangleTime") != null) {
                sb.append(String.format("Laps: %2d  AvgSpeed: %5.2f km/h  AvgLapTime: %s\n", this.getLaps(), this.getAllTrianglesAvgSpeed() * 3.6, this.getFormatedTime(this.getAverageTriangleTime())));
            } else {
                sb.append(String.format("Laps: %2d  AvgSpeed: %5.2f km/h  AvgLapTime: %s\n", this.getLaps(), this.getAllTrianglesAvgSpeed() * 3.6, this.getFormatedTime(this.getTimeElapsedSeconds() / this.getLaps())));
            }
        }
        sb.append("\nLAP INDEX DURATION LAP-TIME  ALT  \u2206ALT LapSpeed IndexSpeed  Ratio   Sink");
        sb.append("\n[#]  [%]  [mm:ss]   [mm:ss]  [m]   [m]  [km/h]   [km/h]     [m/1]   [m/s]\n");
        int lapNo = 1;
        Double duration = 0.0;
        for (GpsLap lap : this.gpsLaps) {
            sb.append(lap.toString(lapNo++, duration, taskType));
            duration = duration + lap.getTime();
        }
        return sb.toString();
    }
}

