/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi.modbus;

import gde.device.IDevice;
import gde.device.junsi.iChargerUsbPort;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.util.logging.Logger;

public class ChargerUsbPort
extends iChargerUsbPort {
    static final String $CLASS_NAME = ChargerUsbPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    protected static final byte MB_HID_PROTOCOL_ID = 48;
    protected static final int HID_PACK_MAX = 64;
    protected static final byte HID_PACK_CH = 0;
    protected static final byte HID_PACK_LEN = 1;
    protected static final byte HID_PACK_TYPE = 2;
    protected static final byte HID_PACK_MODBUS = 3;
    protected static final byte REPORT_ID = 0;
    protected static final byte MB_FUNC_NONE = 0;
    protected static final byte MB_FUNC_READ_COILS = 1;
    protected static final byte MB_FUNC_READ_DISCRETE_INPUTS = 2;
    protected static final byte MB_FUNC_WRITE_SINGLE_COIL = 5;
    protected static final byte MB_FUNC_WRITE_MULTIPLE_COILS = 15;
    protected static final byte MB_FUNC_READ_HOLDING_REGISTER = 3;
    protected static final byte MB_FUNC_READ_INPUT_REGISTER = 4;
    protected static final byte MB_FUNC_WRITE_REGISTER = 6;
    protected static final byte MB_FUNC_WRITE_MULTIPLE_REGISTERS = 16;
    protected static final byte MB_FUNC_READWRITE_MULTIPLE_REGISTERS = 23;
    protected static final byte MB_FUNC_DIAG_READ_EXCEPTION = 7;
    protected static final byte MB_FUNC_DIAG_DIAGNOSTIC = 8;
    protected static final byte MB_FUNC_DIAG_GET_COM_EVENT_CNT = 11;
    protected static final byte MB_FUNC_DIAG_GET_COM_EVENT_LOG = 12;
    protected static final byte MB_FUNC_OTHER_REPORT_SLAVEID = 17;
    protected static final byte MB_FUNC_ERROR = -128;
    protected static final byte READ_REG_COUNT_MAX = 30;
    protected static final byte WRITE_REG_COUNT_MAX = 28;

    public ChargerUsbPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
    }

    ModBusErrorCode masterRead(byte readType, short regStart, short regCount, byte[] pOut) throws IllegalStateException, TimeOutException {
        ModBusErrorCode ret = ModBusErrorCode.MB_EOK;
        byte[] inBuf = new byte[16];
        int indexOut = 0;
        byte funCode = readType == 0 ? (byte)3 : 4;
        for (int i = 0; i < regCount / 30; i = (int)((short)(i + 1))) {
            inBuf[0] = (byte)(regStart >> 8);
            inBuf[1] = (byte)(regStart & 0xFF);
            inBuf[2] = 0;
            inBuf[3] = 30;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("transfer data length = %d indexOut = %d", inBuf[3], indexOut));
            }
            if ((ret = this.masterModBus(funCode, inBuf, pOut, indexOut, 1200L)) != ModBusErrorCode.MB_EOK) {
                return ret;
            }
            regStart = (short)(regStart + 30);
            indexOut += 60;
        }
        if (regCount % 30 != 0) {
            inBuf[0] = (byte)(regStart >> 8);
            inBuf[1] = (byte)(regStart & 0xFF);
            inBuf[2] = 0;
            inBuf[3] = (byte)(regCount % 30);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("transfer data length = %d indexOut = %d", inBuf[3], indexOut));
            }
            if ((ret = this.masterModBus(funCode, inBuf, pOut, indexOut, 1200L)) != ModBusErrorCode.MB_EOK) {
                return ret;
            }
        }
        return ret;
    }

    ModBusErrorCode masterWrite(short regStart, short regCount, byte[] pIn) throws IllegalStateException, TimeOutException {
        short j;
        ModBusErrorCode ret = ModBusErrorCode.MB_EOK;
        byte[] inBuf = new byte[80];
        int indexIn = 0;
        for (int i = 0; i < regCount / 28; i = (int)((short)(i + 1))) {
            inBuf[0] = (byte)(regStart >> 8);
            inBuf[1] = (byte)(regStart & 0xFF);
            inBuf[2] = 0;
            inBuf[3] = 28;
            inBuf[4] = 56;
            for (j = 0; j < inBuf[4]; j = (short)(j + 2)) {
                inBuf[5 + j] = pIn[indexIn + j + 1];
                inBuf[5 + j + 1] = pIn[indexIn + j];
            }
            ret = this.masterModBus((byte)16, inBuf, null, 0, 1200L);
            if (ret != ModBusErrorCode.MB_EOK) {
                return ret;
            }
            regStart = (short)(regStart + 28);
            indexIn += 56;
        }
        if (regCount % 28 != 0) {
            inBuf[0] = (byte)(regStart >> 8);
            inBuf[1] = (byte)(regStart & 0xFF);
            inBuf[2] = 0;
            inBuf[3] = (byte)(regCount % 28);
            inBuf[4] = (byte)(2 * inBuf[3]);
            for (j = 0; j < inBuf[4]; j = (short)(j + 2)) {
                inBuf[5 + j] = pIn[indexIn + j + 1];
                inBuf[5 + j + 1] = pIn[indexIn + j];
            }
            ret = this.masterModBus((byte)16, inBuf, null, 0, 1200L);
            if (ret != ModBusErrorCode.MB_EOK) {
                return ret;
            }
        }
        return ret;
    }

    ModBusErrorCode masterModBus(byte funCode, byte[] pIn, byte[] pOut, int outIndex, long timeOut_ms) throws IllegalStateException, TimeOutException {
        int i;
        byte[] hidBuf = new byte[64];
        hidBuf[1] = 48;
        hidBuf[2] = funCode;
        switch (funCode) {
            case 4: {
                hidBuf[0] = 7;
                break;
            }
            case 3: {
                hidBuf[0] = 7;
                break;
            }
            case 16: {
                hidBuf[0] = (byte)(7 + (pIn[4] + 1));
                if (hidBuf[0] <= 64) break;
                return ModBusErrorCode.MB_ELEN;
            }
            default: {
                return ModBusErrorCode.MB_EILLFUNCTION;
            }
        }
        for (i = 0; i < hidBuf[0] - 3; ++i) {
            hidBuf[3 + i] = pIn[i];
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "write " + StringHelper.byte2Hex2CharString((byte[])hidBuf, (int)hidBuf.length));
        }
        this.write(this.libUsbHandle, this.endpointIn, hidBuf, timeOut_ms);
        this.read(this.libUsbHandle, this.endpointOut, hidBuf, timeOut_ms);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "read  " + StringHelper.byte2Hex2CharString((byte[])hidBuf, (int)hidBuf.length));
        }
        if (hidBuf[0] > 64) {
            return ModBusErrorCode.MB_ELEN;
        }
        if (hidBuf[2] == funCode) {
            switch (funCode) {
                case 3: 
                case 4: {
                    if (hidBuf[0] != hidBuf[3] + 4 || (hidBuf[0] & 1) != 0) {
                        return ModBusErrorCode.MB_ELEN;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, String.format("copy to pOut data length = %d", hidBuf[3]));
                    }
                    for (i = 0; i < hidBuf[3] && i + outIndex < pOut.length; i += 2) {
                        pOut[i + outIndex] = hidBuf[4 + i + 1];
                        pOut[i + 1 + outIndex] = hidBuf[4 + i];
                    }
                    break;
                }
                case 16: {
                    hidBuf[0] = (byte)(5 + (hidBuf[7] * 2 + 1));
                }
            }
        } else {
            if (hidBuf[2] == (funCode | 0x80)) {
                return ModBusErrorCode.fromErrorByte(hidBuf[3]);
            }
            return ModBusErrorCode.MB_ERETURN;
        }
        return ModBusErrorCode.MB_EOK;
    }

    static enum ModBusErrorCode {
        MB_EOK(0),
        MB_EX_ILLEGAL_FUNCTION(1),
        MB_EX_ILLEGAL_DATA_ADDRESS(2),
        MB_EX_ILLEGAL_DATA_VALUE(3),
        MB_EX_SLAVE_DEVICE_FAILURE(4),
        MB_EX_ACKNOWLEDGE(5),
        MB_EX_SLAVE_BUSY(6),
        MB_EX_MEMORY_PARITY_ERROR(8),
        MB_EX_GATEWAY_PATH_FAILED(10),
        MB_EX_GATEWAY_TGT_FAILED(11),
        MB_ENOREG(128),
        MB_EILLFUNCTION(240),
        MB_EIO(241),
        MB_ERETURN(242),
        MB_ELEN(243),
        MB_ETIMEDOUT(244),
        MB_INVALID(245);

        final int value;
        public static final ModBusErrorCode[] VALUES;

        private ModBusErrorCode(int value) {
            this.value = value;
        }

        public static ModBusErrorCode fromErrorByte(byte errorCodeValue) {
            for (ModBusErrorCode errorCode : VALUES) {
                if (errorCode.value != errorCodeValue) continue;
                return errorCode;
            }
            return MB_INVALID;
        }

        static {
            VALUES = ModBusErrorCode.values();
        }
    }
}

