/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.tab;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.menu.TabAreaContextMenu;
import gde.ui.tab.GraphicsWindow;
import gde.utils.CurveUtils;
import gde.utils.GraphicsUtils;
import gde.utils.LocalizedDateTime;
import gde.utils.StringHelper;
import gde.utils.TimeLine;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GraphicsComposite
extends Composite {
    static final Logger log = Logger.getLogger(GraphicsComposite.class.getName());
    protected static final int DEFAULT_TOP_GAP = 10;
    protected static final int DEFAULT_HEADER_GAP = 5;
    protected static final int DEFAULT_COMMENT_GAP = 5;
    final DataExplorer application = DataExplorer.getInstance();
    final Settings settings = Settings.getInstance();
    final Channels channels = Channels.getInstance();
    final TimeLine timeLine = new TimeLine();
    final SashForm graphicSashForm;
    final GraphicsWindow.GraphicsType graphicsType;
    Menu popupmenu;
    TabAreaContextMenu contextMenu;
    Color curveAreaBackground;
    Color surroundingBackground;
    Color curveAreaBorderColor;
    Text graphicsHeader;
    Text recordSetComment;
    boolean isRecordCommentChanged = false;
    Canvas graphicCanvas;
    int headerHeight = 0;
    int headerGap = 0;
    int commentHeight = 0;
    int commentGap = 0;
    String graphicsHeaderText;
    String recordSetCommentText;
    Point oldSize = new Point(0, 0);
    RecordSet oldActiveRecordSet = null;
    int oldChangeCounter = 0;
    boolean isFileCommentChanged = false;
    HashMap<String, Integer> leftSideScales = new HashMap();
    HashMap<String, Integer> rightSideScales = new HashMap();
    int oldScopeLevel = 0;
    boolean oldZoomLevel = false;
    int xDown = 0;
    int xUp = 0;
    int xLast = 0;
    int yDown = 0;
    int yUp = 0;
    int yLast = 0;
    int leftLast = 0;
    int topLast = 0;
    int rightLast = 0;
    int bottomLast = 0;
    int offSetX;
    int offSetY;
    Rectangle canvasBounds;
    Image canvasImage;
    GC canvasImageGC;
    Rectangle curveAreaBounds = new Rectangle(0, 0, 1, 1);
    GraphicsMode actualModeState;
    boolean isLeftMouseMeasure = false;
    boolean isRightMouseMeasure = false;
    int xPosMeasure = 0;
    int yPosMeasure = 0;
    int xPosDelta = 0;
    int yPosDelta = 0;
    boolean isZoomMouse = false;
    boolean isResetZoomPosition = false;
    boolean isTransientZoom = false;
    boolean isTransientGesture = false;
    boolean isZoomX = false;
    boolean isZoomY = false;
    int leftZoom;
    int topZoom;
    int widthZoom;
    int heightZoom;
    boolean isPanMouse = false;
    int xDeltaPan = 0;
    int yDeltaPan = 0;
    boolean isLeftCutMode = false;
    boolean isRightCutMode = false;
    int xPosCut = 0;
    boolean isScopeMode = false;

    GraphicsComposite(SashForm useParent, GraphicsWindow.GraphicsType useGraphicsType) {
        super((Composite)useParent, 0);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.graphicSashForm = useParent;
        this.graphicsType = useGraphicsType;
        switch (this.graphicsType) {
            case COMPARE: {
                this.curveAreaBackground = this.settings.getCompareCurveAreaBackground();
                this.surroundingBackground = this.settings.getCompareSurroundingBackground();
                this.curveAreaBorderColor = this.settings.getCurveCompareBorderColor();
                break;
            }
            case UTIL: {
                this.curveAreaBackground = this.settings.getUtilityCurveAreaBackground();
                this.surroundingBackground = this.settings.getUtilitySurroundingBackground();
                this.curveAreaBorderColor = this.settings.getUtilityCurvesBorderColor();
                break;
            }
            default: {
                this.curveAreaBackground = this.settings.getGraphicsCurveAreaBackground();
                this.surroundingBackground = this.settings.getGraphicsSurroundingBackground();
                this.curveAreaBorderColor = this.settings.getGraphicsCurvesBorderColor();
            }
        }
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.contextMenu = new TabAreaContextMenu();
        this.init();
    }

    void init() {
        this.setLayout(null);
        this.setDragDetect(false);
        this.setBackground(this.surroundingBackground);
        this.contextMenu.createMenu(this.popupmenu, this.graphicsType.toTabType());
        this.addListener(11, new Listener(){

            public void handleEvent(Event evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "GraphicsComposite.controlResized() = " + evt);
                }
                Rectangle clientRect = GraphicsComposite.this.getClientArea();
                Point size = new Point(clientRect.width, clientRect.height);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, GraphicsComposite.this.oldSize + " - " + size);
                }
                if (!GraphicsComposite.this.oldSize.equals((Object)size)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "size changed, update " + GraphicsComposite.this.oldSize + " - " + size);
                    }
                    GraphicsComposite.this.oldSize = size;
                    GraphicsComposite.this.setComponentBounds();
                    GraphicsComposite.this.doRedrawGraphics();
                }
            }
        });
        this.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "GraphicsComposite.helpRequested " + evt);
                }
                switch (GraphicsComposite.this.graphicsType) {
                    default: {
                        GraphicsComposite.this.application.openHelpDialog("", "HelpInfo_4.html");
                        break;
                    }
                    case COMPARE: {
                        GraphicsComposite.this.application.openHelpDialog("", "HelpInfo_91.html");
                        break;
                    }
                    case UTIL: {
                        GraphicsComposite.this.application.openHelpDialog("", "HelpInfo_4.html");
                    }
                }
            }
        });
        this.graphicsHeader = new Text((Composite)this, 0x1000004);
        this.graphicsHeader.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 3, 1));
        this.graphicsHeader.setBackground(this.surroundingBackground);
        this.graphicsHeader.setMenu(this.popupmenu);
        this.graphicsHeader.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "recordSetHeader.helpRequested " + evt);
                }
                GraphicsComposite.this.application.openHelpDialog("", "HelpInfo_4.html");
            }
        });
        this.graphicsHeader.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "recordSetHeader.paintControl, event=" + evt);
                }
                if (GraphicsComposite.this.graphicsType == GraphicsWindow.GraphicsType.UTIL) {
                    if (GraphicsComposite.this.application.isWithUtilitySet()) {
                        RecordSet utilitySet = GraphicsComposite.this.application.getUtilitySet();
                        String tmpHeader = utilitySet.getRecordSetDescription();
                        if (GraphicsComposite.this.graphicsHeaderText == null || !tmpHeader.equals(GraphicsComposite.this.graphicsHeaderText)) {
                            GraphicsComposite.this.graphicsHeaderText = tmpHeader;
                            GraphicsComposite.this.graphicsHeader.setText(GraphicsComposite.this.graphicsHeaderText);
                        }
                    }
                } else {
                    RecordSet recordSet;
                    Channel activeChannel = GraphicsComposite.this.channels.getActiveChannel();
                    if (activeChannel != null && (recordSet = activeChannel.getActiveRecordSet()) != null) {
                        String tmpDescription = activeChannel.getFileDescription();
                        if (tmpDescription.contains(":")) {
                            tmpDescription = tmpDescription.substring(0, tmpDescription.indexOf(":"));
                        }
                        if (tmpDescription.contains(";")) {
                            tmpDescription = tmpDescription.substring(0, tmpDescription.indexOf(";"));
                        }
                        if (tmpDescription.contains("\r")) {
                            tmpDescription = tmpDescription.substring(0, tmpDescription.indexOf("\r"));
                        }
                        if (tmpDescription.contains("\n")) {
                            tmpDescription = tmpDescription.substring(0, tmpDescription.indexOf("\n"));
                        }
                        String tmpHeader = tmpDescription + " - " + recordSet.getName();
                        if (GraphicsComposite.this.graphicsHeaderText == null || !tmpHeader.equals(GraphicsComposite.this.graphicsHeaderText)) {
                            GraphicsComposite.this.graphicsHeaderText = tmpHeader;
                            GraphicsComposite.this.graphicsHeader.setText(GraphicsComposite.this.graphicsHeaderText);
                        }
                    }
                }
            }
        });
        this.graphicsHeader.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "fileCommentText.keyPressed , event=" + e);
                }
                GraphicsComposite.this.isFileCommentChanged = true;
            }
        });
        this.graphicsHeader.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "fileCommentText.focusLost() , event=" + evt);
                }
                GraphicsComposite.this.isFileCommentChanged = false;
                GraphicsComposite.this.setFileComment();
            }

            public void focusGained(FocusEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "fileCommentText.focusGained() , event=" + evt);
                }
            }
        });
        this.graphicCanvas = new Canvas((Composite)this, 0);
        this.graphicCanvas.setBackground(this.surroundingBackground);
        this.graphicCanvas.setMenu(this.popupmenu);
        this.graphicCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "graphicCanvas.mouseMove = " + evt);
                }
                GraphicsComposite.this.mouseMoveAction(evt);
            }
        });
        this.graphicCanvas.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "graphicCanvas.mouseExit, event=" + evt);
                }
                GraphicsComposite.this.graphicCanvas.setCursor(GraphicsComposite.this.application.getCursor());
            }
        });
        this.graphicCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "graphicCanvas.mouseDown, event=" + evt);
                }
                if (evt.button == 1) {
                    GraphicsComposite.this.mouseDownAction(evt);
                }
            }

            public void mouseUp(MouseEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "graphicCanvas.mouseUp, event=" + evt);
                }
                if (evt.button == 1) {
                    GraphicsComposite.this.mouseUpAction(evt);
                }
            }
        });
        this.graphicCanvas.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "graphicCanvas.keyPressed() , event=" + e);
                }
                if (GraphicsComposite.this.isTransientZoom && !GraphicsComposite.this.isTransientGesture) {
                    GraphicsComposite.this.isResetZoomPosition = false;
                    Channel activeChannel = Channels.getInstance().getActiveChannel();
                    if (activeChannel != null) {
                        RecordSet recordSet;
                        RecordSet recordSet2 = recordSet = GraphicsComposite.this.graphicsType == GraphicsWindow.GraphicsType.NORMAL ? Channels.getInstance().getActiveChannel().getActiveRecordSet() : GraphicsComposite.this.application.getCompareSet();
                        if (GraphicsComposite.this.canvasImage != null && recordSet != null) {
                            if (e.keyCode == 120) {
                                GraphicsComposite.this.isZoomX = true;
                                GraphicsComposite.this.isZoomY = false;
                            } else if (e.keyCode == 121) {
                                GraphicsComposite.this.isZoomY = true;
                                GraphicsComposite.this.isZoomX = false;
                            } else if (e.keyCode == 43 || e.keyCode == 16777259) {
                                int yMax;
                                int yMin;
                                int xEnd;
                                int xStart;
                                float boundsRelation = 1.0f * (float)GraphicsComposite.this.curveAreaBounds.width / (float)GraphicsComposite.this.curveAreaBounds.height;
                                Point point = new Point(GraphicsComposite.this.canvasBounds.width / 2, GraphicsComposite.this.canvasBounds.height / 2);
                                float mouseRelationX = 1.0f * (float)point.x / (float)GraphicsComposite.this.curveAreaBounds.width * 2.0f;
                                float mouseRelationY = 1.0f * (float)point.y / (float)GraphicsComposite.this.curveAreaBounds.height * 2.0f;
                                if (GraphicsComposite.this.isZoomX) {
                                    xStart = (int)(50.0f * boundsRelation * mouseRelationX);
                                    xEnd = (int)((float)GraphicsComposite.this.curveAreaBounds.width - 50.0f * boundsRelation * (2.0f - mouseRelationX));
                                    yMin = 0;
                                    yMax = GraphicsComposite.this.curveAreaBounds.height - GraphicsComposite.this.curveAreaBounds.y;
                                } else if (GraphicsComposite.this.isZoomY) {
                                    xStart = 0;
                                    xEnd = GraphicsComposite.this.curveAreaBounds.width;
                                    yMin = (int)(50.0f * (2.0f - mouseRelationY));
                                    yMax = (int)((float)GraphicsComposite.this.curveAreaBounds.height - 50.0f * mouseRelationY);
                                } else {
                                    xStart = (int)(50.0f * boundsRelation * mouseRelationX);
                                    xEnd = (int)((float)GraphicsComposite.this.curveAreaBounds.width - 50.0f * boundsRelation * (2.0f - mouseRelationX));
                                    yMin = (int)(50.0f * (2.0f - mouseRelationY));
                                    yMax = (int)((float)GraphicsComposite.this.curveAreaBounds.height - 50.0f * mouseRelationY);
                                }
                                if (log.isLoggable(Level.FINEST)) {
                                    log.log(Level.FINEST, "zoom xStart = " + xStart + " xEnd = " + xEnd + " yMin = " + yMin + " yMax = " + yMax);
                                }
                                if (xEnd - xStart > 5 && yMax - yMin > 5) {
                                    recordSet.setDisplayZoomBounds(new Rectangle(xStart, yMin, xEnd - xStart, yMax - yMin));
                                    GraphicsComposite.this.redrawGraphics();
                                }
                            } else if (e.keyCode == 45 || e.keyCode == 16777261) {
                                if (GraphicsComposite.this.isTransientZoom && !GraphicsComposite.this.isTransientGesture) {
                                    int yMax;
                                    int yMin;
                                    int xEnd;
                                    int xStart;
                                    float boundsRelation = 1.0f * (float)GraphicsComposite.this.curveAreaBounds.width / (float)GraphicsComposite.this.curveAreaBounds.height;
                                    Point point = new Point(GraphicsComposite.this.canvasBounds.width / 2, GraphicsComposite.this.canvasBounds.height / 2);
                                    float mouseRelationX = 1.0f * (float)point.x / (float)GraphicsComposite.this.curveAreaBounds.width * 2.0f;
                                    float mouseRelationY = 1.0f * (float)point.y / (float)GraphicsComposite.this.curveAreaBounds.height * 2.0f;
                                    if (GraphicsComposite.this.isZoomX) {
                                        xStart = (int)(-50.0f * boundsRelation * mouseRelationX);
                                        xEnd = (int)((float)GraphicsComposite.this.curveAreaBounds.width + 50.0f * boundsRelation * (2.0f - mouseRelationX));
                                        yMin = 0;
                                        yMax = GraphicsComposite.this.curveAreaBounds.height - GraphicsComposite.this.curveAreaBounds.y;
                                    } else if (GraphicsComposite.this.isZoomY) {
                                        xStart = 0;
                                        xEnd = GraphicsComposite.this.curveAreaBounds.width;
                                        yMin = (int)(-50.0f * (2.0f - mouseRelationY));
                                        yMax = (int)((float)GraphicsComposite.this.curveAreaBounds.height + 50.0f * mouseRelationY);
                                    } else {
                                        xStart = (int)(-50.0f * boundsRelation * mouseRelationX);
                                        xEnd = (int)((float)GraphicsComposite.this.curveAreaBounds.width + 50.0f * boundsRelation * (2.0f - mouseRelationX));
                                        yMin = (int)(-50.0f * (2.0f - mouseRelationY));
                                        yMax = (int)((float)GraphicsComposite.this.curveAreaBounds.height + 50.0f * mouseRelationY);
                                    }
                                    if (log.isLoggable(Level.FINE)) {
                                        log.log(Level.FINE, "zoom xStart = " + xStart + " xEnd = " + xEnd + " yMin = " + yMin + " yMax = " + yMax);
                                    }
                                    if (xEnd - xStart > 5 && yMax - yMin > 5) {
                                        recordSet.setDisplayZoomBounds(new Rectangle(xStart, yMin, xEnd - xStart, yMax - yMin));
                                        GraphicsComposite.this.redrawGraphics();
                                    }
                                }
                            } else if (e.keyCode == 0x1000001) {
                                recordSet.shift(0, -5);
                                GraphicsComposite.this.redrawGraphics();
                            } else if (e.keyCode == 0x1000002) {
                                recordSet.shift(0, 5);
                                GraphicsComposite.this.redrawGraphics();
                            } else if (e.keyCode == 0x1000003) {
                                recordSet.shift(5, 0);
                                GraphicsComposite.this.redrawGraphics();
                            } else if (e.keyCode == 0x1000004) {
                                recordSet.shift(-5, 0);
                                GraphicsComposite.this.redrawGraphics();
                            } else {
                                GraphicsComposite.this.isZoomY = false;
                                GraphicsComposite.this.isZoomX = false;
                            }
                        }
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "graphicCanvas.keyReleased() , event=" + e);
                }
                GraphicsComposite.this.isZoomY = false;
                GraphicsComposite.this.isZoomX = false;
            }
        });
        this.graphicCanvas.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "graphicCanvas.mouseScrolled, event=" + evt);
                }
                if (GraphicsComposite.this.isTransientZoom && !GraphicsComposite.this.isTransientGesture) {
                    GraphicsComposite.this.isResetZoomPosition = false;
                    Channel activeChannel = Channels.getInstance().getActiveChannel();
                    if (activeChannel != null) {
                        RecordSet recordSet;
                        RecordSet recordSet2 = recordSet = GraphicsComposite.this.graphicsType == GraphicsWindow.GraphicsType.NORMAL ? Channels.getInstance().getActiveChannel().getActiveRecordSet() : GraphicsComposite.this.application.getCompareSet();
                        if (GraphicsComposite.this.canvasImage != null && recordSet != null) {
                            int yMax;
                            int yMin;
                            int xEnd;
                            int xStart;
                            float boundsRelation = 1.0f * (float)GraphicsComposite.this.curveAreaBounds.width / (float)GraphicsComposite.this.curveAreaBounds.height;
                            Point point = GraphicsComposite.this.checkCurveBounds(evt.x, evt.y);
                            float mouseRelationX = 1.0f * (float)point.x / (float)GraphicsComposite.this.curveAreaBounds.width * 2.0f;
                            float mouseRelationY = 1.0f * (float)point.y / (float)GraphicsComposite.this.curveAreaBounds.height * 2.0f;
                            if (evt.count < 0) {
                                if (GraphicsComposite.this.isZoomX) {
                                    xStart = (int)(-50.0f * boundsRelation * mouseRelationX);
                                    xEnd = (int)((float)GraphicsComposite.this.curveAreaBounds.width + 50.0f * boundsRelation * (2.0f - mouseRelationX));
                                    yMin = 0;
                                    yMax = GraphicsComposite.this.curveAreaBounds.height - GraphicsComposite.this.curveAreaBounds.y;
                                } else if (GraphicsComposite.this.isZoomY) {
                                    xStart = 0;
                                    xEnd = GraphicsComposite.this.curveAreaBounds.width;
                                    yMin = (int)(-50.0f * (2.0f - mouseRelationY));
                                    yMax = (int)((float)GraphicsComposite.this.curveAreaBounds.height + 50.0f * mouseRelationY);
                                } else {
                                    xStart = (int)(-50.0f * boundsRelation * mouseRelationX);
                                    xEnd = (int)((float)GraphicsComposite.this.curveAreaBounds.width + 50.0f * boundsRelation * (2.0f - mouseRelationX));
                                    yMin = (int)(-50.0f * (2.0f - mouseRelationY));
                                    yMax = (int)((float)GraphicsComposite.this.curveAreaBounds.height + 50.0f * mouseRelationY);
                                }
                            } else if (GraphicsComposite.this.isZoomX) {
                                xStart = (int)(50.0f * boundsRelation * mouseRelationX);
                                xEnd = (int)((float)GraphicsComposite.this.curveAreaBounds.width - 50.0f * boundsRelation * (2.0f - mouseRelationX));
                                yMin = 0;
                                yMax = GraphicsComposite.this.curveAreaBounds.height - GraphicsComposite.this.curveAreaBounds.y;
                            } else if (GraphicsComposite.this.isZoomY) {
                                xStart = 0;
                                xEnd = GraphicsComposite.this.curveAreaBounds.width;
                                yMin = (int)(50.0f * (2.0f - mouseRelationY));
                                yMax = (int)((float)GraphicsComposite.this.curveAreaBounds.height - 50.0f * mouseRelationY);
                            } else {
                                xStart = (int)(50.0f * boundsRelation * mouseRelationX);
                                xEnd = (int)((float)GraphicsComposite.this.curveAreaBounds.width - 50.0f * boundsRelation * (2.0f - mouseRelationX));
                                yMin = (int)(50.0f * (2.0f - mouseRelationY));
                                yMax = (int)((float)GraphicsComposite.this.curveAreaBounds.height - 50.0f * mouseRelationY);
                            }
                            if (log.isLoggable(Level.FINER)) {
                                log.log(Level.FINER, "zoom xStart = " + xStart + " xEnd = " + xEnd + " yMin = " + yMin + " yMax = " + yMax);
                            }
                            if (xEnd - xStart > 5 && yMax - yMin > 5) {
                                recordSet.setDisplayZoomBounds(new Rectangle(xStart, yMin, xEnd - xStart, yMax - yMin));
                                GraphicsComposite.this.redrawGraphics();
                            }
                        }
                    }
                }
            }
        });
        this.graphicCanvas.addGestureListener(new GestureListener(){

            public void gesture(GestureEvent evt) {
                if (evt.detail == 2) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "BEGIN = " + evt);
                    }
                    GraphicsComposite.this.isTransientGesture = true;
                } else if (evt.detail == 32) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "MAGIFY = " + evt);
                    }
                    if (GraphicsComposite.this.isTransientGesture) {
                        GraphicsComposite.this.isResetZoomPosition = false;
                        Channel activeChannel = Channels.getInstance().getActiveChannel();
                        if (activeChannel != null) {
                            RecordSet recordSet;
                            RecordSet recordSet2 = recordSet = GraphicsComposite.this.graphicsType == GraphicsWindow.GraphicsType.NORMAL ? Channels.getInstance().getActiveChannel().getActiveRecordSet() : GraphicsComposite.this.application.getCompareSet();
                            if (GraphicsComposite.this.canvasImage != null && recordSet != null) {
                                int yMax;
                                int yMin;
                                int xEnd;
                                int xStart;
                                float boundsRelation = 1.0f * (float)GraphicsComposite.this.curveAreaBounds.width / (float)GraphicsComposite.this.curveAreaBounds.height;
                                Point point = GraphicsComposite.this.checkCurveBounds(evt.x, evt.y);
                                float mouseRelationX = 1.0f * (float)point.x / (float)GraphicsComposite.this.curveAreaBounds.width * 2.0f;
                                float mouseRelationY = 1.0f * (float)point.y / (float)GraphicsComposite.this.curveAreaBounds.height * 2.0f;
                                if (evt.magnification < 1.0) {
                                    if (GraphicsComposite.this.isZoomX) {
                                        xStart = (int)(-25.0f * boundsRelation * mouseRelationX);
                                        xEnd = (int)((float)GraphicsComposite.this.curveAreaBounds.width + 25.0f * boundsRelation * (2.0f - mouseRelationX));
                                        yMin = 0;
                                        yMax = GraphicsComposite.this.curveAreaBounds.height - GraphicsComposite.this.curveAreaBounds.y;
                                    } else if (GraphicsComposite.this.isZoomY) {
                                        xStart = 0;
                                        xEnd = GraphicsComposite.this.curveAreaBounds.width;
                                        yMin = (int)(-25.0f * (2.0f - mouseRelationY));
                                        yMax = (int)((float)GraphicsComposite.this.curveAreaBounds.height + 25.0f * mouseRelationY);
                                    } else {
                                        xStart = (int)(-25.0f * boundsRelation * mouseRelationX);
                                        xEnd = (int)((float)GraphicsComposite.this.curveAreaBounds.width + 25.0f * boundsRelation * (2.0f - mouseRelationX));
                                        yMin = (int)(-25.0f * (2.0f - mouseRelationY));
                                        yMax = (int)((float)GraphicsComposite.this.curveAreaBounds.height + 25.0f * mouseRelationY);
                                    }
                                } else if (GraphicsComposite.this.isZoomX) {
                                    xStart = (int)(25.0f * boundsRelation * mouseRelationX);
                                    xEnd = (int)((float)GraphicsComposite.this.curveAreaBounds.width - 25.0f * boundsRelation * (2.0f - mouseRelationX));
                                    yMin = 0;
                                    yMax = GraphicsComposite.this.curveAreaBounds.height - GraphicsComposite.this.curveAreaBounds.y;
                                } else if (GraphicsComposite.this.isZoomY) {
                                    xStart = 0;
                                    xEnd = GraphicsComposite.this.curveAreaBounds.width;
                                    yMin = (int)(25.0f * (2.0f - mouseRelationY));
                                    yMax = (int)((float)GraphicsComposite.this.curveAreaBounds.height - 25.0f * mouseRelationY);
                                } else {
                                    xStart = (int)(25.0f * boundsRelation * mouseRelationX);
                                    xEnd = (int)((float)GraphicsComposite.this.curveAreaBounds.width - 25.0f * boundsRelation * (2.0f - mouseRelationX));
                                    yMin = (int)(25.0f * (2.0f - mouseRelationY));
                                    yMax = (int)((float)GraphicsComposite.this.curveAreaBounds.height - 25.0f * mouseRelationY);
                                }
                                if (log.isLoggable(Level.FINER)) {
                                    log.log(Level.FINER, "zoom xStart = " + xStart + " xEnd = " + xEnd + " yMin = " + yMin + " yMax = " + yMax);
                                }
                                if (xEnd - xStart > 5 && yMax - yMin > 5) {
                                    recordSet.setDisplayZoomBounds(new Rectangle(xStart, yMin, xEnd - xStart, yMax - yMin));
                                    GraphicsComposite.this.redrawGraphics();
                                }
                            }
                        }
                    }
                } else if (evt.detail == 64) {
                    Channel activeChannel;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "PAN = " + evt);
                    }
                    if ((activeChannel = Channels.getInstance().getActiveChannel()) != null && GraphicsComposite.this.isTransientGesture) {
                        RecordSet recordSet;
                        RecordSet recordSet3 = recordSet = GraphicsComposite.this.graphicsType == GraphicsWindow.GraphicsType.NORMAL ? activeChannel.getActiveRecordSet() : GraphicsComposite.this.application.getCompareSet();
                        if (recordSet != null && GraphicsComposite.this.canvasImage != null) {
                            recordSet.shift(evt.xDirection, -1 * evt.yDirection);
                            GraphicsComposite.this.redrawGraphics();
                        }
                    }
                } else if (evt.detail == 4) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "END = " + evt);
                    }
                    GraphicsComposite.this.isTransientGesture = false;
                }
            }
        });
        this.graphicCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "graphicCanvas.paintControl, event=" + evt);
                }
                try {
                    GraphicsComposite.this.drawAreaPaintControl(evt);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage());
                }
            }
        });
        this.recordSetComment = new Text((Composite)this, 16386);
        this.recordSetComment.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE + 1, 0));
        this.recordSetComment.setBackground(this.surroundingBackground);
        this.recordSetComment.setMenu(this.popupmenu);
        this.recordSetComment.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                RecordSet recordSet;
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "recordSetComment.paintControl, event=" + evt);
                }
                if (GraphicsComposite.this.channels.getActiveChannel() != null && (recordSet = GraphicsComposite.this.channels.getActiveChannel().getActiveRecordSet()) != null) {
                    String tmpDescription = recordSet.getRecordSetDescription();
                    if (GraphicsComposite.this.recordSetCommentText == null || !tmpDescription.equals(GraphicsComposite.this.recordSetCommentText)) {
                        GraphicsComposite.this.recordSetCommentText = tmpDescription;
                        GraphicsComposite.this.recordSetComment.setText(GraphicsComposite.this.recordSetCommentText);
                    }
                }
            }
        });
        this.recordSetComment.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "recordSetCommentText.helpRequested " + evt);
                }
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_11.html");
            }
        });
        this.recordSetComment.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "recordSetComment.keyPressed() , event=" + e);
                }
                GraphicsComposite.this.isRecordCommentChanged = true;
            }
        });
        this.recordSetComment.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "recordSetComment.focusLost() , event=" + evt);
                }
                GraphicsComposite.this.updateRecordSetComment();
            }

            public void focusGained(FocusEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "recordSetComment.focusGained() , event=" + evt);
                }
            }
        });
    }

    void drawAreaPaintControl(PaintEvent evt) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawAreaPaintControl.paintControl, event=" + evt);
        }
        evt.gc.drawImage(this.canvasImage, 0, 0);
        RecordSet recordSet = null;
        switch (this.graphicsType) {
            case COMPARE: {
                if (!this.application.isWithCompareSet()) break;
                recordSet = this.application.getCompareSet();
                break;
            }
            case UTIL: {
                if (!this.application.isWithUtilitySet()) break;
                recordSet = this.application.getUtilitySet();
                break;
            }
            default: {
                if (this.channels.getActiveChannel() == null || this.channels.getActiveChannel().getActiveRecordSet() == null) break;
                recordSet = this.channels.getActiveChannel().getActiveRecordSet();
            }
        }
        if (recordSet != null && recordSet.realSize() > 0) {
            if (recordSet.isMeasurementMode(recordSet.getRecordKeyMeasurement()) || recordSet.isDeltaMeasurementMode(recordSet.getRecordKeyMeasurement())) {
                this.drawMeasurePointer(evt.gc, recordSet, GraphicsMode.MEASURE, this.xPosMeasure != 0);
            } else if (this.isLeftCutMode) {
                this.drawCutPointer(evt.gc, GraphicsMode.CUT_LEFT, true, false);
            } else if (this.isRightCutMode) {
                this.drawCutPointer(evt.gc, GraphicsMode.CUT_RIGHT, false, true);
            } else if (this.isZoomMouse && recordSet.isZoomMode() && this.isResetZoomPosition) {
                this.drawZoomBounds(evt.gc);
            }
        }
    }

    private void drawCurves(RecordSet recordSet, Rectangle bounds, GC gc) {
        if (this.isScopeMode) {
            int offset = recordSet.get(0).realSize() - recordSet.getScopeModeSize();
            if (offset < 1) {
                recordSet.setScopeModeOffset(0);
                recordSet.setScopeMode(false);
            } else {
                recordSet.setScopeModeOffset(offset);
                recordSet.setScopeMode(true);
            }
        }
        double totalDisplayDeltaTime_ms = recordSet.get(0).getDrawTimeWidth_ms();
        int[] timeScale = this.timeLine.getScaleMaxTimeNumber(totalDisplayDeltaTime_ms);
        int maxTimeFormated = timeScale[0];
        int scaleFactor = timeScale[1];
        int timeFormat = timeScale[2];
        int numberCurvesRight = 0;
        int numberCurvesLeft = 0;
        for (Record tmpRecord : recordSet.getRecordsSortedForDisplay()) {
            if (tmpRecord == null || !tmpRecord.isScaleVisible()) continue;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "==>> " + tmpRecord.getName() + " isScaleVisible = " + tmpRecord.isScaleVisible());
            }
            if (tmpRecord.isPositionLeft()) {
                ++numberCurvesLeft;
                continue;
            }
            ++numberCurvesRight;
        }
        if (recordSet.isCompareSet()) {
            numberCurvesLeft = 1;
            numberCurvesRight = 0;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "nCurveLeft=" + numberCurvesLeft + ", nCurveRight=" + numberCurvesRight);
        }
        Point pt = gc.textExtent("-000,00");
        int horizontalGap = pt.x / 5;
        int horizontalNumberExtend = pt.x;
        int horizontalCaptionExtend = pt.y;
        int dataScaleWidth = recordSet.isCompareSet() ? horizontalNumberExtend + horizontalGap : horizontalNumberExtend + horizontalCaptionExtend + horizontalGap;
        int spaceLeft = numberCurvesLeft * dataScaleWidth;
        int spaceRight = numberCurvesRight * dataScaleWidth;
        int gapSide = 10;
        int x0 = spaceLeft + (numberCurvesLeft > 0 ? gapSide / 2 : gapSide);
        int xMax = bounds.width - spaceRight - (numberCurvesRight > 0 ? gapSide / 2 : gapSide);
        int width = xMax - x0 <= 0 ? 1 : xMax - x0;
        int yMax = 10;
        int gapBot = 3 * pt.y;
        int y0 = bounds.height - yMax - gapBot;
        int height = y0 - yMax;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "draw area x0=" + x0 + ", y0=" + y0 + ", xMax=" + xMax + ", yMax=" + yMax + ", width=" + width + ", height=" + height);
        }
        this.offSetX = x0;
        this.offSetY = y0 - height;
        this.curveAreaBounds = new Rectangle(x0, y0 - height, width, height);
        recordSet.setDrawAreaBounds(this.curveAreaBounds);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "curve bounds = " + this.curveAreaBounds);
        }
        gc.setBackground(this.curveAreaBackground);
        gc.fillRectangle(this.curveAreaBounds);
        gc.setBackground(this.surroundingBackground);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "average time step record 0 = " + recordSet.getAverageTimeStep_ms());
        }
        int startTimeFormated = TimeLine.convertTimeInFormatNumber(recordSet.getStartTime(), timeFormat);
        int endTimeFormated = startTimeFormated + maxTimeFormated;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "startTime = " + startTimeFormated + " detaTime_ms = " + (long)totalDisplayDeltaTime_ms + " endTime = " + endTimeFormated);
        }
        this.timeLine.drawTimeLine(recordSet, gc, x0, y0 + 1, width, startTimeFormated, endTimeFormated, scaleFactor, timeFormat, (long)totalDisplayDeltaTime_ms, this.application.COLOR_BLACK);
        gc.setForeground(this.curveAreaBorderColor);
        gc.drawLine(x0 - 1, yMax - 1, xMax + 1, yMax - 1);
        gc.drawLine(x0 - 1, yMax - 1, x0 - 1, y0);
        gc.drawLine(xMax + 1, yMax - 1, xMax + 1, y0);
        if (recordSet.getTimeGridType() > 0) {
            this.drawTimeGrid(recordSet, gc, this.curveAreaBounds, this.settings.getGridDashStyle());
        }
        boolean isCurveGridEnabled = recordSet.getValueGridType() > 0;
        long startTime = new Date().getTime();
        boolean isDrawScaleInRecordColor = this.settings.isDrawScaleInRecordColor();
        boolean isDrawNameInRecordColor = this.settings.isDrawNameInRecordColor();
        boolean isDrawNumbersInRecordColor = this.settings.isDrawNumbersInRecordColor();
        boolean isDraw10TicksPerRecord = this.settings.isDraw10TicksPerRecord();
        if (isDraw10TicksPerRecord && recordSet.getVisibleAndDisplayableRecords().size() > 0 && (recordSet.getValueGridRecordOrdinal() >= recordSet.size() || recordSet.getValueGridRecordOrdinal() == -1 || !recordSet.get(recordSet.getValueGridRecordOrdinal()).isScaleVisible())) {
            recordSet.setValueGridRecordOrdinal(recordSet.getVisibleAndDisplayableRecords().firstElement().getOrdinal());
        }
        recordSet.syncScaleOfSyncableRecords();
        recordSet.updateSyncRecordScale();
        for (Record actualRecord : recordSet.getRecordsSortedForDisplay()) {
            boolean isActualRecordEnabled;
            boolean bl = isActualRecordEnabled = actualRecord.isVisible() && actualRecord.isDisplayable();
            if (log.isLoggable(Level.FINE) && isActualRecordEnabled) {
                log.log(Level.FINE, "drawing record = " + actualRecord.getName() + " isVisibel=" + actualRecord.isVisible() + " isDisplayable=" + actualRecord.isDisplayable() + " isScaleSynced=" + actualRecord.isScaleSynced() + " isScaleVisible=" + actualRecord.isScaleVisible());
            }
            if (actualRecord.isScaleVisible()) {
                CurveUtils.drawScale(actualRecord, gc, x0, y0, width, height, dataScaleWidth, isDrawScaleInRecordColor, isDrawNameInRecordColor, isDrawNumbersInRecordColor, isDraw10TicksPerRecord);
                if (isCurveGridEnabled && actualRecord.getOrdinal() == recordSet.getValueGridRecordOrdinal()) {
                    this.drawCurveGrid(recordSet, gc, this.curveAreaBounds, this.settings.getGridDashStyle());
                }
            }
            if (!isActualRecordEnabled) continue;
            gc.setClipping(x0 - 1, y0 - height - 1, width + 2, height + 2);
            CurveUtils.drawCurve(actualRecord, gc, x0, y0, width, height, recordSet.isCompareSet());
            gc.setClipping(this.canvasBounds);
        }
        if (startTimeFormated != 0) {
            String strStartTime = Messages.getString("GDE_MSGT0255") + TimeLine.getFomatedTimeWithUnit(recordSet.getStartTime());
            Point point = gc.textExtent(strStartTime);
            int yPosition = (int)((double)y0 + (double)pt.y * 2.5);
            gc.setForeground(SWTResourceManager.getColor(4));
            gc.drawText(strStartTime, 10, yPosition - point.y / 2);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, strStartTime);
            }
        }
        if (log.isLoggable(Level.TIME)) {
            log.log(Level.TIME, "draw time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
        }
    }

    private void drawCurveGrid(RecordSet recordSet, GC gc, Rectangle bounds, int[] dashLineStyle) {
        gc.setLineWidth(1);
        gc.setLineDash(dashLineStyle);
        gc.setLineStyle(6);
        gc.setForeground(recordSet.getValueGridColor());
        Vector<Integer> horizontalGridVector = recordSet.getValueGrid();
        for (int i = 0; i < horizontalGridVector.size(); i += recordSet.getValueGridType()) {
            int y = horizontalGridVector.get(i);
            if (y <= bounds.y || y >= bounds.y + bounds.height) continue;
            gc.drawLine(bounds.x, y, bounds.x + bounds.width, y);
        }
    }

    public void drawTimeGrid(RecordSet recordSet, GC gc, Rectangle bounds, int[] dashLineStyle) {
        gc.setLineWidth(1);
        gc.setLineDash(dashLineStyle);
        gc.setLineStyle(6);
        gc.setForeground(recordSet.getColorTimeGrid());
        for (Integer x : recordSet.getTimeGrid()) {
            gc.drawLine(x.intValue(), bounds.y, x.intValue(), bounds.y + bounds.height);
        }
    }

    public void redrawGraphics() {
        if (Thread.currentThread().getId() == this.application.getThreadId()) {
            this.doRedrawGraphics();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    GraphicsComposite.this.doRedrawGraphics();
                }
            });
        }
    }

    synchronized void doRedrawGraphics() {
        this.graphicsHeader.notifyListeners(9, new Event());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "this.graphicCanvas.redraw(); // do full update where required");
        }
        this.canvasBounds = this.graphicCanvas.getClientArea();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "canvas size = " + this.canvasBounds);
        }
        if (this.canvasImage != null) {
            this.canvasImage.dispose();
        }
        try {
            this.canvasImage = new Image((Device)GDE.display, this.canvasBounds);
            this.canvasImageGC = new GC((Drawable)this.canvasImage);
            this.canvasImageGC.setBackground(this.surroundingBackground);
            this.canvasImageGC.fillRectangle(this.canvasBounds);
            this.canvasImageGC.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            RecordSet recordSet = null;
            switch (this.graphicsType) {
                case COMPARE: {
                    if (!this.application.isWithCompareSet()) break;
                    recordSet = this.application.getCompareSet();
                    break;
                }
                case UTIL: {
                    if (!this.application.isWithUtilitySet()) break;
                    recordSet = this.application.getUtilitySet();
                    break;
                }
                default: {
                    if (this.channels.getActiveChannel() == null || this.channels.getActiveChannel().getActiveRecordSet() == null) break;
                    recordSet = this.channels.getActiveChannel().getActiveRecordSet();
                }
            }
            if (recordSet != null && recordSet.realSize() > 0) {
                this.drawCurves(recordSet, this.canvasBounds, this.canvasImageGC);
                recordSet.syncScaleOfSyncableRecords();
            }
            this.canvasImageGC.dispose();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
        }
        this.graphicCanvas.redraw();
        this.recordSetComment.redraw();
    }

    public void notifySelected() {
        this.recordSetComment.notifyListeners(16, new Event());
    }

    public void drawMeasurePointer(GC canvasGC, RecordSet recordSet, GraphicsMode mode, boolean isRefresh) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "isRefresh = " + isRefresh);
        }
        if (mode != this.actualModeState) {
            this.setModeState(mode);
        }
        String measureRecordKey = recordSet.getRecordKeyMeasurement();
        if (canvasGC != null) {
            Record record = recordSet.get(measureRecordKey);
            canvasGC.setLineWidth(1);
            canvasGC.setLineStyle(2);
            canvasGC.setForeground(SWTResourceManager.getColor(2));
            IDevice actualDevice = record.getDevice();
            if (recordSet.isMeasurementMode(measureRecordKey)) {
                this.xPosMeasure = isRefresh ? this.xPosMeasure : this.curveAreaBounds.width / 4;
                this.yPosMeasure = record.getVerticalDisplayPointValue(this.xPosMeasure);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "initial xPosMeasure = " + this.xPosMeasure + " yPosMeasure = " + this.yPosMeasure);
                }
                this.drawVerticalLine(canvasGC, this.xPosMeasure, 0, this.curveAreaBounds.height);
                this.drawHorizontalLine(canvasGC, this.yPosMeasure, 0, this.curveAreaBounds.width);
                this.recordSetComment.setText(this.getSelectedMeasurementsAsTable());
                int indexPosMeasure = record.getHorizontalPointIndexFromDisplayPoint(this.xPosMeasure);
                this.calculateMeasurementStatusMessage(actualDevice, record, indexPosMeasure);
            } else if (recordSet.isDeltaMeasurementMode(measureRecordKey)) {
                this.xPosMeasure = isRefresh ? this.xPosMeasure : this.curveAreaBounds.width / 4;
                this.yPosMeasure = record.getVerticalDisplayPointValue(this.xPosMeasure);
                this.drawVerticalLine(canvasGC, this.xPosMeasure, 0, this.curveAreaBounds.height);
                this.drawHorizontalLine(canvasGC, this.yPosMeasure, 0, this.curveAreaBounds.width);
                this.xPosDelta = isRefresh ? this.xPosDelta : this.curveAreaBounds.width / 3 * 2;
                this.yPosDelta = record.getVerticalDisplayPointValue(this.xPosDelta);
                canvasGC.setForeground(SWTResourceManager.getColor(9));
                this.drawVerticalLine(canvasGC, this.xPosDelta, 0, this.curveAreaBounds.height);
                this.drawHorizontalLine(canvasGC, this.yPosDelta, 0, this.curveAreaBounds.width);
                this.drawConnectingLine(canvasGC, this.xPosMeasure, this.yPosMeasure, this.xPosDelta, this.yPosDelta, 2);
                canvasGC.setForeground(SWTResourceManager.getColor(2));
                int indexPosMeasure = record.getHorizontalPointIndexFromDisplayPoint(this.xPosMeasure);
                int indexPosDelta = record.getHorizontalPointIndexFromDisplayPoint(this.xPosDelta);
                if (this.graphicsType == GraphicsWindow.GraphicsType.NORMAL && record.getDevice().getAtlitudeTripSpeedOrdinals().length == 3 && record.getOrdinal() == record.getDevice().getAtlitudeTripSpeedOrdinals()[0]) {
                    this.calculateSinkAndGlideRatioStatusMessage(actualDevice, record, indexPosMeasure, indexPosDelta);
                } else {
                    this.calculateDeltaValueStatusMessage(actualDevice, record, indexPosMeasure, indexPosDelta);
                }
            }
        }
    }

    private void drawZoomBounds(GC canvasGC) {
        canvasGC.setLineWidth(1);
        canvasGC.setLineStyle(2);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "draw  left = " + (this.leftZoom - this.offSetX) + " top = " + (this.topZoom - this.offSetY) + " width = " + this.widthZoom + " height = " + this.heightZoom);
        }
        canvasGC.drawRectangle(this.leftZoom, this.topZoom, this.widthZoom, this.heightZoom);
    }

    private void drawVerticalLine(GC canvasGC, int posFromLeft, int posFromTop, int length) {
        canvasGC.drawLine(posFromLeft + this.offSetX, posFromTop + this.offSetY, posFromLeft + this.offSetX, posFromTop + this.offSetY + length - 1);
    }

    private void drawHorizontalLine(GC canvasGC, int posFromTop, int posFromLeft, int length) {
        canvasGC.drawLine(posFromLeft + this.offSetX, posFromTop + this.offSetY, posFromLeft + this.offSetX + length - 1, posFromTop + this.offSetY);
    }

    private void drawConnectingLine(GC canvasGC, int posFromLeft1, int posFromTop1, int posFromLeft2, int posFromTop2, int swtColor) {
        canvasGC.setForeground(SWTResourceManager.getColor(swtColor));
        canvasGC.setLineStyle(1);
        canvasGC.drawLine(posFromLeft1 + this.offSetX, posFromTop1 + this.offSetY, posFromLeft2 + this.offSetX, posFromTop2 + this.offSetY);
    }

    void eraseVerticalLine(GC canvasGC, int posFromLeft, int posFromTop, int length, int lineWidth) {
        canvasGC.drawImage(this.canvasImage, posFromLeft + this.offSetX, posFromTop + this.offSetY, lineWidth, length, posFromLeft + this.offSetX, posFromTop + this.offSetY, lineWidth, length);
    }

    void eraseHorizontalLine(GC canvasGC, int posFromTop, int posFromLeft, int length, int lineWidth) {
        canvasGC.drawImage(this.canvasImage, posFromLeft + this.offSetX, posFromTop + this.offSetY, length, lineWidth, posFromLeft + this.offSetX, posFromTop + this.offSetY, length, lineWidth);
    }

    void cleanConnectingLineObsoleteRectangle(GC canvasGC) {
        int height;
        int n = this.leftLast = this.leftLast == 0 ? this.xPosMeasure : this.leftLast;
        int left = this.xPosMeasure <= this.xPosDelta ? (this.leftLast < this.xPosMeasure ? this.leftLast : this.xPosMeasure) : (this.leftLast < this.xPosDelta ? this.leftLast : this.xPosDelta);
        int n2 = this.topLast = this.topLast == 0 ? this.yPosDelta : this.topLast;
        int top = this.yPosDelta <= this.yPosMeasure ? (this.topLast < this.yPosDelta ? this.topLast : this.yPosDelta) : (this.topLast < this.yPosMeasure ? this.topLast : this.yPosMeasure);
        int n3 = this.rightLast = this.rightLast == 0 ? this.xPosDelta - left : this.rightLast;
        int width = this.xPosDelta >= this.xPosMeasure ? (this.rightLast > this.xPosDelta ? this.rightLast - left : this.xPosDelta - left) : (this.rightLast > this.xPosMeasure ? this.rightLast - left : this.xPosMeasure - left);
        int n4 = this.bottomLast = this.bottomLast == 0 ? this.yPosMeasure - top : this.bottomLast;
        int n5 = this.yPosMeasure >= this.yPosDelta ? (this.bottomLast > this.yPosMeasure ? this.bottomLast - top : this.yPosMeasure - top) : (height = this.bottomLast > this.yPosDelta ? this.bottomLast - top : this.yPosDelta - top);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "leftLast = " + this.leftLast + " topLast = " + this.topLast + " rightLast = " + this.rightLast + " bottomLast = " + this.bottomLast);
        }
        if (width > 0 && height > 0 && width < this.curveAreaBounds.width && height < this.curveAreaBounds.height) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "left = " + left + " top = " + top + " width = " + width + " height = " + height);
            }
            canvasGC.drawImage(this.canvasImage, left + this.offSetX, top + this.offSetY, width, height, left + this.offSetX, top + this.offSetY, width, height);
        }
        this.leftLast = this.xPosMeasure <= this.xPosDelta ? this.xPosMeasure : this.xPosDelta;
        this.topLast = this.yPosDelta <= this.yPosMeasure ? this.yPosDelta : this.yPosMeasure;
        this.rightLast = this.xPosDelta >= this.xPosMeasure ? this.xPosDelta : this.xPosMeasure;
        int n6 = this.bottomLast = this.yPosDelta >= this.yPosMeasure ? this.yPosDelta : this.yPosMeasure;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "leftLast = " + this.leftLast + " topLast = " + this.topLast + " rightLast = " + this.rightLast + " bottomLast = " + this.bottomLast);
        }
    }

    void eraseConnectingLine(GC canvasGC, int left, int top, int width, int height) {
        if (width > 0 && height > 0 && width < this.curveAreaBounds.width && height < this.curveAreaBounds.height) {
            canvasGC.drawImage(this.canvasImage, left, top, width, height, left + this.offSetX, top + this.offSetY, width, height);
        }
    }

    public void cleanMeasurementPointer() {
        try {
            if (this.recordSetCommentText != null) {
                this.recordSetComment.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE + 1, 0));
                this.recordSetComment.setText(this.recordSetCommentText);
            }
            this.application.setStatusMessage("");
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void drawCutPointer(GC canvasGC, GraphicsMode mode, boolean leftEnabled, boolean rightEnabled) {
        boolean isGraphicsWindow;
        if (mode != this.actualModeState) {
            this.setModeState(mode);
        }
        boolean bl = isGraphicsWindow = this.graphicsType == GraphicsWindow.GraphicsType.NORMAL;
        if (isGraphicsWindow && canvasGC != null) {
            canvasGC.setLineWidth(1);
            canvasGC.setLineStyle(1);
            canvasGC.setForeground(SWTResourceManager.getColor(9));
            if (leftEnabled) {
                this.application.setStatusMessage(Messages.getString("GDE_MSGT0258"));
                int n = this.xPosCut = this.xPosCut > 0 ? this.xPosCut : this.curveAreaBounds.width * 1 / 4;
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "this.xPosCut = " + this.xPosCut);
                }
                canvasGC.setBackgroundPattern(SWTResourceManager.getPattern(0.0f, 0.0f, 50.0f, 50.0f, 13, 128, 22, 128));
                canvasGC.fillRectangle(0 + this.offSetX, 0 + this.offSetY, this.xPosCut, this.curveAreaBounds.height);
                canvasGC.setAdvanced(false);
                this.drawVerticalLine(canvasGC, this.xPosCut, 0, this.curveAreaBounds.height);
            } else if (rightEnabled) {
                this.application.setStatusMessage(Messages.getString("GDE_MSGT0259"));
                this.xPosCut = this.xPosCut > 0 ? this.xPosCut : this.curveAreaBounds.width * 3 / 4;
                canvasGC.setBackgroundPattern(SWTResourceManager.getPattern(0.0f, 0.0f, 50.0f, 50.0f, 13, 128, 22, 128));
                canvasGC.fillRectangle(this.xPosCut + this.offSetX, 0 + this.offSetY, this.curveAreaBounds.width - this.xPosCut, this.curveAreaBounds.height);
                canvasGC.setAdvanced(false);
                this.drawVerticalLine(canvasGC, this.xPosCut, 0, this.curveAreaBounds.height);
            } else {
                this.cleanCutPointer(canvasGC);
            }
        }
    }

    public void cleanCutPointer(GC canvasGC) {
        this.application.setStatusMessage(" ");
        this.eraseVerticalLine(canvasGC, this.xPosCut, 0, this.curveAreaBounds.height, 2);
    }

    public void setModeState(GraphicsMode mode) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "GraphicsMode = " + (Object)((Object)mode));
        }
        this.cleanMeasurementPointer();
        switch (mode) {
            case ZOOM: {
                this.isZoomMouse = true;
                this.isLeftMouseMeasure = false;
                this.isRightMouseMeasure = false;
                this.isPanMouse = false;
                this.isScopeMode = false;
                break;
            }
            case MEASURE: {
                this.isZoomMouse = false;
                this.isLeftMouseMeasure = true;
                this.isRightMouseMeasure = false;
                this.isPanMouse = false;
                this.isScopeMode = false;
                break;
            }
            case MEASURE_DELTA: {
                this.isZoomMouse = false;
                this.isLeftMouseMeasure = false;
                this.isRightMouseMeasure = true;
                this.isPanMouse = false;
                this.isScopeMode = false;
                break;
            }
            case PAN: {
                this.isZoomMouse = false;
                this.isLeftMouseMeasure = false;
                this.isRightMouseMeasure = false;
                this.isPanMouse = true;
                this.isScopeMode = false;
                break;
            }
            case CUT_LEFT: {
                this.isZoomMouse = false;
                this.isLeftMouseMeasure = false;
                this.isRightMouseMeasure = false;
                this.isPanMouse = false;
                this.isLeftCutMode = true;
                this.isRightCutMode = false;
                this.isScopeMode = false;
                break;
            }
            case CUT_RIGHT: {
                this.isZoomMouse = false;
                this.isLeftMouseMeasure = false;
                this.isRightMouseMeasure = false;
                this.isPanMouse = false;
                this.isLeftCutMode = false;
                this.isRightCutMode = true;
                this.isScopeMode = false;
                break;
            }
            case SCOPE: {
                this.isZoomMouse = false;
                this.isLeftMouseMeasure = false;
                this.isRightMouseMeasure = false;
                this.isPanMouse = false;
                this.isLeftCutMode = false;
                this.isRightCutMode = false;
                this.isScopeMode = true;
                break;
            }
            default: {
                this.isZoomMouse = false;
                this.isLeftMouseMeasure = false;
                this.isRightMouseMeasure = false;
                this.isPanMouse = false;
                this.isLeftCutMode = false;
                this.isRightCutMode = false;
                this.isScopeMode = false;
                this.application.setStatusMessage("");
                this.xPosCut = -1;
                this.xLast = 0;
                this.yLast = 0;
                this.leftLast = 0;
                this.topLast = 0;
                this.rightLast = 0;
                this.bottomLast = 0;
                this.updatePanMenueButton();
                this.application.getMenuToolBar().resetZoomToolBar();
            }
        }
        this.actualModeState = mode;
        this.xPosDelta = 0;
        this.xPosMeasure = 0;
        this.graphicCanvas.redraw();
    }

    private void updatePanMenueButton() {
        this.application.getMenuBar().enablePanButton(this.isZoomMouse || this.isPanMouse);
        this.application.getMenuToolBar().enablePanButton(this.isZoomMouse || this.isPanMouse);
    }

    private Point checkCurveBounds(int xPos, int yPos) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "in  xPos = " + xPos + " yPos = " + yPos);
            log.log(Level.FINER, "in  offSetX = " + this.offSetX + " offSetY = " + this.offSetY);
        }
        int tmpxPos = xPos - this.offSetX;
        int tmpyPos = yPos - this.offSetY;
        int minX = 0;
        int maxX = this.curveAreaBounds.width;
        int minY = 0;
        int maxY = this.curveAreaBounds.height;
        if (tmpxPos < minX || tmpxPos > maxX) {
            int n = tmpxPos = tmpxPos < minX ? minX : maxX;
        }
        if (tmpyPos < minY || tmpyPos > maxY) {
            int n = tmpyPos = tmpyPos < minY ? minY : maxY;
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "out xPos = " + tmpxPos + " yPos = " + tmpyPos);
        }
        return new Point(tmpxPos, tmpyPos);
    }

    void mouseMoveAction(MouseEvent evt) {
        Channel activeChannel = Channels.getInstance().getActiveChannel();
        if (activeChannel != null) {
            RecordSet recordSet;
            RecordSet recordSet2 = recordSet = this.graphicsType == GraphicsWindow.GraphicsType.NORMAL ? activeChannel.getActiveRecordSet() : this.application.getCompareSet();
            if (recordSet != null && this.canvasImage != null) {
                Point point = this.checkCurveBounds(evt.x, evt.y);
                evt.x = point.x;
                evt.y = point.y;
                String measureRecordKey = recordSet.getRecordKeyMeasurement();
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, String.format("xDown = %d, evt.x = %d, xLast = %d  -  yDown = %d, evt.y = %d, yLast = %d", this.xDown, evt.x, this.xLast, this.yDown, evt.y, this.yLast));
                }
                if ((evt.stateMask & 0x80000) == 524288) {
                    try {
                        if (this.isZoomMouse && recordSet.isZoomMode() && this.isResetZoomPosition) {
                            this.leftZoom = evt.x - this.xDown > 0 ? this.xDown + this.offSetX : evt.x + this.offSetX;
                            this.topZoom = evt.y - this.yDown > 0 ? this.yDown + this.offSetY : evt.y + this.offSetY;
                            this.widthZoom = evt.x - this.xDown > 0 ? evt.x - this.xDown : this.xDown - evt.x;
                            int n = this.heightZoom = evt.y - this.yDown > 0 ? evt.y - this.yDown : this.yDown - evt.y;
                            if (this.xDown < evt.x) {
                                this.isTransientZoom = true;
                            }
                            if (this.xDown > evt.x) {
                                this.isTransientZoom = false;
                            }
                            this.xLast = evt.x;
                            this.yLast = evt.y;
                            this.graphicCanvas.redraw(this.offSetX, this.offSetY, this.curveAreaBounds.width, this.curveAreaBounds.height, false);
                        } else if (this.isLeftMouseMeasure) {
                            this.xPosMeasure = evt.x;
                            this.graphicCanvas.redraw(this.offSetX, this.offSetY, this.curveAreaBounds.width, this.curveAreaBounds.height, false);
                        } else if (this.isRightMouseMeasure) {
                            this.xPosDelta = evt.x;
                            this.graphicCanvas.redraw(this.offSetX, this.offSetY, this.curveAreaBounds.width, this.curveAreaBounds.height, false);
                        } else if (this.isPanMouse) {
                            int n = this.xLast != 0 && this.xLast != evt.x ? this.xDeltaPan + (this.xLast < evt.x ? -1 : 1) : (this.xDeltaPan = 0);
                            int n2 = this.yLast != 0 && this.yLast != evt.y ? this.yDeltaPan + (this.yLast < evt.y ? 1 : -1) : (this.yDeltaPan = 0);
                            if (log.isLoggable(Level.FINER)) {
                                log.log(Level.FINER, " xDeltaPan = " + this.xDeltaPan + " yDeltaPan = " + this.yDeltaPan);
                            }
                            if (this.xDeltaPan != 0 && this.xDeltaPan % 5 == 0 || this.yDeltaPan != 0 && this.yDeltaPan % 5 == 0) {
                                recordSet.shift(this.xDeltaPan, this.yDeltaPan);
                                this.doRedrawGraphics();
                                this.yDeltaPan = 0;
                                this.xDeltaPan = 0;
                            }
                            this.xLast = evt.x;
                            this.yLast = evt.y;
                        } else if (this.isLeftCutMode) {
                            this.xPosCut = evt.x;
                            this.graphicCanvas.redraw(this.offSetX, this.offSetY, this.curveAreaBounds.width, this.curveAreaBounds.height, false);
                        } else if (this.isRightCutMode) {
                            this.xPosCut = evt.x;
                            this.graphicCanvas.redraw(this.offSetX, this.offSetY, this.curveAreaBounds.width, this.curveAreaBounds.height, false);
                        }
                    }
                    catch (RuntimeException e) {
                        log.log(Level.WARNING, "mouse pointer out of range", e);
                    }
                } else if (measureRecordKey != null && (recordSet.isMeasurementMode(measureRecordKey) || recordSet.isDeltaMeasurementMode(measureRecordKey))) {
                    if (this.xPosMeasure + 1 >= evt.x && this.xPosMeasure - 1 <= evt.x || this.xPosDelta + 1 >= evt.x && this.xPosDelta - 1 <= evt.x) {
                        this.graphicCanvas.setCursor(SWTResourceManager.getCursor(9));
                    } else {
                        this.graphicCanvas.setCursor(this.application.getCursor());
                    }
                } else if (this.isZoomMouse && !this.isPanMouse) {
                    this.graphicCanvas.setCursor(SWTResourceManager.getCursor(2));
                } else if (this.isPanMouse) {
                    this.graphicCanvas.setCursor(SWTResourceManager.getCursor("gde/resource/Hand.gif"));
                } else if (this.isLeftCutMode || this.isRightCutMode) {
                    if (this.xPosCut + 1 >= evt.x && this.xPosCut - 1 <= evt.x) {
                        this.graphicCanvas.setCursor(SWTResourceManager.getCursor(9));
                    } else {
                        this.graphicCanvas.setCursor(this.application.getCursor());
                    }
                } else {
                    this.graphicCanvas.setCursor(this.application.getCursor());
                }
            }
        }
    }

    private void calculateMeasurementStatusMessage(IDevice actualDevice, Record record, int indexPosMeasure) {
        this.application.setStatusMessage(Messages.getString("GDE_MSGT0256", new Object[]{record.getName(), record.getDecimalFormat().format(actualDevice.translateValue(record, (double)record.realGet(indexPosMeasure).intValue() / 1000.0)), record.getUnit(), record.getHorizontalDisplayPointAsFormattedTimeWithUnit(this.xPosMeasure)}));
    }

    private void calculateDeltaValueStatusMessage(IDevice actualDevice, Record record, int indexPosMeasure, int indexPosDelta) {
        this.application.setStatusMessage(Messages.getString("GDE_MSGT0257", new Object[]{record.getName(), Messages.getString("GDE_MSGT0212"), record.getDecimalFormat().format(actualDevice.translateValue(record, record.realGet(indexPosDelta) - record.realGet(indexPosMeasure)) / 1000.0), record.getUnit(), TimeLine.getFomatedTimeWithUnit(record.getHorizontalDisplayPointTime_ms(this.xPosDelta) - record.getHorizontalDisplayPointTime_ms(this.xPosMeasure)), record.getSlopeValue(new Point(this.xPosDelta - this.xPosMeasure, this.yPosMeasure - this.yPosDelta)), record.getUnit()}));
    }

    private void calculateSinkAndGlideRatioStatusMessage(IDevice actualDevice, Record record, int indexPosMeasure, int indexPosDelta) {
        Record tripLength = record.getParent().get(record.getDevice().getAtlitudeTripSpeedOrdinals()[1]);
        Record altitude = record.getParent().get(record.getDevice().getAtlitudeTripSpeedOrdinals()[0]);
        Record speed = record.getParent().get(record.getDevice().getAtlitudeTripSpeedOrdinals()[2]);
        double altitudeDelta = altitude.realGet(indexPosDelta) - altitude.realGet(indexPosMeasure);
        String altDelta_m = altitude.getDecimalFormat().format(actualDevice.translateValue(altitude, altitudeDelta / 1000.0));
        double tripDelta = tripLength.realGet(indexPosDelta) - tripLength.realGet(indexPosMeasure);
        String tripDelta_m = tripLength.getDecimalFormat().format(actualDevice.translateValue(tripLength, tripDelta));
        String ratioTripAltitude = String.format("%4.2f", Math.abs(actualDevice.translateValue(tripLength, tripDelta) / actualDevice.translateValue(altitude, altitudeDelta / 1000.0)));
        String speedAvg_kmh = speed.getDecimalFormat().format(actualDevice.translateValue(speed, (double)speed.getAvgValue(indexPosMeasure, indexPosDelta) / 1000.0));
        this.application.setStatusMessage(Messages.getString("GDE_MSGT0187", new Object[]{altDelta_m, record.getUnit(), TimeLine.getFomatedTimeWithUnit(record.getHorizontalDisplayPointTime_ms(this.xPosDelta) - record.getHorizontalDisplayPointTime_ms(this.xPosMeasure)), record.getSlopeValue(new Point(this.xPosDelta - this.xPosMeasure, this.yPosMeasure - this.yPosDelta)), record.getUnit(), tripDelta_m, altDelta_m, ratioTripAltitude, speedAvg_kmh, speed.getUnit()}));
    }

    void mouseDownAction(MouseEvent evt) {
        Channel activeChannel = Channels.getInstance().getActiveChannel();
        if (activeChannel != null) {
            RecordSet recordSet;
            RecordSet recordSet2 = recordSet = this.graphicsType == GraphicsWindow.GraphicsType.NORMAL ? activeChannel.getActiveRecordSet() : this.application.getCompareSet();
            if (this.canvasImage != null && recordSet != null) {
                String measureRecordKey = recordSet.getRecordKeyMeasurement();
                Point point = this.checkCurveBounds(evt.x, evt.y);
                this.xDown = point.x;
                this.yDown = point.y;
                if (measureRecordKey != null && (recordSet.isMeasurementMode(measureRecordKey) || recordSet.isDeltaMeasurementMode(measureRecordKey)) && this.xPosMeasure + 1 >= this.xDown && this.xPosMeasure - 1 <= this.xDown) {
                    this.isLeftMouseMeasure = true;
                    this.isRightMouseMeasure = false;
                } else if (measureRecordKey != null && recordSet.isDeltaMeasurementMode(measureRecordKey) && this.xPosDelta + 1 >= this.xDown && this.xPosDelta - 1 <= this.xDown) {
                    this.isRightMouseMeasure = true;
                    this.isLeftMouseMeasure = false;
                } else if (!(this.isPanMouse || this.isLeftCutMode || this.isRightCutMode)) {
                    if (!this.isZoomMouse) {
                        this.application.setGraphicsMode(GraphicsMode.ZOOM, true);
                    }
                    this.xLast = this.xDown;
                    this.yLast = this.yDown;
                    this.isResetZoomPosition = true;
                } else {
                    this.isLeftMouseMeasure = false;
                    this.isRightMouseMeasure = false;
                }
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "isMouseMeasure = " + this.isLeftMouseMeasure + " isMouseDeltaMeasure = " + this.isRightMouseMeasure);
                }
            }
        }
    }

    void mouseUpAction(MouseEvent evt) {
        Channel activeChannel = Channels.getInstance().getActiveChannel();
        if (activeChannel != null) {
            RecordSet recordSet;
            RecordSet recordSet2 = recordSet = this.graphicsType == GraphicsWindow.GraphicsType.NORMAL ? Channels.getInstance().getActiveChannel().getActiveRecordSet() : this.application.getCompareSet();
            if (this.canvasImage != null && recordSet != null) {
                Point point = this.checkCurveBounds(evt.x, evt.y);
                this.xUp = point.x;
                this.yUp = point.y;
                if (this.isZoomMouse) {
                    if (this.isTransientZoom) {
                        int yMax;
                        int yMin;
                        int xEnd;
                        int xStart;
                        this.isResetZoomPosition = false;
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, this.isZoomMouse + " - " + recordSet.isZoomMode() + " - " + this.isResetZoomPosition);
                        }
                        if (this.isZoomX) {
                            xStart = this.xDown < this.xUp ? this.xDown : this.xUp;
                            xEnd = this.xDown > this.xUp ? this.xDown + 1 : this.xUp;
                            yMin = 0;
                            yMax = this.curveAreaBounds.height - this.curveAreaBounds.y;
                        } else if (this.isZoomY) {
                            xStart = 0;
                            xEnd = this.curveAreaBounds.width;
                            yMin = this.curveAreaBounds.height - (this.yDown > this.yUp ? this.yDown : this.yUp);
                            yMax = this.curveAreaBounds.height - (this.yDown < this.yUp ? this.yDown : this.yUp);
                        } else {
                            xStart = this.xDown < this.xUp ? this.xDown : this.xUp;
                            xEnd = this.xDown > this.xUp ? this.xDown + 1 : this.xUp;
                            yMin = this.curveAreaBounds.height - (this.yDown > this.yUp ? this.yDown : this.yUp);
                            yMax = this.curveAreaBounds.height - (this.yDown < this.yUp ? this.yDown : this.yUp);
                        }
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "zoom xStart = " + xStart + " xEnd = " + xEnd + " yMin = " + yMin + " yMax = " + yMax);
                        }
                        if (xEnd - xStart > 5 && yMax - yMin > 5) {
                            recordSet.setDisplayZoomBounds(new Rectangle(xStart, yMin, xEnd - xStart, yMax - yMin));
                            this.redrawGraphics();
                        }
                    } else {
                        this.application.setGraphicsMode(GraphicsMode.RESET, false);
                    }
                } else if (this.isLeftMouseMeasure) {
                    this.isLeftMouseMeasure = false;
                } else if (this.isRightMouseMeasure) {
                    this.isRightMouseMeasure = false;
                } else if (this.isLeftCutMode) {
                    if (32 == this.application.openOkCancelMessageDialog(Messages.getString("GDE_MSGT0260"))) {
                        recordSet = recordSet.clone(recordSet.get(0).getHorizontalPointIndexFromDisplayPoint(this.xUp), true);
                        recordSet.setRecalculationRequired();
                        this.channels.getActiveChannel().put(recordSet.getName(), recordSet);
                        this.application.getMenuToolBar().addRecordSetName(recordSet.getName());
                        this.channels.getActiveChannel().switchRecordSet(recordSet.getName());
                    }
                    this.setModeState(GraphicsMode.RESET);
                } else if (this.isRightCutMode) {
                    if (32 == this.application.openOkCancelMessageDialog(Messages.getString("GDE_MSGT0260"))) {
                        recordSet = recordSet.clone(recordSet.get(0).getHorizontalPointIndexFromDisplayPoint(this.xUp), false);
                        recordSet.setRecalculationRequired();
                        this.channels.getActiveChannel().put(recordSet.getName(), recordSet);
                        this.application.getMenuToolBar().addRecordSetName(recordSet.getName());
                        this.channels.getActiveChannel().switchRecordSet(recordSet.getName());
                    }
                    this.setModeState(GraphicsMode.RESET);
                }
                this.updatePanMenueButton();
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "isMouseMeasure = " + this.isLeftMouseMeasure + " isMouseDeltaMeasure = " + this.isRightMouseMeasure);
                }
            }
        }
    }

    void updateCutModeButtons() {
        Channel activeChannel = Channels.getInstance().getActiveChannel();
        if (activeChannel != null) {
            RecordSet recordSet;
            RecordSet recordSet2 = this.graphicsType == GraphicsWindow.GraphicsType.NORMAL ? Channels.getInstance().getActiveChannel().getActiveRecordSet() : (recordSet = this.graphicsType == GraphicsWindow.GraphicsType.COMPARE ? this.application.getCompareSet() : this.application.getUtilitySet());
            if (this.canvasImage != null && recordSet != null) {
                if (recordSet.isCutLeftEdgeEnabled()) {
                    this.application.getMenuToolBar().enableCutButtons(true, false);
                } else if (recordSet.isCutRightEdgeEnabled()) {
                    this.application.getMenuToolBar().enableCutButtons(false, true);
                } else {
                    this.application.getMenuToolBar().enableCutButtons(false, false);
                }
            }
        }
    }

    public void enableGraphicsHeader(boolean enabled) {
        if (enabled) {
            int stringHeight;
            this.headerGap = 5;
            GC gc = new GC((Drawable)this.graphicsHeader);
            this.headerHeight = stringHeight = gc.stringExtent((String)this.graphicsHeader.getText()).y;
            gc.dispose();
        } else {
            this.headerGap = 0;
            this.headerHeight = 0;
        }
        this.setComponentBounds();
    }

    public void enableRecordSetComment(boolean enabled) {
        if (enabled) {
            this.commentGap = 5;
            GC gc = new GC((Drawable)this.recordSetComment);
            int stringHeight = gc.stringExtent((String)this.recordSetComment.getText()).y;
            this.commentHeight = stringHeight * 2 + 8;
            gc.dispose();
        } else {
            this.commentGap = 0;
            this.commentHeight = 0;
        }
        this.setComponentBounds();
    }

    public void clearHeaderAndComment() {
        if (this.channels.getActiveChannel() != null) {
            RecordSet recordSet = this.channels.getActiveChannel().getActiveRecordSet();
            if (recordSet == null) {
                this.recordSetComment.setText("");
                this.graphicsHeader.setText("");
                this.graphicsHeaderText = null;
                this.recordSetCommentText = null;
                this.recordSetComment.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE + 1, 0));
            }
            this.updateCaptions();
        }
    }

    public synchronized void updateCaptions() {
        this.recordSetComment.redraw();
        this.graphicsHeader.redraw();
    }

    void setComponentBounds() {
        Rectangle graphicsBounds = this.getClientArea();
        int x = 0;
        int y = this.headerGap;
        int width = graphicsBounds.width;
        int height = this.headerHeight;
        this.graphicsHeader.setBounds(x, y, width, height);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "recordSetHeader.setBounds " + this.graphicsHeader.getBounds());
        }
        y = this.headerGap + this.headerHeight;
        height = graphicsBounds.height - (this.headerGap + this.commentGap + this.commentHeight + this.headerHeight);
        this.graphicCanvas.setBounds(x, y, width, height);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "graphicCanvas.setBounds " + this.graphicCanvas.getBounds());
        }
        y = this.headerGap + this.headerHeight + height + this.commentGap;
        height = this.commentHeight;
        this.recordSetComment.setBounds(20, y, width - 40, height - 5);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "recordSetComment.setBounds " + this.recordSetComment.getBounds());
        }
    }

    public boolean isRecordCommentChanged() {
        return this.isRecordCommentChanged;
    }

    public void updateRecordSetComment() {
        RecordSet recordSet;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (recordSet = activeChannel.getActiveRecordSet()) != null) {
            if (this.isRecordCommentChanged) {
                recordSet.setRecordSetDescription(this.recordSetComment.getText());
                recordSet.setUnsaved(RecordSet.UNSAVED_REASON_DATA);
            } else {
                this.recordSetComment.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE + 1, 0));
                this.recordSetCommentText = recordSet.getRecordSetDescription();
                this.recordSetComment.setText(this.recordSetCommentText);
                String graphicsHeaderExtend = this.graphicsHeaderText == null ? " - " + recordSet.getName() : this.graphicsHeaderText.substring(11);
                this.graphicsHeaderText = String.format("%s %s", LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.yyyyMMdd, recordSet.getStartTimeStamp()), graphicsHeaderExtend);
                this.graphicsHeader.setText(this.graphicsHeaderText);
                this.graphicsHeader.redraw();
            }
            this.isRecordCommentChanged = false;
        }
    }

    public Image getGraphicsPrintImage() {
        Image graphicsImage = null;
        int graphicsHeight = 30 + this.canvasBounds.height + 40;
        if (this.graphicsType == GraphicsWindow.GraphicsType.COMPARE) {
            RecordSet compareRecordSet = DataExplorer.getInstance().getCompareSet();
            int numberCompareSetRecords = compareRecordSet.size();
            graphicsHeight = 30 + this.canvasBounds.height + 10 + numberCompareSetRecords * 20;
            graphicsImage = new Image((Device)GDE.display, this.canvasBounds.width, graphicsHeight);
            GC graphicsGC = new GC((Drawable)graphicsImage);
            graphicsGC.setBackground(this.surroundingBackground);
            graphicsGC.setForeground(this.graphicsHeader.getForeground());
            graphicsGC.fillRectangle(0, 0, this.canvasBounds.width, graphicsHeight);
            graphicsGC.setFont(this.graphicsHeader.getFont());
            GraphicsUtils.drawTextCentered(Messages.getString("GDE_MSGT0144"), this.canvasBounds.width / 2, 20, graphicsGC, 256);
            graphicsGC.setFont(this.recordSetComment.getFont());
            int i = 0;
            int yPos = 30 + this.canvasBounds.height + 5;
            while (i < numberCompareSetRecords) {
                Record compareRecord = compareRecordSet.get(i);
                if (compareRecord != null) {
                    graphicsGC.setForeground(SWTResourceManager.getColor(compareRecord.getRGB()));
                    String recordName = "--- " + compareRecord.getName();
                    GraphicsUtils.drawText(recordName, 20, yPos, graphicsGC, 256);
                    graphicsGC.setForeground(this.recordSetComment.getForeground());
                    String description = compareRecord.getDescription();
                    description = description.contains("\n") ? description.substring(0, description.indexOf("\n")) : description;
                    Point pt = graphicsGC.textExtent(recordName);
                    GraphicsUtils.drawText(description, pt.x + 30, yPos, graphicsGC, 256);
                }
                ++i;
                yPos += 20;
            }
            graphicsGC.drawImage(this.canvasImage, 0, 30);
            graphicsGC.dispose();
        } else if (this.graphicsType == GraphicsWindow.GraphicsType.UTIL) {
            graphicsHeight = 30 + this.canvasBounds.height;
            graphicsImage = new Image((Device)GDE.display, this.canvasBounds.width, graphicsHeight);
            GC graphicsGC = new GC((Drawable)graphicsImage);
            graphicsGC.setBackground(this.surroundingBackground);
            graphicsGC.setForeground(this.graphicsHeader.getForeground());
            graphicsGC.fillRectangle(0, 0, this.canvasBounds.width, graphicsHeight);
            graphicsGC.setFont(this.graphicsHeader.getFont());
            GraphicsUtils.drawTextCentered(this.graphicsHeader.getText(), this.canvasBounds.width / 2, 20, graphicsGC, 256);
            graphicsGC.drawImage(this.canvasImage, 0, 30);
            graphicsGC.dispose();
        } else {
            RecordSet activeRecordSet;
            Channel activeChannel = this.channels.getActiveChannel();
            if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
                if (this.canvasImage != null) {
                    this.canvasImage.dispose();
                }
                this.canvasImage = new Image((Device)GDE.display, this.canvasBounds);
                this.canvasImageGC = new GC((Drawable)this.canvasImage);
                this.canvasImageGC.setBackground(this.surroundingBackground);
                this.canvasImageGC.fillRectangle(this.canvasBounds);
                this.canvasImageGC.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
                this.drawCurves(activeRecordSet, this.canvasBounds, this.canvasImageGC);
                graphicsImage = new Image((Device)GDE.display, this.canvasBounds.width, graphicsHeight);
                GC graphicsGC = new GC((Drawable)graphicsImage);
                graphicsGC.setForeground(this.graphicsHeader.getForeground());
                graphicsGC.setBackground(this.surroundingBackground);
                graphicsGC.setFont(this.graphicsHeader.getFont());
                graphicsGC.fillRectangle(0, 0, this.canvasBounds.width, graphicsHeight);
                if (this.graphicsHeader.getText().length() > 1) {
                    GraphicsUtils.drawTextCentered(this.graphicsHeader.getText(), this.canvasBounds.width / 2, 20, graphicsGC, 256);
                }
                graphicsGC.setFont(this.recordSetComment.getFont());
                if (this.recordSetComment.getText().length() > 1) {
                    GraphicsUtils.drawText(this.recordSetComment.getText(), 20, graphicsHeight - 40, graphicsGC, 256);
                }
                graphicsGC.drawImage(this.canvasImage, 0, 30);
                graphicsGC.dispose();
                this.canvasImageGC.dispose();
            }
        }
        return graphicsImage;
    }

    public void setFileComment() {
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null) {
            String fileComment = this.graphicsHeader.getText();
            if (fileComment.indexOf(" - ") > 1) {
                fileComment = fileComment.substring(0, fileComment.indexOf(" - "));
            } else {
                RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
                if (activeRecordSet != null && fileComment.indexOf(activeRecordSet.getName()) > 1) {
                    fileComment = fileComment.substring(0, fileComment.indexOf(activeRecordSet.getName()));
                }
            }
            activeChannel.setFileDescription(fileComment);
            activeChannel.setUnsaved(RecordSet.UNSAVED_REASON_DATA);
        }
    }

    private String getSelectedMeasurementsAsTable() {
        Properties displayProps = this.settings.getMeasurementDisplayProperties();
        RecordSet activeRecordSet = this.application.getActiveRecordSet();
        if (activeRecordSet != null) {
            int indexPosMeasure = activeRecordSet.get(0).getHorizontalPointIndexFromDisplayPoint(this.xPosMeasure);
            IDevice actualDevice = activeRecordSet.getDevice();
            this.recordSetComment.setFont(SWTResourceManager.getFont("Courier New", GDE.WIDGET_FONT_SIZE - 1, 1));
            Vector<Record> records = activeRecordSet.getVisibleAndDisplayableRecords();
            String formattedTimeWithUnit = records.firstElement().getHorizontalDisplayPointAsFormattedTimeWithUnit(this.xPosMeasure);
            StringBuilder sb = new StringBuilder().append(String.format(" %16s ", formattedTimeWithUnit.substring(formattedTimeWithUnit.indexOf(91))));
            for (Record record : records) {
                if (displayProps.getProperty(record.getName()) != null) {
                    sb.append(String.format("|%-10s", displayProps.getProperty(record.getName())));
                    continue;
                }
                String unit = "[" + record.getUnit() + "]";
                String name = record.getName().substring(0, record.getName().length() >= 10 - unit.length() ? 10 - unit.length() : record.getName().length());
                String format = "|%-" + (10 - unit.length()) + "s%" + unit.length() + "s";
                sb.append(String.format(format, name, unit));
            }
            sb.append("| ").append(GDE.LINE_SEPARATOR).append(String.format("%16s  ", formattedTimeWithUnit.substring(0, formattedTimeWithUnit.indexOf(91) - 1)));
            for (Record record : records) {
                sb.append(String.format("|%7s   ", record.getDecimalFormat().format(actualDevice.translateValue(record, (double)record.realGet(indexPosMeasure).intValue() / 1000.0))));
            }
            return sb.append("|").toString();
        }
        this.recordSetComment.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE + 1, 0));
        return this.recordSetCommentText != null ? this.recordSetCommentText : "";
    }

    public static enum GraphicsMode {
        RESET,
        ZOOM,
        MEASURE,
        MEASURE_DELTA,
        PAN,
        CUT_LEFT,
        CUT_RIGHT,
        SCOPE;

    }
}

