/*
 * Copyright (C) 1999-2018. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.20.0 2018-06-30
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef BAUDRATE_SERIAL_SYMBOLIC_NAME_GLOBALISER_SOURCE
#define BAUDRATE_SERIAL_SYMBOLIC_NAME_GLOBALISER_SOURCE

#if defined(__linux__) || defined(__unix__)
    #include <termios.h>
#elif defined(__APPLE__) && defined(__MACH__)
    #include <termios.h>
// Use __CYGWIN__ too, if _WIN32 is not known to mingw.
#elif defined(_WIN32) || defined(__CYGWIN__)
    // The win32 api does not seem to define symbolic names for baudrates.
    // It does assign standard integer values instead:
    // http://msdn.microsoft.com/en-us/library/system.io.ports.serialport.baudrate%28v=vs.110%29.aspx?cs-save-lang=1&cs-lang=cpp#code-snippet-1
    #include "../../../constant/model/cyboi/state/extra_integer_state_cyboi_model.c"
    #include "../../../constant/model/cyboi/state/integer_state_cyboi_model.c"
#else
    #error "Could not compile system. The operating system is not supported. Check out defined preprocessor macros!"
#endif

#include "../../../variable/symbolic_name/baudrate_serial_symbolic_name.c"

//
// The baudrates below were mostly taken from:
//
// http://www.gnu.org/software/libc/manual/html_mono/libc.html#Line-Speed
//
// They are to ensure POSIX.1 portability.
// Each rate represents a speed.
// Their precise numeric values are system-dependent,
// but each name has a fixed meaning:
// B110 stands for 110 bps, B300 for 300 bps, and so on.
// There is no portable way to represent any speed but these,
// but these are the only speeds that typical serial lines can support.
//
// B0  B50  B75  B110  B134  B150  B200
// B300  B600  B1200  B1800  B2400  B4800
// B9600  B19200  B38400  B57600  B115200
// B230400  B460800
//
// BSD defines two additional speed symbols as aliases:
// EXTA is an alias for B19200 and EXTB is an alias for B38400.
// These aliases are OBSOLETE.
//

/**
 * Initialises baudrate serial symbolic name
 * (pre-processor-defined) global variables.
 */
void globalise_symbolic_name_serial_baudrate() {

#if defined(__linux__) || defined(__unix__)
    *B0_BAUDRATE_SERIAL_SYMBOLIC_NAME = B0;
    *B50_BAUDRATE_SERIAL_SYMBOLIC_NAME = B50;
    *B75_BAUDRATE_SERIAL_SYMBOLIC_NAME = B75;
    *B110_BAUDRATE_SERIAL_SYMBOLIC_NAME = B110;
    *B134_BAUDRATE_SERIAL_SYMBOLIC_NAME = B134;
    *B150_BAUDRATE_SERIAL_SYMBOLIC_NAME = B150;
    *B200_BAUDRATE_SERIAL_SYMBOLIC_NAME = B200;
    *B300_BAUDRATE_SERIAL_SYMBOLIC_NAME = B300;
    *B600_BAUDRATE_SERIAL_SYMBOLIC_NAME = B600;
    *B1200_BAUDRATE_SERIAL_SYMBOLIC_NAME = B1200;
    *B1800_BAUDRATE_SERIAL_SYMBOLIC_NAME = B1800;
    *B2400_BAUDRATE_SERIAL_SYMBOLIC_NAME = B2400;
    *B4800_BAUDRATE_SERIAL_SYMBOLIC_NAME = B4800;
    *B9600_BAUDRATE_SERIAL_SYMBOLIC_NAME = B9600;
    *B19200_BAUDRATE_SERIAL_SYMBOLIC_NAME = B19200;
    *B38400_BAUDRATE_SERIAL_SYMBOLIC_NAME = B38400;
    *B57600_BAUDRATE_SERIAL_SYMBOLIC_NAME = B57600;
    *B115200_BAUDRATE_SERIAL_SYMBOLIC_NAME = B115200;
    *B230400_BAUDRATE_SERIAL_SYMBOLIC_NAME = B230400;
    *B460800_BAUDRATE_SERIAL_SYMBOLIC_NAME = B460800;
    *B500000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B500000;
    *B576000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B576000;
    *B921600_BAUDRATE_SERIAL_SYMBOLIC_NAME = B921600;
    *B1000000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B1000000;
    *B1152000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B1152000;
    *B1500000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B1500000;
    *B2000000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B2000000;
    *B2500000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B2500000;
    *B3000000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B3000000;
    *B3500000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B3500000;
    *B4000000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B4000000;
#elif defined(__APPLE__) && defined(__MACH__)
    *B0_BAUDRATE_SERIAL_SYMBOLIC_NAME = B0;
    *B50_BAUDRATE_SERIAL_SYMBOLIC_NAME = B50;
    *B75_BAUDRATE_SERIAL_SYMBOLIC_NAME = B75;
    *B110_BAUDRATE_SERIAL_SYMBOLIC_NAME = B110;
    *B134_BAUDRATE_SERIAL_SYMBOLIC_NAME = B134;
    *B150_BAUDRATE_SERIAL_SYMBOLIC_NAME = B150;
    *B200_BAUDRATE_SERIAL_SYMBOLIC_NAME = B200;
    *B300_BAUDRATE_SERIAL_SYMBOLIC_NAME = B300;
    *B600_BAUDRATE_SERIAL_SYMBOLIC_NAME = B600;
    *B1200_BAUDRATE_SERIAL_SYMBOLIC_NAME = B1200;
    *B1800_BAUDRATE_SERIAL_SYMBOLIC_NAME = B1800;
    *B2400_BAUDRATE_SERIAL_SYMBOLIC_NAME = B2400;
    *B4800_BAUDRATE_SERIAL_SYMBOLIC_NAME = B4800;
    *B9600_BAUDRATE_SERIAL_SYMBOLIC_NAME = B9600;
    *B19200_BAUDRATE_SERIAL_SYMBOLIC_NAME = B19200;
    *B38400_BAUDRATE_SERIAL_SYMBOLIC_NAME = B38400;
    *B57600_BAUDRATE_SERIAL_SYMBOLIC_NAME = B57600;
    *B115200_BAUDRATE_SERIAL_SYMBOLIC_NAME = B115200;
    *B230400_BAUDRATE_SERIAL_SYMBOLIC_NAME = B230400;
    //*B460800_BAUDRATE_SERIAL_SYMBOLIC_NAME = B460800;
    //*B500000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B500000;
    //*B576000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B576000;
    //*B921600_BAUDRATE_SERIAL_SYMBOLIC_NAME = B921600;
    //*B1000000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B1000000;
    //*B1152000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B1152000;
    //*B1500000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B1500000;
    //*B2000000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B2000000;
    //*B2500000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B2500000;
    //*B3000000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B3000000;
    //*B3500000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B3500000;
    //*B4000000_BAUDRATE_SERIAL_SYMBOLIC_NAME = B4000000;
// Use __CYGWIN__ too, if _WIN32 is not known to mingw.
#elif defined(_WIN32) || defined(__CYGWIN__)
    *B0_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_0_INTEGER_STATE_CYBOI_MODEL;
    *B50_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_50_INTEGER_STATE_CYBOI_MODEL;
    *B75_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_75_INTEGER_STATE_CYBOI_MODEL;
    *B110_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_110_INTEGER_STATE_CYBOI_MODEL;
    *B134_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_134_INTEGER_STATE_CYBOI_MODEL;
    *B150_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_150_INTEGER_STATE_CYBOI_MODEL;
    *B200_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_200_INTEGER_STATE_CYBOI_MODEL;
    *B300_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_300_INTEGER_STATE_CYBOI_MODEL;
    *B600_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_600_INTEGER_STATE_CYBOI_MODEL;
    *B1200_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_1200_INTEGER_STATE_CYBOI_MODEL;
    *B1800_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_1800_INTEGER_STATE_CYBOI_MODEL;
    *B2400_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_2400_INTEGER_STATE_CYBOI_MODEL;
    *B4800_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_4800_INTEGER_STATE_CYBOI_MODEL;
    *B9600_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_9600_INTEGER_STATE_CYBOI_MODEL;
    *B19200_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_19200_INTEGER_STATE_CYBOI_MODEL;
    *B38400_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_38400_INTEGER_STATE_CYBOI_MODEL;
    *B57600_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_57600_INTEGER_STATE_CYBOI_MODEL;
    *B115200_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_115200_INTEGER_STATE_CYBOI_MODEL;
    *B230400_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_230400_INTEGER_STATE_CYBOI_MODEL;
    *B460800_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_460800_INTEGER_STATE_CYBOI_MODEL;
    *B500000_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_500000_INTEGER_STATE_CYBOI_MODEL;
    *B576000_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_576000_INTEGER_STATE_CYBOI_MODEL;
    *B921600_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_921600_INTEGER_STATE_CYBOI_MODEL;
    *B1000000_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_1000000_INTEGER_STATE_CYBOI_MODEL;
    *B1152000_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_1152000_INTEGER_STATE_CYBOI_MODEL;
    *B1500000_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_1500000_INTEGER_STATE_CYBOI_MODEL;
    *B2000000_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_2000000_INTEGER_STATE_CYBOI_MODEL;
    *B2500000_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_2500000_INTEGER_STATE_CYBOI_MODEL;
    *B3000000_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_3000000_INTEGER_STATE_CYBOI_MODEL;
    *B3500000_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_3500000_INTEGER_STATE_CYBOI_MODEL;
    *B4000000_BAUDRATE_SERIAL_SYMBOLIC_NAME = *NUMBER_4000000_INTEGER_STATE_CYBOI_MODEL;
#else
    #error "Could not compile system. The operating system is not supported. Check out defined preprocessor macros!"
#endif
}

/* BAUDRATE_SERIAL_SYMBOLIC_NAME_GLOBALISER_SOURCE */
#endif
