/*
 * Copyright (C) 1999-2018. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.20.0 2018-06-30
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef NAME_PART_GETTER_SOURCE
#define NAME_PART_GETTER_SOURCE

#include "../../../../constant/model/cyboi/log/level_log_cyboi_model.c"
#include "../../../../constant/model/cyboi/state/pointer_state_cyboi_model.c"
#include "../../../../executor/accessor/getter/part/knowledge_part_getter.c"
#include "../../../../executor/accessor/name_getter/array_name_getter.c"
#include "../../../../logger/logger.c"

/**
 * Gets the part with the given name from the whole.
 *
 * @param p0 the destination part (pointer reference)
 * @param p1 the source whole data
 * @param p2 the part name data
 * @param p3 the part name count
 * @param p4 the source whole count
 * @param p5 the knowledge memory part (pointer reference)
 * @param p6 the stack memory item
 * @param p7 the internal memory data
 */
void get_part_name(void* p0, void* p1, void* p2, void* p3, void* p4, void* p5, void* p6, void* p7) {

    log_message_terminated((void*) DEBUG_LEVEL_LOG_CYBOI_MODEL, (void*) L"Get part name.");

    // The source model part.
    void* s = *NULL_POINTER_STATE_CYBOI_MODEL;

    // Get source model part by name.
    get_name_array((void*) &s, p1, p2, p3, p4, (void*) FALSE_BOOLEAN_STATE_CYBOI_MODEL);

    // Get actual destination part behind source model part.
    get_part_knowledge(p0, (void*) &s, p5, p6, p7);
}

/* NAME_PART_GETTER_SOURCE */
#endif
