/* 
    Copyright (C) 2024, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptoverdrive";
declare description "overdrive filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.11";
declare license "GPL 3.0 or later";

//link the librarys
si = library("signals.lib");
fi = library("effect.lib");
aa = library("aanl.lib");
co = library("compressors.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
  nchannels = 2;// number of channels; 1 for mono, 2 for stereo
  peak_bandwidth = 200;// the bandwidth for applying the peak
};

// a slier for the pregain
pregain = hslider("[1]pregain", 0.5, 0, 20, 0.1) : si.smoo;

// a slider for the gain
gain = hslider("[5]gain", 0.6, 0, 1, 0.01) : si.smoo;

// the function for applying the peak
peak =  fi.peak_eq(toneraise, tonefreq, constant.peak_bandwidth)
with{
  // a slider for the freqency going to be raised
  tonefreq = hslider("[3]frequency[lv2:integer]",300,0,10000,1) : si.smoo;

  // a slider how much the frequency is going to be raised
  toneraise = hslider("[4]frequency raise",0,0,30,0.1) : si.smoo;  
};

//overdrive
overdrive = drive : (aa.hardclip)
with {
    // a slider for the drive
  drive = hslider("[2]drive[lv2:integer]",100,1,200,1) : si.smoo;
};
     
// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par(i, constant.nchannels, cptbasics.bargraphinput(i) :
				     cptbasics.drywetmono (pregain * peak * overdrive * gain) :
				     cptbasics.bargraphoutput(i));
