<?php

// -----------------------------------------------------------------------
// This file is part of beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//

// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

class User {
	// CLASS FUNCTIONS
	// User
	// loginUser
	// selUser
	// registerUser
	// sendPassword
	// getPermission
	// selUsers
	// selUserPermissions
	// updateUserPermissions



	// User ------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 28th May 2005
	//
	function User($db) {
		$this->db = $db;
	}//EO User



	// loginUser -------------------------------------------------------------
	// logs in the user
	// tom calthrop - 28th May 2005
	//
	function loginUser($email, $password) {
		
		if (empty($email) || empty($password)) {
			$GLOBALS['beacon_error_log'][] = array(4, null);
		}
		
		if (empty($GLOBALS['beacon_error_log'])) {
			$query = "SELECT
				u.user_id, u.user_email, u.user_name  
				FROM " . $this->db->prefix . "_user u 
				WHERE 
				u.user_email='" . $email . "' AND
				u.user_password='" . MD5($password) . "'"
			;
			
			$result = $this->db->Execute($query);
	
			if (isset($result->fields['user_id'])){
				
				$this->user_id = $result->fields['user_id'];
	
				// Sets the session variables
				$_SESSION['user_id'] = 			$result->fields['user_id'];
				$_SESSION['user_name'] = 		$result->fields['user_name'];
				$_SESSION['user_email'] = 		$result->fields['user_email'];
				
				$datetime = date("Y-m-d H:i:s");
				$datetime = $this->db->DBDate($datetime);
				
				$query = "UPDATE " . $this->db->prefix . "_user u 
					SET u.user_last_login_datetime=" . $datetime . " 
					WHERE 
					u.user_id=" . $result->fields['user_id']
				;
				
				$result = $this->db->Execute($query);
				
				
			}
			else {
				$GLOBALS['beacon_error_log'][] = array(5, null);
			}
		}
	}//EO loginUser



	// selUser ---------------------------------------------------------------
	// retrieves single DB row for user
	// tom calthrop - 28th May 2005
	//
	function selUser($user_id = null) {
		if (empty($user_id) && isset($this->user_id)) {
			$user_id = $this->user_id;
		}

		$query = "
			SELECT u.user_id, u.user_name, u.user_email 
			FROM " . $this->db->prefix . "_user u
			WHERE 
			u.user_id=" . $user_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields['user_id'])) {
			$temp = $result->fields;
			$this->user_id = $temp['user_id'];

			$result->Close();
			return $temp;
		}
	}//EO selUser


	
	// registerUser ---------------------------------------------------------------
	// inserts row into user table
	// tom calthrop - 28th May 2005
	//
	function registerUser($data) {
		
		if (empty($data['user_email']) || empty($data['user_password'])) {
			$GLOBALS['beacon_error_log'][] = array(5, null);
		}
		
		if (isset($data['user_password']) && strlen($data['user_password']) < 5) {
			$GLOBALS['beacon_error_log'][] = array(6, null);
		}
		
		if (empty($GLOBALS['beacon_error_log'])) {
			
			if (!empty($data['allow_correspondence'])) {
				$allow_correspondence = 1;
			}
			else {
				$allow_correspondence = "null";
			}
			
			if (!empty($data['show_email'])) {
				$show_email = 1;
			}
			else {
				$show_email = "null";
			}
			
			$password = md5($data['user_password']);
			
			$datetime = date("Y-m-d H:i:s");
			$datetime = $this->db->DBDate($datetime);
				
			$query = "
				INSERT INTO " . $this->db->prefix . "_user SET
				user_name='" . $data['user_name'] . "',
				user_email='" . $data['user_email'] . "',
				allow_correspondence=" . $allow_correspondence . ",
				show_email=" . $show_email . ",
				user_password='" . $password . "', 
				user_create_datetime=" . $datetime
			;
				
			$result = $this->db->Execute($query);
	
			if (!empty($result)) {
				
				$query = "
					SELECT user_id
					FROM " . $this->db->prefix . "_user
					WHERE
					user_email='" . $data['user_email'] . "'"
				;
				
				$result = $this->db->Execute($query);
				
				if (isset($result->fields)) {
					$this->user_id = $result->fields['user_id'];
				}
			}
		}
	}//EO registerUser
	
	
	
	// checkPermission --------------------------------------------------------
	// returns true if permission is set.
	// tom calthrop - 28th May 2005
	//
	function checkPermission($permission_id) {
		if (!isset($this->user_id)) {
			return 0;
			break;
		}
		
		$query = "
			SELECT user_id 
			FROM " . $this->db->prefix . "_permission 
			WHERE 
			user_id=" . $this->user_id . " AND 
			permission_id=" . $permission_id
		;
		
		$result = $this->db->Execute($query);
			
		if (!empty($result->fields['user_id'])) {
			return 1;
			$result->Close();
		}
		else{
			return 0;
		}
	} //EO checkPermission
	
	
	
	// selUsers --------------------------------------------------------------------
	// returns multiple rows of items from DB
	// tom calthrop - 31st May 2005
	//
	function selUsers() {
		$query = "
			SELECT u.user_id, u.user_name, u.user_email 
			FROM " . $this->db->prefix . "_user u  
			WHERE "
		;
		
		$query .="1=1 ";

		if (isset($this->order_by)) {
		    $query .= "order by u." . $this->order_by;
		}
		else {
			$query .= "order by u.user_id";
		}
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {

				$temp1 = $result->fields;
				$temp1['user_email'] = formatEmail($temp1['user_email']);
				array_push($temp, $temp1);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selUsers class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	} //EO selUsers()
	
	
	// selUserPermissions --------------------------------------------------------
	// select user permissions
	// tom calthrop - 28th May 2005
	//
	function selUserPermissions() {
		
		$query = "
			SELECT permission_id 
			FROM " . $this->db->prefix . "_permission 
			WHERE 
			user_id=" . $this->user_id
		;
		
		$result = $this->db->Execute($query);
			
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {

				$temp1 = $result->fields;
				array_push($temp, $temp1);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selUserPermissions class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	} //EO selUserPermissions
	
	
	// updateUserPermissions --------------------------------------------------------
	// update user permissions
	// tom calthrop - 28th May 2005
	//
	function updateUserPermissions($perm_arr) {
		
		$query = "
			DELETE FROM " . $this->db->prefix . "_permission  
			WHERE 
			user_id=" . $this->user_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($perm_arr)) {
			$rownums = count($perm_arr);
		}

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				INSERT INTO " . $this->db->prefix . "_permission (
				user_id,
				permission_id)
				VALUES (
				" . $this->user_id . ", 
				" . $perm_arr[$i] . ")"
			;

			$result = $this->db->Execute($query);

			if (empty($result)) {
				$error_info = "function=updateUserPermissions class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} // EO updateUserPermissions
	

}
