<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<form action="grp_list.php" method="post">

<div class="col_left1">
	<?php
	if (isset($me['user_id'])) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_my_groups'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($my_groups)) {
				foreach($my_groups as $key => $i):
				?>
					<p>
						<a href="grp_view.php?group_id=<?php echo $i['group_id'];?>"><?php echo $i['group_title'];?></a><br />
					</p>
				<?php
				endforeach;
				} else {
				?>
					<p>
						<?php echo $lang['err_no_groups'];?><br />
					</p>
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_groups'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['txt_group_intro'];?><br />
				<p>
					<?php echo $lang['txt_group_tag'];?>:
					<?php
					$tags = "";
					if (isset($group_tags)) {
						foreach ($group_tags as $key => $i):
							$tags .= "<a href='grp_list.php?grp_tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
							$tags .= ", ";
						endforeach;
						
						$tags .= "<a href='grp_list.php'>" . $lang['txt_latest'] . "</a>";
							
						echo $tags;
					}
					?>
				</p>
				
				<p>
					<?php echo $lang['txt_my_tag'];?>:
					<?php
					$tags = "";
					if (isset($my_tags)) {
						foreach ($my_tags as $key => $i):
							$tags .= "<a href='grp_list.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
							$tags .= ", ";
						endforeach;
						
						$tags .= "<a href='grp_list.php'>" . $lang['txt_latest'] . "</a>";
							
						echo $tags;
					}
					?>
				</p>
				
				<p>
					<b><?php echo $lang['txt_search'];?></b><br />
				</p>
				<p>
					<input type="text" name="search_text" size="20" value="" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_right1">
	<div class="box">
		<div class="box_top">
			<?php
			if (!empty($tag)) {
				echo $lang['hdr_tagged_groups'] . ": " . $tag;
			}
			else {
				echo $lang['hdr_latest_groups'];
			}?>
			<br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					if (isset($groups)) {
					foreach($groups as $key => $i):
					?>
					<tr>
						<td valign="top">
							<a href="grp_view.php?group_id=<?php echo $i['group_id'];?>"><img align="left" src="get_file.php?file=<?php echo $i['image']['file'];?>" class="picture" alt="<?php echo $i['image']['file_title'];?>" /></a>
						</td>
						<td valign="top">
							<a href="grp_view.php?group_id=<?php echo $i['group_id'];?>"><?php echo $i['group_title'];?></a><br />
							<?php echo $i['group_synopsis'];?><br />
							<p>
							<?php echo $lang['txt_recommended_age'];?>:
							<?
							if ($i['group_from_age'] && $i['group_to_age']) {
								echo $i['group_from_age'] . "/" . $i['group_to_age'];
							}
							else if ($i['group_from_age'] && !$i['group_to_age']) {
								echo $lang['txt_age_from'] . " " . $i['group_from_age'];
							}
							else if (!$i['group_from_age'] && $i['group_to_age']) {
								echo $lang['txt_age_upto'] . " " . $i['group_to_age'];
							}
							else {
								echo $lang['txt_age_all'];
							}
							?>
							<br />
							</p>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="4" alt="" /><br />
						</td>
					</tr>
					<?php
					endforeach;
					} else {
					?>
					<tr>
						<td colspan="2">
							<?php echo $lang['err_no_groups'];?><br />
						</td>
					</tr>
					<?php }?>
				</table>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>
</form>
