<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_activity.inc.php";
require_once($c_node['dir']['class_path'] . 'Schedule.class.php');
require_once($c_node['dir']['class_path'] . 'Group.class.php');


//append language setup
require_once($languageArrayPath . 'arr_activities.lang.php');


if(!isset($_REQUEST["time"]))
	$time = mktime();
else
	$time = $_REQUEST["time"];

$now = getdate($time);

$sched = new Schedule($db, $now, $me['user_id']);


//get date
$sched->setScheduleBase();


// get global activities
if (!empty($lang['arr_activities'])) {
	foreach($lang['arr_activities'] as $index => $activity_tmp):
		$activities[] = $sched->modifyActivityDate($activity_tmp);
	endforeach;
}

//setup group
require_once($c_node['dir']['class_path'] . 'Group.class.php');
$group = new Group($db, $date, null);
$group->user_id = $user_id;
$group->registration_types = $c_node['group']['registration_type'];
// get all group events
$output_groups = $group->getMyGroups();

if (!empty($output_groups)) {
	foreach($output_groups as $index1 => $temp):
		$activity->section_item_id = $temp['group_id'];
		$activities_v = $activity->getActivities();
		foreach($activities_v as $index => $activity_tmp):
			if(isset($activity_tmp)) {
				$activities[] = $sched->modifyActivityDate($activity_tmp);
			}
		endforeach;
	endforeach;
}


// get all user events
$activity->section_id = $c_acs['arr_section']['group'];
$activities_v = $activity->getActivities();
if (!empty($activities_v)) {
	foreach($activities_v as $index => $activity_tmp):
		if(isset($activity_tmp)) {
			$activities[] = $sched->modifyActivityDate($activity_tmp);
		}
	endforeach;
}


// Populate all activities
foreach($activities as $index => $activity_tmp)
	$sched->populateActivity($activity_tmp);

$schedule = $sched->getSchedule();  // Get the schedule array
$todo     = $sched->getToDo();      // Get the todo array

// Get last and next months timestamp
$links["last"] = $date->getDayTime($time, -1);
$links["next"] = $date->getDayTime($time, 1);

// Get the calendar view month name
$today = $date->getDayString($time);
$name["last"] = $date->getDayString($time, -1);
$name["next"] = $date->getDayString($time, 1);

// Get the maximum number of activities at one hour
$nr = floor($sched->getMax());

//move to template
if (!empty($time)) {
	$body->set('time', $time);
}

if (!empty($schedule)) {
	$body->set('calendar', $schedule);
}

if (!empty($todo)) {
	$body->set('todo', $todo);
}

if (!empty($today)) {
	$body->set('today', $today);
}

if (!empty($links)) {
	$body->set('links', $links);
}

if (!empty($nr)) {
	$body->set('nr', $nr);
}

if (!empty($name)) {
	$body->set('name', $name);
}

$template_pageLink = "activities";
include "inc/footer.inc.php";

?>
