# This file is part of AROUNDMe
#  
# Copyright (C) 2003, 2006 Barnraiser
# http://www.barnraiser.org/
# 
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with program; see the file COPYING. If not, write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.



# Table structure for table `am_group`
CREATE TABLE `am_group` (
  `group_id` int(11) NOT NULL auto_increment,
  `group_title` varchar(255) default NULL,
  `group_unix_title` varchar(8) default NULL,
  `group_synopsis` varchar(255) default NULL,
  `group_body` text,
  `group_css` text,
  `group_policy` text,
  `language_id` int(3) default NULL,
  `location_id` int(3) default NULL,
  `group_create_datetime` datetime default NULL,
  `group_type` int(11) default NULL,
  `group_from_age` int(11) default NULL,
  `group_to_age` int(11) default NULL,
  `level_id` int(1) default NULL,
  `user_id` int(11) default NULL,
  `default_user_permission` int(11) default NULL,
  `file_id` int(11) default NULL,
  `status_id` int(3) default NULL,
  PRIMARY KEY  (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Table structure for table `am_group_poll`
CREATE TABLE `am_group_poll` (
  `poll_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `poll_question` varchar(255) default NULL,
  `poll_anon` int(1) default NULL,
  `user_id` int(11) default NULL,
  `poll_create_datetime` datetime default NULL,
  PRIMARY KEY  (`poll_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Table structure for table `am_group_poll_answer`
CREATE TABLE `am_group_poll_answer` (
  `answer_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `poll_id` int(11) default NULL,
  `option_id` int(11) default NULL,
  `current_answer` int(1) default NULL,
  `answer_create_datetime` datetime default NULL,
  PRIMARY KEY  (`answer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Table structure for table `am_group_poll_option`
CREATE TABLE `am_group_poll_option` (
  `option_id` int(11) NOT NULL auto_increment,
  `poll_id` int(11) default NULL,
  `option_body` varchar(255) default NULL,
  `option_order` int(3) default NULL,
  PRIMARY KEY  (`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Table structure for table `am_group_recommend`
CREATE TABLE `am_group_recommend` (
  `group_id` int(11) default NULL,
  `module_id` int(11) default NULL,
  `item_id` int(11) default NULL,
  `inner_item_id` int(11) default NULL,
  `subject_id` int(11) default NULL,
  `recommend_create_datetime` datetime default NULL,
  `recommend_note` varchar(255) default NULL,
  `user_id` int(11) default NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Table structure for table `am_group_subject`
CREATE TABLE `am_group_subject` (
  `subject_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `topic_id` int(11) default NULL,
  `subject_title` varchar(255) default NULL,
  `file_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `subject_synopsis` varchar(255) default NULL,
  `subject_body` text,
  `subject_create_datetime` datetime default NULL,
  `subject_edit_datetime` datetime default NULL,
  `subject_locked` int(1) default NULL,
  `subject_sticky` int(1) default NULL,
  `poll_id` int(11) default NULL,
  PRIMARY KEY  (`subject_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Table structure for table `am_group_topic`
CREATE TABLE `am_group_topic` (
  `topic_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `topic_title` varchar(50) default NULL,
  `topic_synopsis` varchar(255) default NULL,
  `topic_hidden` int(1) default NULL,
  `topic_order` int(3) default NULL,
  `topic_create_datetime` datetime default NULL,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`topic_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# END OF SQL
