// Copyright (C) 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "config.h"
#include <sigc++/functors/mem_fun.h>
#include "snd.h"
#include "File.h"
#include "Configuration.h"
#include "defs.h"
#include <gstreamermm/playbin2.h>
#include <gstreamermm/fakesink.h>
#include <gstreamermm/elementfactory.h>


Snd* Snd::s_instance = 0;

Snd* Snd::getInstance()
{
  if (!s_instance)
    s_instance = new Snd();

  return s_instance;
}

void Snd::deleteInstance()
{
  if (!s_instance)
    return;

  delete s_instance;
  s_instance = NULL;
}

Snd::Snd()
{
  playbin = Gst::PlayBin2::create();
}

Snd::~Snd()
{
}

void Snd::play(Glib::ustring piece)
{
  if (!Configuration::s_musicenable)
    return;
  if (!d_soundset)
    return;
  playbin->set_state(Gst::STATE_NULL);
  playbin->property_uri() = "file://" + d_soundset->getPieceFilename(piece);
  playbin->property_video_sink() = Gst::FakeSink::create();
  playbin->property_audio_sink() = Gst::ElementFactory::create_element("autoaudiosink", "output");
  playbin->set_state(Gst::STATE_PLAYING);

  return;
}

void Snd::loadSoundset(Soundset *soundset)
{
  d_soundset = soundset;
}

