//  Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "reinforcement-point.h"

std::string ReinforcementPoint::d_tag = "reinforcementpoint";

ReinforcementPoint::ReinforcementPoint(Vector<int> src, Player *owner)
        :OwnerId(owner->getId()), Immovable(src)
{
}

ReinforcementPoint::ReinforcementPoint(XML_Helper* helper)
        :OwnerId(helper), Immovable(helper)
{
}

ReinforcementPoint::ReinforcementPoint(const ReinforcementPoint& s)
        :OwnerId(s), Immovable(s)
{
}

ReinforcementPoint::~ReinforcementPoint()
{
}

bool ReinforcementPoint::save(XML_Helper* helper) const
{
    bool retval = true;

    retval &= helper->openTag(ReinforcementPoint::d_tag);
    retval &= helper->saveData("owner", getOwnerId());
    retval &= helper->saveData("x", getPos().x);
    retval &= helper->saveData("y", getPos().y);
    retval &= helper->closeTag();
    
    return retval;
}
