// Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.
#ifndef MAPTILE_H
#define MAPTILE_H

#include <gtkmm.h>
#include <list>
class StackTile;

class Maptile
{
    public:
        //! Enumeration of all possible constructed objects on the maptile.
	/**
	 * Each member in the enumeration refers to a class that inherits 
	 * the Location class.
	 */
        enum Building {
	  NONE=0, 
	  PASSABLE_WATER=1, 
	  FOREST=2, 
	  UNPASSABLE_WATER=3, 
	  ROAD=4, 
	  BRICK=5, 
          BROKEN_BRICK = 6
	};

        Maptile(int x, int y, guint32 type);

	//! Destructor.
        ~Maptile();

        //! Set which kind of building is on this maptile.
        void setType(Building building){d_building = building;}

        //! Get which building is on the maptile.
        guint32 getType() const {return d_building;}

	//! Get the list of Stack objects on this maptile.
	StackTile *getStacks() const {return d_stacktile;};
        
        bool isWater() {return (getType() == PASSABLE_WATER || getType() == UNPASSABLE_WATER);}
	bool d_blocked[8];

    private:
	//! The type of constructed object on this maptile.
        Building d_building;

	//! The list of pointers to stacks on this maptile.
	StackTile *d_stacktile;
};

#endif // MAPTILE_H

// End of file
