#!/bin/sh
#############################################################################
# arc.sh -- local Argile compiler wrapping script
#
#   Copyright (C) 2009 the Argile authors
#
#   This software is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This software is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this software.  If not, see <http://www.gnu.org/licenses/>.
#
#############################################################################
#
# This script runs the argile compile, either from the backup if present,
# or from an external installation otherwise.
#

#-------------------------------------------------#
# Usage: arc.sh <BACKUP_DIR> [<ARC_ARGUMENTS>...] #
#-------------------------------------------------#

# script name
self=$(basename "$0")

# build dir
dir="$1" ; shift

# arc
arc="$dir/arc"

# libargile.so
lib="$dir/libargile.so"

# std.so
std="$dir/std.so"

local_arc_is_ready() {
    [ -d "$dir" ] || return 1
    [ -x "$arc" ] || return 1
    [ -e "$lib" ] || return 1
    [ -e "$std" ] || return 1
    return 0
}

echo_exec() {
    echo "$self: $*"
    exec "$@"
}

# exec
if local_arc_is_ready; then
    export ARGILE_SOM_PATH="$dir:$ARGILE_SOM_PATH"
    export LD_LIBRARY_PATH="$dir:$LD_LIBRARY_PATH"
    export LD_PRELOAD="$lib"
    echo_exec "$arc" "$@"
else
    # trying external argile compiler
    echo_exec arc "$@"
fi
