// generated by: arc -uRNLP -A ../libargile -A ../argrt -o arc.c -H arc.h -m arc.argl arc.arg 
#line 25 "arc.arg"
#define _GNU_SOURCE //;
#include <getopt.h> //;

#include "arc.h"

#line 523 "arc.arg"
typedef struct modbind_t_s modbind_t;

#line 523 "arc.arg"
struct modbind_t_s {
  argile_module_t * module;
  argile_bind_t * bind;
};

#line 210 "arc.arg"
static void add_path_free(char *, char opt1);
/** :add path <text path> (- - free): -> nothing **/
#line 172 "arc.arg"
static void add_som_path_free(char *, char opt1);
/** :add som path <text path> (- - free): -> nothing **/
#line 419 "arc.arg"
static void check_is_positive(char * * oname, int);
/** :check <int i> is positive: -> nothing **/
#line 422 "arc.arg"
static void check_is_a_number(char *);
/** :check <text t> is a number: -> nothing **/
#line 442 "arc.arg"
static void split_into_and_rewind(char *, argile_list_t * *, char opt1);
/** :split <text v> into <(list) & tail> (and rewind): -> nothing **/
#line 449 "arc.arg"
static char * mystrndup(char *, int);
/** :mystrndup <text t> <int size>: -> text **/
#line 578 "arc.arg"
static unsigned char make_implicit_binds();
/** :make implicit binds: -> bool **/
#line 765 "arc.arg"
static void print_command_line_in(FILE *);
/** :print command line in <FILE f>: -> nothing **/
#line 522 "arc.arg"
static void print_bind_doc(argile_module_t *, argile_bind_t *);
/** :print bind doc <module mod> <bind bnd>: -> nothing **/
#line 527 "arc.arg"
static int bindcmp(modbind_t *, modbind_t *);
/** :bindcmp <modbind a> <modbind b>: -> int **/
#line 675 "arc.arg"
static void argile_def_2(argile_def_t *);
/** :<def>: -> nothing **/
#line 747 "arc.arg"
static unsigned char has_ext(char *, int, char *, int);
/** :<text file> <int fs> has ext <text ext> <int es>: -> bool **/
#line 800 "arc.arg"
static int print_rejects(argile_call_t *, int);
/** :print rejects <call> <int count>: -> int **/

#line 30 "arc.arg"
char * filename = (char *)0;
char * output = (char *)0;
char * module = (char *)0;
char * line = (char *)0;
char * deps = (char *)0;
char * head = (char *)0;
char * grep = (char *)0;
int colpertab = -1;
int maxmatch = -1;
int maxcomp = -1;
int maxgen = -1;
int maxrejt = -1;
unsigned char nocolors;
unsigned char noautouse;
unsigned char dump_mode;
unsigned char dump_indent;
unsigned char verbose;
unsigned char do_main;
unsigned char concat;
unsigned char stats;
unsigned char debugcomp;
unsigned int genlines = 0;
unsigned char daltonism;
unsigned char utf8;
unsigned char hexastr;
unsigned char proto_syntax;
unsigned char show_progress;
argile_list_t * file_path = ((argile_list_t *)0);
argile_list_t * env_path = ((argile_list_t *)0);
argile_list_t * som_path = ((argile_list_t *)0);
argile_list_t * auto_use = ((argile_list_t *)0);
argile_list_t * so_mods = ((argile_list_t *)0);
argile_list_t * env_mods = ((argile_list_t *)0);
argile_list_t * mod_docs = ((argile_list_t *)0);
argile_list_t * arg_opts = ((argile_list_t *)0);
#line 67 "arc.arg"
void * firstbrk = NULL;
#line 70 "arc.arg"
char *(* global_argv);
int global_argc = 0;
#line 125 "arc.arg"
int errorCode = 0;

#line 173 "arc.arg"
static argile_list_t * first_path = ((argile_list_t *)0);

#line 211 "arc.arg"
static argile_list_t * first_path_2 = ((argile_list_t *)0);

#line 524 "arc.arg"
static argile_list_t * binds = ((argile_list_t *)0);

#line 139 "arc.arg"
void vmessage(char * msg, ...)
/** :vmessage <text msg> [...]: -> nothing **/
{
#line 141 "arc.arg"
  va_list vargs;

#line 140 "arc.arg"
  if (!(verbose)) {
#line 464 "../argrt/std.argl"
    return;
  } //;
#line 142 "arc.arg"
  fprintf(stderr, " * ");
  if (((*&(msg)[0] >= 'a') && (*&(msg)[0] <= 'z'))) {
    fprintf(stderr, "%c", (*&((msg)++)[0] + ('A' - 'a')));
  } //;
#line 145 "arc.arg"
  va_start(vargs, msg);
  vfprintf(stderr, msg, vargs);
  va_end(vargs);
  fprintf(stderr, "...\n");
}

#line 150 "arc.arg"
void complete_som_path()
/** :complete som path: -> nothing **/
{
#line 154 "arc.arg"
  char * var = "";

#line 151 "arc.arg"
  if ((som_path)) {
    return;
  } //;
#line 153 "arc.arg"
  add_som_path_free(".", 0);
  if (((var = ((char *)getenv("HOME"))))) {
    char( dir[512]);

#line 156 "arc.arg"
    snprintf(((char *)dir), sizeof(dir), "%s/lib/argile", var);
    add_som_path_free(argile_dbg_strdup(((char *)dir)), 1);
  } //;
#line 158 "arc.arg"
  if ((var = ((char *)getenv("LD_LIBRARY_PATH")))) {
    char * s = "";

#line 159 "arc.arg"
    s = var;
    while ((*&(var)[0] != 0)) {
      while (((*&(s)[0] != 0) && (*&(s)[0] != *&(":")[0]))) {
#line 161 "arc.arg"
        (s)++;
      };
#line 162 "arc.arg"
      if ((s != var)) {
        int n = 0;
        char * d = "";

#line 163 "arc.arg"
        n = ((s) - var);
        d = ((char *)argile_dbg_malloc((n + 8)));
        memcpy(d, var, n);
        memcpy(((d) + n), "/argile", 8);
        add_som_path_free(d, 1);
      } //;
#line 168 "arc.arg"
      if ((*&(s)[0] != 0)) {
#line 464 "../argrt/std.argl"
        (s)++;
      } //;
#line 169 "arc.arg"
      var = s;
    };
  } //;
#line 170 "arc.arg"
  add_som_path_free("/usr/lib/argile", 0);
  som_path = argile_list_start(som_path);
}

#line 182 "arc.arg"
void complete_file_path()
/** :complete file path: -> nothing **/
{
#line 191 "arc.arg"
  char * var = "";

#line 183 "arc.arg"
  if ((env_path != NULL)) {
    if ((file_path != NULL)) {
      argile_list_link(file_path, env_path);
      file_path = argile_list_start(file_path);
    } else {
      file_path = env_path;
    };
#line 189 "arc.arg"
    return;
  } //;
#line 190 "arc.arg"
  add_path_free(".", 0);
  if (((var = ((char *)getenv("HOME"))))) {
    char( dir[512]);

#line 193 "arc.arg"
    snprintf(((char *)dir), sizeof(dir), "%s/lib/argile", var);
    add_path_free(argile_dbg_strdup(((char *)dir)), 1);
  } //;
#line 195 "arc.arg"
  if ((var = ((char *)getenv("LD_LIBRARY_PATH")))) {
    char * s = "";

#line 196 "arc.arg"
    s = var;
    while ((*&(var)[0] != 0)) {
      while (((*&(s)[0] != 0) && (*&(s)[0] != *&(":")[0]))) {
#line 198 "arc.arg"
        (s)++;
      };
#line 199 "arc.arg"
      if ((s != var)) {
        int n = 0;
        char * d = "";

#line 200 "arc.arg"
        n = ((s) - var);
        d = ((char *)argile_dbg_malloc((n + 8)));
        memcpy(d, var, n);
        memcpy(((d) + n), "/argile", 8);
        add_path_free(d, 1);
      } //;
#line 205 "arc.arg"
      if ((*&(s)[0] != 0)) {
#line 464 "../argrt/std.argl"
        (s)++;
      } //;
#line 206 "arc.arg"
      var = s;
    };
  } //;
#line 207 "arc.arg"
  add_path_free("/usr/lib/argile", 0);
  file_path = argile_list_start(file_path);
}

#line 210 "arc.arg"
static void add_path_free(char * path, char opt1)
/** :add path <text path> (- - free): -> nothing **/
{
#line 212 "arc.arg"
  if ((first_path_2 == NULL)) {
#line 464 "../argrt/std.argl"
    first_path_2 = file_path;
  } //;
#line 213 "arc.arg"
  if ((argile_list_search(first_path_2, path, (void *)&argile_streq))) {
    if ((opt1 != 0)) {
      argile_dbg_free(path);
    } //;
  } else {
#line 217 "arc.arg"
    argile_list_append(&file_path, argile_list_new(path, (((opt1 != 0)) ? ((void *)&argile_dbg_free) : (NULL))));
  };
}

#line 219 "arc.arg"
void parse_options(int c, char *(* v))
/** :parse options <int c> <array of (text) v>: -> nothing **/
{
#line 229 "arc.arg"
  struct option(* opts) = (struct option[]){{"max-match-rec", required_argument, NULL, 'a'}, {"add-dir", required_argument, NULL, 'A'}, {"bind-doc", required_argument, NULL, 'b'}, {"double-source-lines", no_argument, NULL, 'B'}, {"max-comp-rec", required_argument, NULL, 'c'}, {"concat", no_argument, NULL, 'C'}, {"dump", no_argument, NULL, 'd'}, {"debug-comp", no_argument, NULL, 'D'}, {"env-help", no_argument, NULL, 'e'}, {"max-gen-rec", required_argument, NULL, 'g'}, {"get-defs", required_argument, NULL, 'G'}, {"help", no_argument, NULL, 'h'}, {"header", required_argument, NULL, 'H'}, {"indent", no_argument, NULL, 'i'}, {"line", required_argument, NULL, 'l'}, {"source-lines", no_argument, NULL, 'L'}, {"module", required_argument, NULL, 'm'}, {"no-main", no_argument, NULL, 'M'}, {"no-color", no_argument, NULL, 'n'}, {"no-auto-use", no_argument, NULL, 'N'}, {"output", required_argument, NULL, 'o'}, {"deps", required_argument, NULL, 'p'}, {"proto-syntax", no_argument, NULL, 'P'}, {"max-rejects", required_argument, NULL, 'r'}, {"show-progress", no_argument, NULL, 'R'}, {"shared-module", required_argument, NULL, 's'}, {"stats", no_argument, NULL, 'S'}, {"col-per-tab", required_argument, NULL, 't'}, {"daltonism", no_argument, NULL, 'T'}, {"utf8", no_argument, NULL, 'u'}, {"use", required_argument, NULL, 'U'}, {"verbose", no_argument, NULL, 'v'}, {"version", no_argument, NULL, 'V'}, {"hexa-string", no_argument, NULL, 'x'}, {NULL, 0, NULL, 0}};
#line 266 "arc.arg"
  char * shorts = "a:A:b:Bc:CdDeg:G:hH:il:Lm:MnNo:p:Pr:Rs:St:TuU:vVx";
  int curopt = 0;
  int opt = 0;
#line 268 "arc.arg"
  int id = 0;

#line 267 "arc.arg"
  curopt = optind;
#line 269 "arc.arg"
  opterr = 0;
#line 274 "arc.arg"
  while (((opt = getopt_long(c, v, shorts, opts, &id)) != -1)) {
    char * oname = (char *)0;
    int i = 0;

#line 277 "arc.arg"
    while (!((((char *)((opts)[i]).name) == NULL))) {
      if ((((opts)[i]).val == opt)) {
        oname = ((char *)((opts)[i]).name);
        break;
      } //;
#line 281 "arc.arg"
      (i)++;
    };
#line 282 "arc.arg"
    if ((oname != NULL)) {
      argile_list_append(&arg_opts, argile_list_new(oname, ((argile_deleter_t)0)));
      argile_list_append(&arg_opts, argile_list_new((((optarg)) ? (optarg) : ("")), ((argile_deleter_t)0)));
    } //;
#line 285 "arc.arg"
    switch (opt) {
      case 'a': {
        check_is_a_number(optarg);
        maxmatch = atoi(optarg);
        check_is_positive(&oname, maxmatch);
      } break;
#line 290 "arc.arg"
      case 'A': {
#line 290 "arc.arg"
        add_path_free(optarg, 0);
      } break;
#line 291 "arc.arg"
      case 'b': {
#line 291 "arc.arg"
        argile_list_append(&mod_docs, argile_list_new(optarg, ((argile_deleter_t)0)));
      } break;
#line 292 "arc.arg"
      case 'B': {
#line 292 "arc.arg"
        genlines = 2;
      } break;
#line 293 "arc.arg"
      case 'c': {
        check_is_a_number(optarg);
        maxcomp = atoi(optarg);
        check_is_positive(&oname, maxcomp);
      } break;
#line 297 "arc.arg"
      case 'C': {
#line 297 "arc.arg"
        concat = 1;
      } break;
#line 298 "arc.arg"
      case 'd': {
#line 298 "arc.arg"
        dump_mode = 1;
      } break;
#line 299 "arc.arg"
      case 'D': {
#line 299 "arc.arg"
        debugcomp = 1;
      } break;
#line 300 "arc.arg"
      case 'e': {
        fprintf(stderr, "Environment variables help:\nARGILE_AUTO_USE      : list of  files separated by ':' (see --use)\nARGILE_COLOR         : 0 or 1 (opposite of --no-color)\nARGILE_COLPERTAB     : integer (see --col-per-tab)\nARGILE_DALTONISM     : 0 or 1 (see --daltonism)\nARGILE_FILE_PATH     : list of pathes separated by ':' (see --add-dir)\nARGILE_HEXASTR       : 0 or 1 (see --hexa-string)\nARGILE_INDENT_STYLE  : 0 or 1 (see --indent)\nARGILE_LINENUMS      : 0, 1 or 2 (see --source-lines and --double-source-lines)\nARGILE_MAXCOMP       : integer (see --max-comp-rec)\nARGILE_MAXGEN        : integer (see --max-gen-rec)\nARGILE_MAXMATCH      : integer (see --max-match-rec)\nARGILE_MAXREJECTS    : integer (see --max-rejects)\nARGILE_OPERATORS     : string of additional operator characters (or ranges)\n                       (ex: \"!#-'*-/<-@[-`|~\" : '-' sign delimits a range;\n                        so  \"<-@\" means from '<' character to '@')\nARGILE_SOM_PATH      : list of pathes to find shared modules, separated by ':'\nARGILE_SO_MODULES    : list of shared modules to load, separated by ':'\nARGILE_UTF8          : 0 or 1 (see --utf8)\nLD_LIBRARY_PATH      : when no ARGILE_FILE_PATH is set, use this path list\n                       instead, and add \"/argile\" to each entry\n\t\t       (same thing for ARGILE_SOM_PATH)\nHOME                 : when no ARGILE_FILE_PATH is set, $HOME/lib/argile is\n                       also added to the file path, as well as \".\" and\n\t\t       /usr/lib/argile\n\t\t       (same thing for ARGILE_SOM_PATH)\n");
#line 328 "arc.arg"
        exit(0);
      } break;
#line 329 "arc.arg"
      case 'g': {
        check_is_a_number(optarg);
        maxgen = atoi(optarg);
        check_is_positive(&oname, maxgen);
      } break;
#line 333 "arc.arg"
      case 'G': {
#line 333 "arc.arg"
        grep = optarg;
      } break;
#line 334 "arc.arg"
      case 'H': {
#line 334 "arc.arg"
        head = optarg;
      } break;
#line 335 "arc.arg"
      case 'i': {
#line 335 "arc.arg"
        dump_indent = 1;
      } break;
#line 336 "arc.arg"
      case 'l': {
#line 336 "arc.arg"
        line = optarg;
      } break;
#line 337 "arc.arg"
      case 'L': {
#line 337 "arc.arg"
        genlines = 1;
      } break;
#line 338 "arc.arg"
      case 'm': {
#line 338 "arc.arg"
        module = optarg;
      } break;
#line 339 "arc.arg"
      case 'M': {
#line 339 "arc.arg"
        do_main = 0;
      } break;
#line 340 "arc.arg"
      case 'n': {
#line 340 "arc.arg"
        nocolors = 1;
      } break;
#line 341 "arc.arg"
      case 'N': {
#line 341 "arc.arg"
        noautouse = 1;
      } break;
#line 342 "arc.arg"
      case 'o': {
#line 342 "arc.arg"
        output = optarg;
      } break;
#line 343 "arc.arg"
      case 'p': {
#line 343 "arc.arg"
        deps = optarg;
      } break;
#line 344 "arc.arg"
      case 'P': {
#line 344 "arc.arg"
        proto_syntax = 1;
      } break;
#line 345 "arc.arg"
      case 'r': {
        check_is_a_number(optarg);
        maxrejt = atoi(optarg);
        check_is_positive(&oname, maxrejt);
      } break;
#line 349 "arc.arg"
      case 'R': {
#line 349 "arc.arg"
        show_progress = 1;
      } break;
#line 350 "arc.arg"
      case 's': {
#line 350 "arc.arg"
        argile_list_append(&so_mods, argile_list_new(optarg, ((argile_deleter_t)0)));
      } break;
#line 351 "arc.arg"
      case 'S': {
#line 351 "arc.arg"
        stats = 1;
      } break;
#line 352 "arc.arg"
      case 't': {
        check_is_a_number(optarg);
        colpertab = atoi(optarg);
        check_is_positive(&oname, colpertab);
      } break;
#line 356 "arc.arg"
      case 'T': {
#line 356 "arc.arg"
        daltonism = 1;
      } break;
#line 357 "arc.arg"
      case 'u': {
#line 357 "arc.arg"
        utf8 = 1;
      } break;
#line 358 "arc.arg"
      case 'U': {
#line 358 "arc.arg"
        argile_list_append(&auto_use, argile_list_new(optarg, ((argile_deleter_t)0)));
      } break;
#line 359 "arc.arg"
      case 'v': {
#line 359 "arc.arg"
        verbose = 1;
      } break;
#line 360 "arc.arg"
      case 'V': {
        printf("%s (Argile Compiler) version %s\n%s\nCopyright (C) 2009,2010 the Argile authors\n(see the AUTHORS file distributed along with this software).\nThis is free software; see the source for copying conditions.  There is NO\nwarranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n\n", "arc", VERSION, argile_get_version());
#line 367 "arc.arg"
        exit(0);
      } break;
#line 368 "arc.arg"
      case 'x': {
#line 368 "arc.arg"
        hexastr = 1;
      } break;
#line 369 "arc.arg"
      case 'h': ;
      case '?': ;
      default: {
        fprintf(stderr, "Usage: %s [options...] [--] [file]\nOptions help:\n-a --max-match-rec <max> : Limit syntax match depth; 0 = no limit (may take ages)\n                           (default is %d)\n-A --add-dir       <dir> : Add directory to file path list\n-b --bind-doc     <name> : Finds documentation of binding (e.g std/print)\n-B --double-source-lines : Generate line numbers of both argile and C sources\n-c --max-comp-rec  <max> : Limit compilation depth; 0 = no limit (may take ages)\n                           (default is %d)\n-C --concat              : Concatenate main codes in main function\n-d --dump                : Dump precompiled code on stdout\n-D --debug-comp          : Dump compilation process\n-e --env-help            : Show the environment variables help\n-g --max-gen-rec   <max> : Limit gencode depth; 0 = no limit (may crash)\n                           (default is %d)\n-G --get-defs   <syntax> : Get definitions matching syntax\n-h --help                : Show this help\n-H --header       <file> : Generate C Header in file\n-i --indent              : Code dumping is indentation-based\n-l --line <string>       : Parse string instead of file or stdin\n-L --source-lines        : Generate source line numbers for C preprocessor\n-m --module       <file> : Generate modularized argile header in file\n-M --no-main             : Generate NO main function\n-n --no-color            : Don't use colors (for errors and dumping)\n-N --no-auto-use         : Disable auto use file list\n-o --output       <file> : Generate C code in file instead of stdout\n-p --deps         <file> : Generate Makefile dependencies in file\n-P --proto-syntax        : Generate syntax comment for functions prototypes\n-r --max-rejects   <max> : Limit reject history; 0 = no limit\n                           (default is %d)\n-R --show-progress       : Show progress percentage during compilation\n-s --shared-module <mod> : Loads mod as a dynamic shared object module\n-S --stats               : Print compilation statistics when dumping\n-t --col-per-tab  <cols> : Set number of columns per tabulation (default = %d)\n-T --daltonism           : Print symbols corresponding to colors (dumping)\n-u --utf8                : Use UTF-8 for column counting and $ARGILE_OPERATORS\n-U --use          <file> : Use file (preload)\n-v --verbose             : Print additional informations\n-V --version             : Show version information and exit\n-x --hexa-string         : Use hexadecimal sequences for non-ascii strings\n", "arc", 500, 1000, 500, 5, 8);
#line 413 "arc.arg"
        if ((opt == '?')) {
          fprintf(stderr, "Bad option '%s'\n", (v)[curopt]);
        } //;
#line 415 "arc.arg"
        if ((opt == 'h')) {
#line 464 "../argrt/std.argl"
          exit(0);
        } //;
#line 416 "arc.arg"
        exit(1);
      } break;
    };
#line 418 "arc.arg"
    curopt = optind;
#line 422 "arc.arg"
  };
#line 434 "arc.arg"
  filename = (v)[optind];
  c = (c - (optind + 1));
  v = v + (optind + 1);
}

#line 438 "arc.arg"
void parse_environ()
/** :parse environ: -> nothing **/
{
#line 439 "arc.arg"
  char * v_2 = "";

#line 440 "arc.arg"
  if ((!(noautouse) && (v_2 = ((char *)getenv("ARGILE_AUTO_USE"))))) {
    split_into_and_rewind(v_2, &auto_use, 0);
  } //;
#line 456 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_COLOR")))) {
#line 456 "arc.arg"
    nocolors = (atoi(v_2) == 0);
  } //;
#line 457 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_COLPERTAB")))) {
#line 457 "arc.arg"
    colpertab = atoi(v_2);
  } //;
#line 458 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_DALTONISM")))) {
#line 458 "arc.arg"
    daltonism = (atoi(v_2) != 0);
  } //;
#line 459 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_FILE_PATH")))) {
#line 459 "arc.arg"
    split_into_and_rewind(v_2, &env_path, 1);
  } //;
#line 460 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_HEXASTR")))) {
#line 460 "arc.arg"
    hexastr = (atoi(v_2) != 0);
  } //;
#line 461 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_INDENT_STYLE")))) {
#line 461 "arc.arg"
    dump_indent = (atoi(v_2) != 0);
  } //;
#line 462 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_LINENUMS")))) {
#line 462 "arc.arg"
    genlines = ((unsigned int)atoi(v_2));
  } //;
#line 463 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_MAXCOMP")))) {
#line 463 "arc.arg"
    maxcomp = atoi(v_2);
  } //;
#line 464 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_MAXGEN")))) {
#line 464 "arc.arg"
    maxgen = atoi(v_2);
  } //;
#line 465 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_MAXMATCH")))) {
#line 465 "arc.arg"
    maxmatch = atoi(v_2);
  } //;
#line 466 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_MAXREJECTS")))) {
#line 466 "arc.arg"
    maxrejt = atoi(v_2);
  } //;
#line 467 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_SOM_PATH")))) {
#line 467 "arc.arg"
    split_into_and_rewind(v_2, &som_path, 1);
  } //;
#line 468 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_SO_MODULES")))) {
#line 468 "arc.arg"
    split_into_and_rewind(v_2, &env_mods, 1);
  } //;
#line 469 "arc.arg"
  if ((v_2 = ((char *)getenv("ARGILE_UTF8")))) {
#line 469 "arc.arg"
    utf8 = (atoi(v_2) != 0);
  } //;
}

#line 471 "arc.arg"
void parse_environ_after_init()
/** :parse environ after init: -> nothing **/
{
#line 472 "arc.arg"
  char * v_2 = "";

#line 472 "arc.arg"
  if (((v_2 = ((char *)getenv("ARGILE_OPERATORS"))))) {
    if (((argile).encoding)) {
      argile_decoder_t charat;
      argile_decoder_t charsize;
      unsigned int v0 = 0;
      int n = 0;

#line 474 "arc.arg"
      charat = ((argile).encoding)->charat;
      charsize = ((argile).encoding)->charsize;
#line 477 "arc.arg"
      n = strlen(v_2);
      while ((v0 = (*charat)(v_2, n))) {
        unsigned int n0 = 0;
        unsigned int n1 = 0;

#line 479 "arc.arg"
        n0 = (*charsize)(v_2, n);
        n1 = (*charsize)(((v_2) + n0), (n - n0));
        if ((n1 > 0)) {
#line 483 "arc.arg"
          unsigned int v1 = 0;

#line 482 "arc.arg"
          n1 += n0;
          v1 = (*charat)(((v_2) + n0), (n - n0));
          if ((v1 == '-')) {
            unsigned int n2 = 0;

#line 485 "arc.arg"
            n2 = (*charsize)(((v_2) + n1), (n - n1));
            if ((n2 > 0)) {
#line 488 "arc.arg"
              unsigned int v2 = 0;

#line 487 "arc.arg"
              n2 += n1;
              v2 = (*charat)(((v_2) + n1), (n - n1));
              if ((v2 != 0)) {
                argile_add_operators(v0, v2);
                v_2 = ((v_2) + n2);
                n -= n2;
                continue;
              } //;
            } //;
          } //;
        } //;
#line 494 "arc.arg"
        argile_add_operators(v0, 0);
        if ((n0 == 0)) {
#line 464 "../argrt/std.argl"
          break;
        } //;
#line 496 "arc.arg"
        v_2 = ((v_2) + n0);
        n -= n0;
      };
    } else {
#line 499 "arc.arg"
      while ((*&(v_2)[0] != 0)) {
        if (((*&(v_2)[1] == '-') && (*&(v_2)[2] != 0))) {
          argile_add_operators(((unsigned int)*&(v_2)[0]), ((unsigned int)*&(v_2)[2]));
          v_2 = ((v_2) + 3);
          continue;
        } //;
#line 504 "arc.arg"
        argile_add_operators(((unsigned int)*&(v_2)[0]), 0);
        (v_2)++;
      };
    };
  } //;
}

#line 507 "arc.arg"
void compile(char * file)
/** :compile <text file>: -> nothing **/
{
#line 508 "arc.arg"
  vmessage("loading `std' shared object module");
  if ((argile_loadmod("std") == NULL)) {
    fprintf(stderr, "%s: std module error: %s\n", "arc", ((((argile).error == NULL)) ? ("") : ((argile).error)));
    return;
  } //;
  if ((so_mods)) {
#line 515 "arc.arg"
    argile_list_t * lm;

#line 514 "arc.arg"
    vmessage("loading additional shared object modules");
    for (lm = so_mods; (lm); lm = ((argile_list_t *)lm)->next) {
      if ((argile_loadmod(*((char * *)&((argile_list_t *)lm)->data)) == NULL)) {
        fprintf(stderr, "%s: module error: %s\n", "arc", ((((argile).error == NULL)) ? ("") : ((argile).error)));
        return;
      } //;
    };
  } //;
#line 520 "arc.arg"
  if ((mod_docs)) {
#line 546 "arc.arg"
    argile_list_t * ld;

#line 521 "arc.arg"
    vmessage("fetching embedded documentation");
#line 546 "arc.arg"
    for (ld = mod_docs; (ld); ld = ((argile_list_t *)ld)->next) {
      char * name = "";
      char * slash = "";

#line 547 "arc.arg"
      name = *((char * *)&((argile_list_t *)ld)->data);
      slash = strchr(name, '/');
      if ((slash != NULL)) {
#line 551 "arc.arg"
        argile_module_t * mod = ((argile_module_t *)0);

#line 550 "arc.arg"
        *&((slash)++)[0] = ((char)0);
        mod = argile_getmod(name);
        if ((mod == NULL)) {
          fprintf(stderr, "%s: %s: module not loaded\n", "arc", name);
          continue;
        } //;
#line 555 "arc.arg"
        if ((*&(slash)[0] == '*')) {
          argile_list_t * lb;

#line 556 "arc.arg"
          for (lb = (mod)->binds; (lb); lb = ((argile_list_t *)lb)->next) {
            print_bind_doc(mod, *((argile_bind_t * *)&((argile_list_t *)lb)->data));
          };
        } else {
#line 559 "arc.arg"
          argile_bind_t * bnd = ((argile_bind_t *)0);

#line 559 "arc.arg"
          bnd = argile_module_getbind(mod, slash);
          if ((bnd == NULL)) {
            fprintf(stderr, "%s: %s: bind not found in %s\n", "arc", slash, name);
            continue;
          } //;
#line 563 "arc.arg"
          print_bind_doc(mod, bnd);
        };
      } else {
#line 565 "arc.arg"
        argile_list_t * lm;

#line 565 "arc.arg"
        for (lm = (argile).mods; (lm); lm = ((argile_list_t *)lm)->next) {
          argile_module_t * mod = ((argile_module_t *)0);
          argile_bind_t * bnd = ((argile_bind_t *)0);

#line 566 "arc.arg"
          mod = *((argile_module_t * *)&((argile_list_t *)lm)->data);
          bnd = argile_module_getbind(mod, name);
          if ((bnd != NULL)) {
            print_bind_doc(mod, bnd);
          } //;
        };
      };
    };
#line 570 "arc.arg"
    print_bind_doc(((argile_module_t *)0), ((argile_bind_t *)0));
    printf("==========================\n");
    return;
  } //;
  vmessage("making implicit bindings");
  if (make_implicit_binds()) {
    fprintf(stderr, "%s: implicit bindings error: %s\n", "arc", ((((argile).error == NULL)) ? ("") : ((argile).error)));
    return;
  } //;
#line 617 "arc.arg"
  (argile).deps_only = (((((deps) && !((grep))) && !((output))) && !((head))) && !((module)));
  (argile).main_only = (((((grep) && !((deps))) && !((output))) && !((head))) && !((module)));
#line 620 "arc.arg"
  if (!(noautouse)) {
    argile_list_t * lu;

#line 621 "arc.arg"
    for (lu = auto_use; (lu); lu = ((argile_list_t *)lu)->next) {
      char * au = "";
#line 624 "arc.arg"
      argile_file_t * fp = ((argile_file_t *)0);

#line 622 "arc.arg"
      au = *((char * *)&((argile_list_t *)lu)->data);
      vmessage("preloading argile file %s", au);
      fp = argile_loadfile(au);
      if ((fp == NULL)) {
        fprintf(stderr, "%s: %s\n", "arc", ((((argile).error == NULL)) ? ("") : ((argile).error)));
        return;
      } //;
#line 628 "arc.arg"
      if (((argile).main == NULL)) {
        (argile).main = argile_code_new(((argile_code_t *)0), ((argile_list_t *)0));
      } //;
#line 630 "arc.arg"
      argile_code_include((argile).main, (fp)->code, 0);
    };
  } //;
#line 632 "arc.arg"
  if ((line)) {
    vmessage("parsing string");
    (argile).input = (void *)&argile_input_string;
    (argile).input_name = "command line";
    if ((argile_parse(&line) != 0)) {
      fprintf(stderr, "%s: parse error: %s\n", "arc", ((((argile).error == NULL)) ? ("") : ((argile).error)));
      return;
    } //;
  } else if ((file)) {
#line 646 "arc.arg"
    argile_file_t * f = ((argile_file_t *)0);

#line 640 "arc.arg"
    vmessage("parsing %s", file);
    (argile).input = (void *)&argile_input_path;
    (argile).input_name = file;
    if ((argile_parse(file) != 0)) {
      fprintf(stderr, "%s: parse error: %s\n", "arc", ((((argile).error == NULL)) ? ("") : ((argile).error)));
      return;
    } //;
#line 646 "arc.arg"
    f = argile_file_new(file, ((struct stat*)0));
    if (((f)->error != 0)) {
      argile_file_del(f);
    } else {
      (f)->code = (argile).main;
      argile_addfile(f);
      (argile).main_file = f;
    };
  } else {
#line 657 "arc.arg"
    int fd = 0;

#line 654 "arc.arg"
    vmessage("parsing standard input");
    (argile).input = (void *)&argile_input_fd;
    (argile).input_name = "standard input";
#line 658 "arc.arg"
    if ((argile_parse(&fd) != 0)) {
      fprintf(stderr, "%s: parse error: %s\n", "arc", ((((argile).error == NULL)) ? ("") : ((argile).error)));
      return;
    } //;
  };
#line 662 "arc.arg"
  vmessage("compiling");
  argile_compile();
#line 665 "arc.arg"
  if (dump_mode) {
#line 667 "arc.arg"
    argile_buff_t code = ((argile_buff_t){0});

#line 666 "arc.arg"
    vmessage("dumping");
#line 668 "arc.arg"
    argile_code_string((argile).main, 0, &code);
    argile_buff_putc(&code, '\0');
    printf("%s", (code).ptr);
    argile_dbg_free((code).ptr);
  } //;
  if ((grep)) {
    vmessage("searching syntax \"%s\"", grep);
    argile_search_defs(grep, (void *)&argile_def_2);
  } //;
#line 693 "arc.arg"
  if (((!(dump_mode) && !((grep))) && !(((argile).error)))) {
    if (do_main) {
      argile_add_keyword("main");
    } //;
#line 696 "arc.arg"
    if ((output)) {
#line 698 "arc.arg"
      FILE * f;

#line 697 "arc.arg"
      vmessage("generating C code");
      if (!(((f = fopen(output, "w"))))) {
        fprintf(stderr, "%s: %s: %m\n", "arc", output);
      } //;
#line 700 "arc.arg"
      else {
        fprintf(f, "//");
        print_command_line_in(f);
        fprintf(f, "\n");
        (argile).output = (void *)&argile_output_file;
        (argile).output_data = f;
        (argile).output_name = output;
        (argile).output_line = 1;
        argile_gencode(head);
        (argile).output_data = NULL;
        fclose(f);
      };
    } //;
#line 711 "arc.arg"
    else if (((!((module)) && !((deps))) && !((head)))) {
      vmessage("generating C code");
      argile_gencode((char *)0);
    } //;
#line 714 "arc.arg"
    if ((head)) {
#line 716 "arc.arg"
      FILE * f;

#line 715 "arc.arg"
      vmessage("generating C header");
      if (!(((f = fopen(head, "w"))))) {
        fprintf(stderr, "%s: %s: %m\n", "arc", head);
      } else {
        fprintf(f, "//");
        print_command_line_in(f);
        fprintf(f, "\n");
        (argile).output = (void *)&argile_output_file;
        (argile).output_data = f;
        (argile).output_name = head;
        (argile).output_line = 1;
        argile_gen_header(head);
        (argile).output_data = NULL;
        fclose(f);
      };
    } //;
#line 729 "arc.arg"
    if ((deps)) {
#line 731 "arc.arg"
      FILE * f;

#line 730 "arc.arg"
      vmessage("generating dependencies");
      if (((f = fopen(deps, "w")))) {
        int elen = 0;
#line 737 "arc.arg"
        argile_list_t * lf;

#line 732 "arc.arg"
        elen = strlen(".argl");
        if ((output)) {
#line 733 "arc.arg"
          fprintf(f, "%s ", output);
        } //;
#line 734 "arc.arg"
        if ((head)) {
#line 734 "arc.arg"
          fprintf(f, "%s ", head);
        } //;
#line 735 "arc.arg"
        if ((module)) {
#line 735 "arc.arg"
          fprintf(f, "%s ", module);
        } //;
#line 736 "arc.arg"
        fprintf(f, ":");
        lf = (argile).used;
        for (; (lf); lf = ((argile_list_t *)lf)->next) {
          argile_file_t * af = ((argile_file_t *)0);
          int plen = 0;

#line 739 "arc.arg"
          af = *((argile_file_t * *)&((argile_list_t *)lf)->data);
          plen = strlen((af)->path);
          if (((af)->derived && has_ext((af)->path, plen, ".argl", elen))) {
            fprintf(f, " ");
            fwrite((af)->path, (plen - elen), 1, f);
            fprintf(f, ".arg");
          } else {
            fprintf(f, " %s", (af)->path);
          };
#line 747 "arc.arg"
        };
#line 750 "arc.arg"
        fprintf(f, "\n");
        fclose(f);
      } else {
        fprintf(stderr, "%s: %s: %m\n", "arc", deps);
      };
    } //;
#line 754 "arc.arg"
    if ((module)) {
#line 756 "arc.arg"
      FILE * f;

#line 755 "arc.arg"
      vmessage("modularizing");
      if (((f = fopen(module, "w")))) {
        fprintf(f, "(:");
        print_command_line_in(f);
        fprintf(f, ":)\n");
        argile_gen_module(f);
        fclose(f);
      } else {
        fprintf(stderr, "%s: %s: %m\n", "arc", module);
      };
    } //;
  } //;
#line 771 "arc.arg"
  if (show_progress) {
    fprintf(stderr, "\n");
  } //;
  if (stats) {
    vmessage("reporting statistics");
#line 778 "arc.arg"
    printf("%s%u%s%u\n", "   - Variables.............. ", (&(argile).stat)->vars, " / ", (&(argile).gstat)->vars);
    printf("%s%u%s%u\n", "   - Parameters_____________ ", (&(argile).stat)->params, " / ", (&(argile).gstat)->params);
    printf("%s%u%s%u\n", "   - Functions.............. ", (&(argile).stat)->funcs, " / ", (&(argile).gstat)->funcs);
    printf("%s%u%s%u\n", "   - Macros_________________ ", (&(argile).stat)->macros, " / ", (&(argile).gstat)->macros);
    printf("%s%u%s%u\n", "   - Bindings............... ", (&(argile).stat)->binds, " / ", (&(argile).gstat)->binds);
    printf("%s%u%s%u\n", "   - # :match_eq:___________ ", (&(argile).stat)->num_match_eq, " / ", (&(argile).gstat)->num_match_eq);
    printf("%s%u%s%u\n", "   - # :match_try:.......... ", (&(argile).stat)->num_match_try, " / ", (&(argile).gstat)->num_match_try);
    printf("%s%u%s%u\n", "   - # :call_compile_as:____ ", (&(argile).stat)->num_call_compile_as, " / ", (&(argile).gstat)->num_call_compile_as);
    printf("%s%u%s%u%s%u%s%u\n", "   - Rejections bytes....... ", (&(argile).stat)->rejsize, "/", (&(argile).stat)->rejmaxsize, " / ", (&(argile).gstat)->rejsize, "/", (&(argile).gstat)->rejmaxsize);
    printf("%s%u%s%u\n", "   - DefCounterFilter cells_ ", ((argile).stat).hitsize, " / ", ((argile).gstat).hitsize);
    printf("%s%u\n", "   - DefCounterFilter count. ", (argile).last_hit);
    printf("%s%i\n", "   - Types__________________ ", (argile).next_type);
    printf("%s%i\n", "   - Files used............. ", argile_list_count((argile).used));
    printf("%s%i\n", "   - Allocated (brk) bytes__ ", ((int)(sbrk(0)-firstbrk)));
    printf("%s%u\n", "   - # :malloc:............. ", argile_dbg_mallocs);
  } //;
  if (((argile).error)) {
    if (((argile).killer)) {
#line 797 "arc.arg"
      int count = 0;

#line 796 "arc.arg"
      vmessage("showing rejection(s)");
      count = print_rejects((argile).killer, 0);
      if ((count != 0)) {
        fprintf(stderr, "%d rejection%s\n", count, (((count > 1)) ? ("s") : ("")));
      } //;
#line 800 "arc.arg"
    } //;
#line 810 "arc.arg"
    vmessage("reporting error");
    fprintf(stderr, "%s: compilation error: %s\n", "arc", (argile).error);
    if (!(dump_mode)) {
      fprintf(stderr, "  (to get context of error use --dump option;");
      fprintf(stderr, " add parenthesis to get rejections)\n");
    } //;
#line 815 "arc.arg"
    return;
  } //;
}

#line 172 "arc.arg"
static void add_som_path_free(char * path_2, char opt1)
/** :add som path <text path> (- - free): -> nothing **/
{
#line 174 "arc.arg"
  if ((first_path == NULL)) {
#line 464 "../argrt/std.argl"
    first_path = som_path;
  } //;
#line 175 "arc.arg"
  if ((argile_list_search(first_path, path_2, (void *)&argile_streq))) {
    if ((opt1 != 0)) {
      argile_dbg_free(path_2);
    } //;
  } //;
#line 178 "arc.arg"
  else {
    argile_list_append(&som_path, argile_list_new(path_2, (((opt1 != 0)) ? ((void *)&argile_dbg_free) : (NULL))));
  };
}

#line 419 "arc.arg"
static void check_is_positive(char * * oname, int i_2)
/** :check <int i> is positive: -> nothing **/
{
#line 420 "arc.arg"
  if ((i_2 < 0)) {
    {
#line 595 "../argrt/std.argl"
      fprintf(stderr, "negative number is invalid for this option (--%s)\n", *oname);
      exit(1);
    };
  } //;
}

#line 422 "arc.arg"
static void check_is_a_number(char * t)
/** :check <text t> is a number: -> nothing **/
{
#line 423 "arc.arg"
  char * s = "";

#line 423 "arc.arg"
  s = t;
  if ((*&(s)[0] == '-')) {
    (s)++;
  } //;
#line 426 "arc.arg"
  if ((*&(s)[0] != 0)) {
    do {
      if (((*&(s)[0] < '0') || (*&(s)[0] > '9'))) {
#line 464 "../argrt/std.argl"
        break;
      } //;
#line 429 "arc.arg"
      (s)++;
    } while ((*&(s)[0] != 0));
    if ((*&(s)[0] == 0)) {
#line 464 "../argrt/std.argl"
      return;
    } //;
  } //;
#line 432 "arc.arg"
  {
#line 595 "../argrt/std.argl"
    fprintf(stderr, "'%s' is not an integer number\n", t);
    exit(1);
  };
}

#line 442 "arc.arg"
static void split_into_and_rewind(char * v_3, argile_list_t * * tail, char opt1)
/** :split <text v> into <(list) & tail> (and rewind): -> nothing **/
{
#line 443 "arc.arg"
  while ((*&(v_3)[0] != 0)) {
    char * d = "";

#line 444 "arc.arg"
    d = v_3;
    while (((*&(v_3)[0] != 0) && (*&(v_3)[0] != *&(":")[0]))) {
#line 481 "../argrt/std.argl"
      (v_3)++;
    };
#line 446 "arc.arg"
    if ((d != v_3)) {
      argile_list_append(tail, argile_list_new(mystrndup(d, ((v_3) - d)), (void *)&argile_dbg_free));
    } //;
#line 448 "arc.arg"
    if ((*&(v_3)[0])) {
#line 464 "../argrt/std.argl"
      (v_3)++;
    } //;
  };
#line 454 "arc.arg"
  if ((opt1 != 0)) {
#line 464 "../argrt/std.argl"
    *tail = argile_list_start(*tail);
  } //;
}

#line 449 "arc.arg"
static char * mystrndup(char * t_2, int size)
/** :mystrndup <text t> <int size>: -> text **/
{
#line 450 "arc.arg"
  char * cpy = "";

#line 450 "arc.arg"
  cpy = ((char *)argile_dbg_malloc((size + 1)));
  memcpy(cpy, t_2, size);
  *&(cpy)[size] = ((char)0);
  return cpy;
}

#line 578 "arc.arg"
static unsigned char make_implicit_binds()
/** :make implicit binds: -> bool **/
{
#line 579 "arc.arg"
  argile_deftype(((char *)":word:"), (argile_type_t)ARGILE_TYPE_WORD);
  argile_deftype(((char *)":text:"), (argile_type_t)ARGILE_TYPE_TEXT);
  argile_deftype(((char *)":syntax:"), (argile_type_t)ARGILE_TYPE_SYNTAX);
#line 583 "arc.arg"
  argile_bind(((char *)":use [{<word> | <text>} , ...] {<word> | <text>}:"), ((char *)"std"), ((char *)"use"));
  argile_bind(((char *)":bind <syntax> to <word module> / <word bind>:"), ((char *)"std"), ((char *)"bind"));
#line 587 "arc.arg"
  {
    argile_list_t * ld;
#line 588 "arc.arg"
    argile_list_t * next;
    int i = 0;

#line 590 "arc.arg"
    for (i = 0; (i < 4096); (i)++) {
      for (ld = ((argile).defs)[i]; (ld); ld = next) {
        argile_def_t * d = ((argile_def_t *)0);

#line 592 "arc.arg"
        d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
        next = ((argile_list_t *)ld)->next;
        if ((((d)->dtype == ARGILE_DEF_TYPE) && ((d)->type == ARGILE_TYPE_TYPE))) {
          argile_list_link(((argile_list_t *)ld)->prev, ((argile_list_t *)ld)->next);
          if ((((argile_list_t *)ld)->prev == NULL)) {
            *&((argile).defs)[i] = ((argile_list_t *)ld)->next;
          } //;
#line 598 "arc.arg"
          ((argile_list_t *)ld)->prev = ((argile_list_t *)0);
#line 598 "arc.arg"
          ((argile_list_t *)ld)->next = ((argile_list_t *)0);
          argile_list_del(ld);
          (((argile).stat).hitsize)--;
        } //;
      };
    };
#line 601 "arc.arg"
    for (ld = ((argile).main)->defs; (ld); ld = next) {
      argile_def_t * d = ((argile_def_t *)0);

#line 602 "arc.arg"
      d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
      next = ((argile_list_t *)ld)->next;
      if ((((d)->dtype == ARGILE_DEF_TYPE) && ((d)->type == ARGILE_TYPE_TYPE))) {
#line 606 "arc.arg"
        argile_list_link(((argile_list_t *)ld)->prev, ((argile_list_t *)ld)->next);
        if ((((argile_list_t *)ld)->prev == NULL)) {
          ((argile).main)->defs = ((argile_list_t *)((argile_list_t *)ld)->next);
        } //;
#line 609 "arc.arg"
        ((argile_list_t *)ld)->prev = ((argile_list_t *)0);
#line 609 "arc.arg"
        ((argile_list_t *)ld)->next = ((argile_list_t *)0);
        argile_list_del(ld);
      } //;
    };
  };
#line 612 "arc.arg"
  argile_implicitize();
#line 614 "arc.arg"
  return ((argile).error != NULL);
}

#line 765 "arc.arg"
static void print_command_line_in(FILE * f)
/** :print command line in <FILE f>: -> nothing **/
{
#line 767 "arc.arg"
  int i = 0;

#line 766 "arc.arg"
  fprintf(f, " generated by: arc ");
  for (i = 1; ((i <= (global_argc - 1))); (i)++) {
    fprintf(f, "%s ", (global_argv)[i]);
  };
}

#line 522 "arc.arg"
static void print_bind_doc(argile_module_t * mod, argile_bind_t * bnd)
/** :print bind doc <module mod> <bind bnd>: -> nothing **/
{
#line 541 "arc.arg"
  modbind_t * mb = ((modbind_t *)0);

#line 525 "arc.arg"
  if ((mod == NULL)) {
#line 531 "arc.arg"
    argile_list_t * cur;

#line 526 "arc.arg"
    argile_list_sort(binds, (void *)&bindcmp);
#line 531 "arc.arg"
    for (cur = binds; (cur); cur = ((argile_list_t *)cur)->next) {
      mod = (*((modbind_t * *)&((argile_list_t *)cur)->data))->module;
      bnd = (*((modbind_t * *)&((argile_list_t *)cur)->data))->bind;
      printf("%s\n", "==========================");
      printf("%s%s%s%s\n", (mod)->name, "/", (bnd)->name, " :");
      printf("%s\n", "==========================");
      if (!(((bnd)->doc == NULL))) {
#line 464 "../argrt/std.argl"
        printf("%s\n", (bnd)->doc);
      } //;
    };
#line 538 "arc.arg"
    argile_list_del(binds);
    binds = ((argile_list_t *)0);
    return;
  } //;
#line 541 "arc.arg"
  mb = ((modbind_t *)memset(argile_dbg_malloc(sizeof(modbind_t)), 0, sizeof(modbind_t)));
  (mb)->module = mod;
  (mb)->bind = bnd;
  argile_list_prepend(&binds, argile_list_new(mb, (void *)&argile_dbg_free));
}

#line 527 "arc.arg"
static int bindcmp(modbind_t * a, modbind_t * b)
/** :bindcmp <modbind a> <modbind b>: -> int **/
{
#line 528 "arc.arg"
  int cmp = 0;

#line 528 "arc.arg"
  cmp = (-strcmp(((a)->module)->name, ((b)->module)->name));
  if ((cmp != 0)) {
#line 464 "../argrt/std.argl"
    return cmp;
  } //;
#line 530 "arc.arg"
  return (-strcmp(((a)->bind)->name, ((b)->bind)->name));
}

#line 675 "arc.arg"
static void argile_def_2(argile_def_t * p_argile_def)
/** :<def>: -> nothing **/
{
#line 677 "arc.arg"
  char * input = "";
#line 679 "arc.arg"
  char * category = "";
  argile_buff_t buf = ((argile_buff_t){0});

#line 676 "arc.arg"
  if (((p_argile_def)->locall || (p_argile_def)->implicit)) {
#line 464 "../argrt/std.argl"
    return;
  } //;
#line 677 "arc.arg"
  input = ((p_argile_def)->scope)->input;
  if ((input == NULL)) {
#line 464 "../argrt/std.argl"
    input = "<none>";
  } //;
#line 679 "arc.arg"
  category = ((((p_argile_def)->scope == (argile).main)) ? ("main") : ("sub "));
#line 681 "arc.arg"
  argile_syntax_string((p_argile_def)->syntax, &buf);
  argile_buff_putc(&buf, '\0');
  printf("%s (", input);
  if (!(((p_argile_def)->maker == NULL))) {
    printf("line %d, ", ((((p_argile_def)->maker)->loc).start).row);
  } //;
#line 686 "arc.arg"
  printf("%s) :%s", category, (buf).ptr);
  argile_buff_flush(&buf);
  argile_typename((p_argile_def)->type, &buf, (p_argile_def)->scope);
  argile_buff_putc(&buf, '\0');
  printf(": -> :%s:\n", (buf).ptr);
  argile_dbg_free((buf).ptr);
}

#line 747 "arc.arg"
static unsigned char has_ext(char * file_2, int fs, char * ext, int es)
/** :<text file> <int fs> has ext <text ext> <int es>: -> bool **/
{
#line 748 "arc.arg"
  if ((fs < es)) {
#line 464 "../argrt/std.argl"
    return 0;
  } //;
#line 749 "arc.arg"
  return (strcmp(ext, ((file_2) + (fs - es))) == 0);
}

#line 800 "arc.arg"
static int print_rejects(argile_call_t * p_argile_call, int count_2)
/** :print rejects <call> <int count>: -> int **/
{
#line 801 "arc.arg"
  argile_list_t * reject;
#line 804 "arc.arg"
  argile_list_t * lm;

#line 801 "arc.arg"
  reject = (p_argile_call)->rejects;
  for (; (reject); reject = ((argile_list_t *)reject)->next) {
    fprintf(stderr, "\n[%d] %s\n", ++(count_2), *((char * *)&((argile_list_t *)reject)->data));
  };
#line 804 "arc.arg"
  lm = (p_argile_call)->match;
  for (; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

#line 806 "arc.arg"
    m = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
      count_2 = print_rejects(((m)->value).call, count_2);
    } //;
  };
#line 809 "arc.arg"
  return count_2;
}

int main(int argc, char **argv)
{
#line 42 "arc.arg"
  nocolors = 0;
  noautouse = 0;
  dump_mode = 0;
  dump_indent = 0;
  verbose = 0;
  do_main = 1;
  concat = 0;
  stats = 0;
  debugcomp = 0;
#line 52 "arc.arg"
  daltonism = 0;
  utf8 = 0;
  hexastr = 0;
  proto_syntax = 0;
  show_progress = 0;
#line 67 "arc.arg"
  firstbrk = sbrk(0);
  parse_environ();
  parse_options(argc, argv);
  global_argv = argv;
  global_argc = argc;
#line 73 "arc.arg"
  if (verbose) {
#line 75 "arc.arg"
    fprintf(stderr, "%s %s %s\n", "arc", "(Argile Compiler) version", VERSION);
    fprintf(stderr, "%s\n", argile_get_version());
  } //;
  vmessage("initializing context");
  if ((argile_init() != 0)) {
    {
#line 595 "../argrt/std.argl"
      fprintf(stderr, "%s: init error: %s\n", "libargile", ((((argile).error == NULL)) ? ("") : ((argile).error)));
      exit(1);
    };
  } //;
#line 81 "arc.arg"
  parse_environ_after_init();
#line 84 "arc.arg"
  if ((maxmatch >= 0)) {
#line 464 "../argrt/std.argl"
    (argile).maxmatch = maxmatch;
  } //;
#line 85 "arc.arg"
  if ((maxcomp >= 0)) {
#line 464 "../argrt/std.argl"
    (argile).maxcomp = maxcomp;
  } //;
#line 86 "arc.arg"
  if ((maxgen >= 0)) {
#line 464 "../argrt/std.argl"
    (argile).maxgen = maxgen;
  } //;
#line 87 "arc.arg"
  if ((maxrejt >= 0)) {
#line 464 "../argrt/std.argl"
    (argile).maxreject = maxrejt;
  } //;
#line 88 "arc.arg"
  if ((colpertab > 0)) {
#line 464 "../argrt/std.argl"
    (argile).colpertab = ((unsigned int)colpertab);
  } //;
#line 89 "arc.arg"
  (argile).verbose = verbose;
  (argile).stats = stats;
  (argile).debugcomp = debugcomp;
  (argile).do_main = do_main;
  if ((concat && !(do_main))) {
    fprintf(stderr, "%s: warning: --no-main(-M) disables --concat(-C)\n", "arc");
  } //;
#line 95 "arc.arg"
  else {
    (argile).cat_main = concat;
  };
#line 97 "arc.arg"
  (argile).use_colors = !(nocolors);
  (argile).daltonism = daltonism;
  (argile).dump_indent = dump_indent;
  (argile).gen_lines = genlines;
  (argile).hexa_str = hexastr;
  (argile).proto_syntax = proto_syntax;
  (argile).progress = show_progress;
  if (!(concat)) {
    (argile).lazy = 1;
  } //;
#line 106 "arc.arg"
  if (utf8) {
    (argile).encoding = &(argile).enc_utf8;
  } //;
#line 108 "arc.arg"
  complete_file_path();
  (argile).file_path = file_path;
  complete_som_path();
  (argile).som_path = som_path;
  (argile).options = argile_list_start(arg_opts);
  auto_use = argile_list_start(auto_use);
  if ((env_mods)) {
    argile_list_link(so_mods, env_mods);
    if ((so_mods == NULL)) {
      so_mods = env_mods;
    } //;
  } //;
#line 118 "arc.arg"
  so_mods = argile_list_start(so_mods);
  mod_docs = argile_list_start(mod_docs);
  compile(filename);
  argile_list_del(auto_use);
  argile_list_del(so_mods);
  argile_list_del(mod_docs);
#line 125 "arc.arg"
  errorCode = ((((argile).error == NULL)) ? (0) : (1));
#line 127 "arc.arg"
  vmessage("uninitializing context");
  argile_uninit();
#line 130 "arc.arg"
  if ((argile_dbg_mallocs != argile_dbg_frees)) {
    if (!(nocolors)) {
#line 131 "arc.arg"
      fprintf(stderr, "%s", "[01;31m");
    } //;
#line 132 "arc.arg"
    fprintf(stderr, "%s: %d mallocs , %d frees\n", "arc", argile_dbg_mallocs, argile_dbg_frees);
    if (!(nocolors)) {
#line 133 "arc.arg"
      fprintf(stderr, "%s", "[0m");
    } //;
  } //;
#line 134 "arc.arg"
  if (verbose) {
    fprintf(stderr, " * Done.\n");
  } //;
#line 136 "arc.arg"
  return errorCode;
#line 820 "arc.arg"
  return 0;
}
