#!/usr/bin/awk -f

# rgb2c - Convert rgb.txt into C-code
#
# Copyright (c) 2009,2012 Andreas K. Foerster
# Copying and distribution of this file, with or without modification,
# are permitted in any medium without royalty provided the copyright
# notice and this notice are preserved.  This file is offered as-is,
# without any warranty.

BEGIN	{ if (name == "") name = "palette"
	  if (default_color == "") default_color = "0x000000"
	  # must be a string

	  print "/* automatically generated by rgb2c */"
	  print ""
	  print "#ifndef RGB_H"
	  print "#define RGB_H"
	  print ""
	  print "#define DEFAULT_COLOR " default_color
	  print ""
	  print "static const struct { int number; const char *name; }"
	  print name "[] = {"
	  printf "  {DEFAULT_COLOR, \"default\"}"
	}

/^!/	{ next }

NF < 4	{ next }

	{ print ","
	  printf "  {0x%02X%02X%02X, \"", $1, $2, $3
	  for (i = 4; i <= NF; i++)
	    if (i < NF) printf "%s ", $i
	           else printf "%s\"}", $i
	}

END	{ print "\n};"
	  print "\n#endif /* RGB_H */"
	}
