/*
 * Codepage 850 support for AKFAvatar
 * Copyright (c) 2013 Andreas K. Foerster <info@akfoerster.de>
 *
 * This file is part of AKFAvatar
 *
 * AKFAvatar is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * AKFAvatar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "avtaddons.h"

static const struct avt_char_map map = {
  .start = 0x7F,.end = 0xFF,
  .table = {
	    0x2302,		// 0x7F
	    0x00C7,		// 0x80
	    0x00FC,		// 0x81
	    0x00E9,		// 0x82
	    0x00E2,		// 0x83
	    0x00E4,		// 0x84
	    0x00E0,		// 0x85
	    0x00E5,		// 0x86
	    0x00E7,		// 0x87
	    0x00EA,		// 0x88
	    0x00EB,		// 0x89
	    0x00E8,		// 0x8A
	    0x00EF,		// 0x8B
	    0x00EE,		// 0x8C
	    0x00EC,		// 0x8D
	    0x00C4,		// 0x8E
	    0x00C5,		// 0x8F
	    0x00C9,		// 0x90
	    0x00E6,		// 0x91
	    0x00C6,		// 0x92
	    0x00F4,		// 0x93
	    0x00F6,		// 0x94
	    0x00F2,		// 0x95
	    0x00FB,		// 0x96
	    0x00F9,		// 0x97
	    0x00FF,		// 0x98
	    0x00D6,		// 0x99
	    0x00DC,		// 0x9A
	    0x00F8,		// 0x9B
	    0x00A3,		// 0x9C
	    0x00D8,		// 0x9D
	    0x00D7,		// 0x9E
	    0x0192,		// 0x9F
	    0x00E1,		// 0xA0
	    0x00ED,		// 0xA1
	    0x00F3,		// 0xA2
	    0x00FA,		// 0xA3
	    0x00F1,		// 0xA4
	    0x00D1,		// 0xA5
	    0x00AA,		// 0xA6
	    0x00BA,		// 0xA7
	    0x00BF,		// 0xA8
	    0x00AE,		// 0xA9
	    0x00AC,		// 0xAA
	    0x00BD,		// 0xAB
	    0x00BC,		// 0xAC
	    0x00A1,		// 0xAD
	    0x00AB,		// 0xAE
	    0x00BB,		// 0xAF
	    0x2591,		// 0xB0
	    0x2592,		// 0xB1
	    0x2593,		// 0xB2
	    0x2502,		// 0xB3
	    0x2524,		// 0xB4
	    0x00C1,		// 0xB5
	    0x00C2,		// 0xB6
	    0x00C0,		// 0xB7
	    0x00A9,		// 0xB8
	    0x2563,		// 0xB9
	    0x2551,		// 0xBA
	    0x2557,		// 0xBB
	    0x255D,		// 0xBC
	    0x00A2,		// 0xBD
	    0x00A5,		// 0xBE
	    0x2510,		// 0xBF
	    0x2514,		// 0xC0
	    0x2534,		// 0xC1
	    0x252C,		// 0xC2
	    0x251C,		// 0xC3
	    0x2500,		// 0xC4
	    0x253C,		// 0xC5
	    0x00E3,		// 0xC6
	    0x00C3,		// 0xC7
	    0x255A,		// 0xC8
	    0x2554,		// 0xC9
	    0x2569,		// 0xCA
	    0x2566,		// 0xCB
	    0x2560,		// 0xCC
	    0x2550,		// 0xCD
	    0x256C,		// 0xCE
	    0x00A4,		// 0xCF
	    0x00F0,		// 0xD0
	    0x00D0,		// 0xD1
	    0x00CA,		// 0xD2
	    0x00CB,		// 0xD3
	    0x00C8,		// 0xD4
	    0x0131,		// 0xD5
	    0x00CD,		// 0xD6
	    0x00CE,		// 0xD7
	    0x00CF,		// 0xD8
	    0x2518,		// 0xD9
	    0x250C,		// 0xDA
	    0x2588,		// 0xDB
	    0x2584,		// 0xDC
	    0x00A6,		// 0xDD
	    0x00CC,		// 0xDE
	    0x2580,		// 0xDF
	    0x00D3,		// 0xE0
	    0x00DF,		// 0xE1
	    0x00D4,		// 0xE2
	    0x00D2,		// 0xE3
	    0x00F5,		// 0xE4
	    0x00D5,		// 0xE5
	    0x00B5,		// 0xE6
	    0x00FE,		// 0xE7
	    0x00DE,		// 0xE8
	    0x00DA,		// 0xE9
	    0x00DB,		// 0xEA
	    0x00D9,		// 0xEB
	    0x00FD,		// 0xEC
	    0x00DD,		// 0xED
	    0x00AF,		// 0xEE
	    0x00B4,		// 0xEF
	    0x00AD,		// 0xF0
	    0x00B1,		// 0xF1
	    0x2017,		// 0xF2
	    0x00BE,		// 0xF3
	    0x00B6,		// 0xF4
	    0x00A7,		// 0xF5
	    0x00F7,		// 0xF6
	    0x00B8,		// 0xF7
	    0x00B0,		// 0xF8
	    0x00A8,		// 0xF9
	    0x00B7,		// 0xFA
	    0x00B9,		// 0xFB
	    0x00B3,		// 0xFC
	    0x00B2,		// 0xFD
	    0x25A0,		// 0xFE
	    0x00A0		// 0xFF
	    }
};


static const struct avt_charenc converter = {
  .data = (void *) &map,
  .decode = map_to_unicode,
  .encode = map_from_unicode
};


extern const struct avt_charenc *
avt_cp850 (void)
{
  return &converter;
}
