/*
 * ISO-8859-5 (Cyrillic) support for AKFAvatar
 * Copyright (c) 2013 Andreas K. Foerster <info@akfoerster.de>
 *
 * This file is part of AKFAvatar
 *
 * AKFAvatar is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * AKFAvatar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "avtaddons.h"

static const struct avt_char_map map = {
  .start = 0xA1,.end = 0xFF,
  .table = {
	    0x0401,		// 0xA1
	    0x0402,		// 0xA2
	    0x0403,		// 0xA3
	    0x0404,		// 0xA4
	    0x0405,		// 0xA5
	    0x0406,		// 0xA6
	    0x0407,		// 0xA7
	    0x0408,		// 0xA8
	    0x0409,		// 0xA9
	    0x040A,		// 0xAA
	    0x040B,		// 0xAB
	    0x040C,		// 0xAC
	    0x00AD,		// 0xAD
	    0x040E,		// 0xAE
	    0x040F,		// 0xAF
	    0x0410,		// 0xB0
	    0x0411,		// 0xB1
	    0x0412,		// 0xB2
	    0x0413,		// 0xB3
	    0x0414,		// 0xB4
	    0x0415,		// 0xB5
	    0x0416,		// 0xB6
	    0x0417,		// 0xB7
	    0x0418,		// 0xB8
	    0x0419,		// 0xB9
	    0x041A,		// 0xBA
	    0x041B,		// 0xBB
	    0x041C,		// 0xBC
	    0x041D,		// 0xBD
	    0x041E,		// 0xBE
	    0x041F,		// 0xBF
	    0x0420,		// 0xC0
	    0x0421,		// 0xC1
	    0x0422,		// 0xC2
	    0x0423,		// 0xC3
	    0x0424,		// 0xC4
	    0x0425,		// 0xC5
	    0x0426,		// 0xC6
	    0x0427,		// 0xC7
	    0x0428,		// 0xC8
	    0x0429,		// 0xC9
	    0x042A,		// 0xCA
	    0x042B,		// 0xCB
	    0x042C,		// 0xCC
	    0x042D,		// 0xCD
	    0x042E,		// 0xCE
	    0x042F,		// 0xCF
	    0x0430,		// 0xD0
	    0x0431,		// 0xD1
	    0x0432,		// 0xD2
	    0x0433,		// 0xD3
	    0x0434,		// 0xD4
	    0x0435,		// 0xD5
	    0x0436,		// 0xD6
	    0x0437,		// 0xD7
	    0x0438,		// 0xD8
	    0x0439,		// 0xD9
	    0x043A,		// 0xDA
	    0x043B,		// 0xDB
	    0x043C,		// 0xDC
	    0x043D,		// 0xDD
	    0x043E,		// 0xDE
	    0x043F,		// 0xDF
	    0x0440,		// 0xE0
	    0x0441,		// 0xE1
	    0x0442,		// 0xE2
	    0x0443,		// 0xE3
	    0x0444,		// 0xE4
	    0x0445,		// 0xE5
	    0x0446,		// 0xE6
	    0x0447,		// 0xE7
	    0x0448,		// 0xE8
	    0x0449,		// 0xE9
	    0x044A,		// 0xEA
	    0x044B,		// 0xEB
	    0x044C,		// 0xEC
	    0x044D,		// 0xED
	    0x044E,		// 0xEE
	    0x044F,		// 0xEF
	    0x2116,		// 0xF0
	    0x0451,		// 0xF1
	    0x0452,		// 0xF2
	    0x0453,		// 0xF3
	    0x0454,		// 0xF4
	    0x0455,		// 0xF5
	    0x0456,		// 0xF6
	    0x0457,		// 0xF7
	    0x0458,		// 0xF8
	    0x0459,		// 0xF9
	    0x045A,		// 0xFA
	    0x045B,		// 0xFB
	    0x045C,		// 0xFC
	    0x00A7,		// 0xFD
	    0x045E,		// 0xFE
	    0x045F		// 0xFF
	    }
};


static const struct avt_charenc converter = {
  .data = (void *) &map,
  .decode = map_to_unicode,
  .encode = map_from_unicode
};


extern const struct avt_charenc *
avt_iso8859_5 (void)
{
  return &converter;
}
