/*
 *   This file is part of AkariXB
 *   Copyright 2015-2018  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "variableparser.h"


VariableParser::VariableParser(QObject *parent) : QObject(parent)
{
    m_ownNickname = QStringLiteral("AkariXB");

    qDebug() << "VariableParser created";
}

VariableParser::~VariableParser()
{
    qDebug() << "VariableParser destroyed";
}


void VariableParser::setOwnNickname(QString newNickname)
{
    m_ownNickname = newNickname;
}



QString VariableParser::getParsed(QString originalString)
{
    QString parsedString = originalString.trimmed();

    parsedString.replace("%smiley%",  "{;)|:)|=)|:D|xD}");

    /*
     * Replace {a|b|c|d} with one of the options, selected randomly
     *
     * FIXME: Handle cases like { a | { b | c } | d }
     *
     */
    QRegExp choiceRE("\\{.+\\}"); // FIXME: check for a { inside
    choiceRE.setMinimal(true);

    int pos = 0;
    while ((pos = choiceRE.indexIn(parsedString, pos)) != -1)
    {
        QString matchedString = choiceRE.cap(0);
        qDebug() << "getParsed(); matched string:" << matchedString;
        QString chosenString;
        if (matchedString.contains("|"))
        {
            matchedString.remove(0,  1); // Remove {
            matchedString.remove(-1, 1); // Remove }
            // Split on pipe, choose one
            QStringList choices = matchedString.split("|");
            int choiceNum = qrand() % choices.length();
            chosenString = choices.at(choiceNum);

            // Replace at specific position to avoid identical choices having the same result
            parsedString.replace(pos, choiceRE.cap(0).length(), chosenString);
        }
        else
        {
            pos += matchedString.length(); // No pipe, so advance the {something} characters
        }

        if (!chosenString.isEmpty()) // There was a pipe, and something not empty was chosen
        {
            pos += chosenString.length();
        }
    }


    // Replace a few other variables or special characters
    parsedString.replace("%line%",    "\n");
    parsedString.replace("%ownnick%", m_ownNickname);

    qDebug() << "end getParsed();";

    return parsedString;
}

