/*
 *   This file is part of AkariXB
 *   Copyright 2015-2018  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef COMMANDMODULE_H
#define COMMANDMODULE_H

#include <QWidget>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QFormLayout>
#include <QListWidget>
#include <QLineEdit>
#include <QComboBox>
#include <QSpinBox>
#include <QCheckBox>
#include <QPushButton>
#include <QMessageBox>
#include <QLabel>
#include <QFileDialog>

#include <QDebug>


#include "globalobject.h"
#include "commandhandler.h"
#include "stringlistwidget.h"
#include "datafile.h"


class CommandModule : public QWidget
{
    Q_OBJECT

public:
    explicit CommandModule(CommandHandler *handler, GlobalObject *globalObject,
                           QWidget *parent = nullptr);
    ~CommandModule();

    void loadCommands();

    bool validateCommand(int commandType);


signals:


public slots:
    void onTriggerChanged(QString newTrigger);

    void findFile();


    void addCommand();
    void removeCommand();

    void onCommandSelected(int row);

    void onTypeChanged(int commandType);

    void saveCommand();

    void syncCommands();


private:
    QHBoxLayout *mainLayout;

    QVBoxLayout *leftLayout;
    QPushButton *syncCommandsButton;
    QListWidget *commandListWidget;
    QPushButton *addCommandButton;
    QPushButton *removeCommandButton;


    QWidget *rightWidget;
    QVBoxLayout *rightLayout;
    QFormLayout *formLayout;
    QLineEdit *triggerLineEdit;
    QLineEdit *helpLineEdit;
    QSpinBox  *accessLevelSpinbox;
    QComboBox *typeCombobox;
    QLabel *typeHelpLabel;


    QVBoxLayout *typeLayout;
    QLineEdit *staticLineEdit;
    StringListWidget *randomListWidget;

    QHBoxLayout *filenameLayout;
    QLabel *filenameLabel;
    QPushButton *filenameButton;

    StringListWidget *keywordListWidget;

    QHBoxLayout *m_programLayout;
    QLineEdit *m_programLineEdit;
    QComboBox *m_runDetachedCombobox;

    QLineEdit *aliasLineEdit;


    QLineEdit *outputLineEdit;
    QLabel *m_outputPatternHelpLabel;
    QCheckBox *privateReplyCheckbox;


    QPushButton *saveCommandButton;

    QString textFilename;

    DataFile *dataFile;
    CommandHandler *commandHandler;
    GlobalObject *globalObj;
};

#endif // COMMANDMODULE_H
