/*  ADCD - A Diminutive CD player for GNU/Linux
    Copyright (C) 2004, 2005, 2006, 2007, 2009, 2010 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class CD
  {
  enum Status { no_disc, stopped, paused, playing };
  struct Track_times { Msf_time start, end; };

  int filedes;			// file descriptor
  Status status;
  Msf_time _time_abs, _time_rel;
  int _track;			// current track
  int _first_track;		// first track on current disc (not always 1)
  int _last_track;		// last track on current disc
  int _index;			// index in playlist
  int _loop;			// Loop mode (0=no_loop, 1=Disc, 2=Track)
  bool _linear;			// Linear / Playlist mode
  std::vector< int > _playlist;
  std::vector< Track_times > _timelist;

public:
  CD( const char * const filename );
  ~CD();

  bool read_status( const bool force = true );

  void close();
  void open();
  void pause();
  void play();
  void stop();

  bool next_track();
  bool prev_track();
  bool seek_forward( const int seconds );
  bool seek_backward( const int seconds );

  int  index() const throw() { return _index; }
  bool linear() const throw() { return _linear; }
  void linear( const bool new_linear ) throw() { _linear = new_linear; }
  int loop() const throw() { return _loop; }
  void loop( const int new_loop );
  const char * loop_name() const throw();
  const std::vector< int > & playlist() const throw() { return _playlist; }
  void playlist( const std::vector< int > & pl );
  void show_info() const throw();
  const char * status_name() const throw();

  int  first_track() const throw() { return _first_track; }
  int  last_track() const throw() { return _last_track; }
  int  track() const throw() { return _track; }
  bool track( const int new_track, const bool start = false );
  int  tracks() const throw()
    { return (_last_track > 0) ? _last_track - _first_track + 1 : 0; }

  int  volume() const throw();
  bool volume( int vol ) const throw();

  enum Time_mode { relative, rem_rel, absolute, rem_abs };
  Msf_time time( const Time_mode mode ) const throw();
  Msf_time time_start( const int track ) const throw();
  Msf_time time_end( const int track ) const throw();
  Msf_time time_track( const int track ) const throw();
  Msf_time time_disc() const throw();
  };
