#ifndef FOLDERCONTENTVIEW_H
#define FOLDERCONTENTVIEW_H

#include <QtWidgets>

#include "comic_model.h"

#include "folder.h"
#include "comic_db.h"

class FolderModel;
class ComicModel;
class YACReaderToolBarStretch;

class QQuickWidget;
class QQmlContext;

class FolderContentView : public QWidget
{
    Q_OBJECT
public:
    explicit FolderContentView(QAction *toogleRecentVisibilityAction, QWidget *parent = nullptr);
    void setModel(const QModelIndex &parent, FolderModel *model);
    void setContinueReadingModel(ComicModel *model);
    void reloadContent();
    void reloadContinueReadingModel();
    void setShowRecent(bool visible);
    void setRecentRange(int days);

    FolderModel *currentFolderModel() { return folderModel; }
public slots:
    void updateSettings();

signals:
    void subfolderSelected(QModelIndex, int);
    void openComic(const ComicDB &comic, const ComicModel::Mode mode);

    // Drops
    void copyComicsToCurrentFolder(QList<QPair<QString, QString>>);
    void moveComicsToCurrentFolder(QList<QPair<QString, QString>>);

    void openFolderContextMenu(QPoint point, Folder folder);
    void openContinueReadingComicContextMenu(QPoint point, ComicDB comic);

protected slots:
    // void onItemClicked(const QModelIndex &mi);
    void updateCoversSizeInContext(int width, QQmlContext *ctxt);
    void setCoversSize(int width);
    virtual void showEvent(QShowEvent *event) override;
    void openFolder(int index);
    void openComicFromContinueReadingList(int index);
    void requestedFolderContextMenu(QPoint point, int index);
    void requestedContinueReadingComicContextMenu(QPoint point, int index);
    bool canDropUrls(const QList<QUrl> &urls, Qt::DropAction action);
    bool canDropFormats(const QString &formats);
    void droppedFiles(const QList<QUrl> &urls, Qt::DropAction action);

protected:
    QQuickWidget *view;
    QModelIndex parent;

    std::unique_ptr<ComicModel> comicModel;
    FolderModel *folderModel;

private:
    QSettings *settings;
    QToolBar *toolbar;
    YACReaderToolBarStretch *toolBarStretch;
    QAction *toolBarStretchAction;
    QWidget *coverSizeSliderWidget;
    QSlider *coverSizeSlider;
    QAction *coverSizeSliderAction;
    QAction *showInfoAction;
    QAction *showInfoSeparatorAction;
};

#endif // FOLDERCONTENTVIEW_H
