/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;

public abstract class ChartMeasure {
    protected String name;

    protected ChartMeasure(String name) {
        this.name = name;
    }

    public void plot() throws PlotException {
        this.plot(this.getDefaultPlotParameters());
    }

    public abstract PlotParameters getDefaultPlotParameters();

    public abstract void plot(PlotParameters var1) throws PlotException;

    public abstract JFreeChart createChart(PlotParameters var1) throws PlotException;

    public static void outputPlot(PlotParameters params, ChartMeasure ... measures) throws PlotException {
        if (measures == null || measures.length == 0) {
            throw new PlotException("no measure");
        }
        JFreeChart[] charts = new JFreeChart[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            charts[i] = measures[i].createChart(params);
        }
        ChartMeasure.outputPlot(params, charts);
    }

    public static void outputPlot(PlotParameters params, JFreeChart ... charts) throws PlotException {
        if (charts == null || charts.length == 0) {
            throw new PlotException("no chart");
        }
        if (charts.length > 1) {
            throw new PlotException("multiple charts not yet supported");
        }
        JFreeChart chart = charts[0];
        switch (params.outputType) {
            case SCREEN: {
                ChartPanel panel = new ChartPanel(chart, params.width, params.height, params.width, params.height, params.width + 50, params.height + 50, true, true, true, true, true, true);
                JFrame frame = new JFrame(params.title);
                frame.setDefaultCloseOperation(2);
                frame.setLocationRelativeTo(null);
                frame.add((Component)panel);
                frame.pack();
                frame.setVisible(true);
                break;
            }
            case JPEG: {
                try {
                    ChartUtilities.saveChartAsJPEG((File)new File(params.path), (JFreeChart)chart, (int)params.width, (int)params.height);
                    break;
                }
                catch (IOException e) {
                    throw new PlotException(e);
                }
            }
            case PNG: {
                try {
                    ChartUtilities.saveChartAsPNG((File)new File(params.path), (JFreeChart)chart, (int)params.width, (int)params.height);
                    break;
                }
                catch (IOException e) {
                    throw new PlotException(e);
                }
            }
        }
    }

    public static class PlotParameters {
        public PlotType type = PlotType.LINE;
        public PlotOutputType outputType = PlotOutputType.SCREEN;
        public String path = null;
        public String title = "plot";
        public String xAxisLabel = "x-axis";
        public String yAxisLabel = "y-axis";
        public PlotOrientation orientation = PlotOrientation.VERTICAL;
        public boolean showLegend = true;
        public int width = 600;
        public int height = 300;
    }

    public static class PlotException
    extends Exception {
        private static final long serialVersionUID = -1158885472939044996L;

        public PlotException(String message) {
            super(message);
        }

        public PlotException(Throwable cause) {
            super(cause);
        }
    }

    public static enum PlotOutputType {
        SCREEN,
        PNG,
        JPEG;

    }

    public static enum PlotType {
        LINE,
        BAR,
        PIE,
        SCATTER;

    }
}

