/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import org.graphstream.algorithm.generator.BaseGenerator;

public class GridGenerator
extends BaseGenerator {
    protected boolean cross = false;
    protected boolean tore = false;
    protected boolean generateXY = true;
    protected int currentSize = 0;
    protected int edgeNames = 0;

    public GridGenerator() {
        this(false, false);
    }

    public GridGenerator(boolean cross, boolean tore) {
        this(cross, tore, false);
    }

    public GridGenerator(boolean cross, boolean tore, boolean generateXY) {
        this(cross, tore, false, false);
    }

    public GridGenerator(boolean cross, boolean tore, boolean generateXY, boolean directed) {
        this.cross = cross;
        this.tore = tore;
        this.generateXY = generateXY;
        this.directed = directed;
    }

    @Override
    public void begin() {
        this.addNode(this.nodeName(0, 0), 0.0, 0.0);
    }

    @Override
    public boolean nextEvents() {
        String id;
        ++this.currentSize;
        for (int y = 0; y < this.currentSize; ++y) {
            id = this.nodeName(this.currentSize, y);
            this.addNode(id, this.currentSize, y);
            this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(this.currentSize - 1, y), id);
            if (y <= 0) continue;
            this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(this.currentSize, y - 1), id);
            if (!this.cross) continue;
            this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(this.currentSize - 1, y - 1), id);
            this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(this.currentSize, y - 1), this.nodeName(this.currentSize - 1, y));
        }
        for (int x = 0; x <= this.currentSize; ++x) {
            id = this.nodeName(x, this.currentSize);
            this.addNode(id, x, this.currentSize);
            this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(x, this.currentSize - 1), id);
            if (x <= 0) continue;
            this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(x - 1, this.currentSize), id);
            if (!this.cross) continue;
            this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(x - 1, this.currentSize - 1), id);
            this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(x - 1, this.currentSize), this.nodeName(x, this.currentSize - 1));
        }
        return true;
    }

    @Override
    public void end() {
        if (this.tore && this.currentSize > 0) {
            for (int y = 0; y <= this.currentSize; ++y) {
                this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(this.currentSize, y), this.nodeName(0, y));
                if (!this.cross || y <= 0) continue;
                this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(this.currentSize, y), this.nodeName(0, y - 1));
                this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(this.currentSize, y - 1), this.nodeName(0, y));
            }
            for (int x = 0; x <= this.currentSize; ++x) {
                this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(x, this.currentSize), this.nodeName(x, 0));
                if (!this.cross || x <= 0) continue;
                this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(x, this.currentSize), this.nodeName(x - 1, 0));
                this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(x - 1, this.currentSize), this.nodeName(x, 0));
            }
            if (this.cross) {
                this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(this.currentSize, 0), this.nodeName(0, this.currentSize));
                this.addEdge(Integer.toString(this.edgeNames++), this.nodeName(0, 0), this.nodeName(this.currentSize, this.currentSize));
            }
        }
        super.end();
    }

    protected String nodeName(int x, int y) {
        return Integer.toString(x) + "_" + Integer.toString(y);
    }
}

