/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.actions;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.Action;
import org.netbeans.spi.actions.ActionStub;
import org.netbeans.spi.actions.IndirectAction;
import org.netbeans.spi.actions.NbAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public abstract class ContextAction<T>
extends NbAction {
    final Class<T> type;
    private final StubListener stubListener = new StubListener();
    ActionStub<T> stub;
    static boolean unitTest;

    protected ContextAction(Class<T> type) {
        this(type, null, null);
    }

    protected ContextAction(Class<T> type, String displayName, Image icon) {
        this.type = type;
        Parameters.notNull((CharSequence)"type", type);
        if (displayName != null) {
            this.putValue("Name", displayName);
        }
        if (icon != null) {
            this.putValue("SmallIcon", ImageUtilities.image2Icon((Image)icon));
        }
        this.putValue("noIconInMenu", true);
    }

    public final boolean isEnabled() {
        return this._isEnabled();
    }

    boolean _isEnabled() {
        ActionStub<T> stubAction = this.getStub();
        Collection<T> targets = stubAction.collection();
        boolean result = this.checkQuantity(targets) && stubAction.isEnabled();
        return result;
    }

    boolean checkQuantity(Collection<? extends T> targets) {
        return this.checkQuantity(targets.size());
    }

    protected boolean checkQuantity(int numberOfObjects) {
        return numberOfObjects > 0;
    }

    protected boolean isEnabled(Collection<? extends T> targets) {
        return true;
    }

    protected abstract void actionPerformed(Collection<? extends T> var1);

    public final void actionPerformed(ActionEvent ignored) {
        this.getStub().actionPerformed(null);
    }

    @Override
    protected final NbAction internalCreateContextAwareInstance(Lookup actionContext) {
        return this.createStub(actionContext);
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    ActionStub<T> createStub(Lookup actionContext) {
        return new ActionStub(actionContext, this);
    }

    private ActionStub<T> createInternalStub() {
        assert (Thread.holdsLock(this.lock()));
        ActionStub<T> result = this.createStub(Utilities.actionsGlobalContext());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActionStub<T> getStub() {
        Object object = this.lock();
        synchronized (object) {
            if (this.stub == null && this.attached()) {
                this.stub = this.createInternalStub();
                this.stub.addPropertyChangeListener(this.stubListener);
            }
            return this.stub == null ? this.createInternalStub() : this.stub;
        }
    }

    public String toString() {
        return super.toString() + "[name=" + this.getValue("Name") + " type=" + this.type.getName() + "]";
    }

    protected void change(Collection<? extends T> collection, Action instance) {
    }

    @Override
    void internalAddNotify() {
        this.stub = this.getStub();
        this.stub.resultChanged(null);
        super.internalAddNotify();
    }

    @Override
    void internalRemoveNotify() {
        try {
            super.internalRemoveNotify();
        }
        finally {
            this.stub.removePropertyChangeListener(this.stubListener);
            this.stub = null;
        }
    }

    protected final void refresh() {
        this.getStub().resultChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<? extends T> stubCollection() {
        Object object = this.lock();
        synchronized (object) {
            return this.stub == null ? null : this.stub.collection();
        }
    }

    public static <T extends Lookup.Provider, R> ContextAction<T> createIndirectAction(Class<T> lkpProviderType, ContextAction<R> theRealAction, boolean allLookupsMustBeUsable) {
        return new IndirectAction<T, R>(lkpProviderType, theRealAction, allLookupsMustBeUsable);
    }

    public static <T extends Lookup.Provider, R> ContextAction<T> createIndirectAction(Class<T> lkpProviderType, ContextAction<R> theRealAction) {
        return ContextAction.createIndirectAction(lkpProviderType, theRealAction, true);
    }

    private class StubListener
    implements PropertyChangeListener {
        private StubListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ContextAction.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }
}

