/*
 * Decompiled with CFR 0.152.
 */
package ancestris.explorer;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.explorer.ExplorerNode;
import ancestris.gedcom.PropertyNode;
import ancestris.view.AncestrisTopComponent;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Note;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class EntityNode
extends PropertyNode
implements Comparable<EntityNode>,
ExplorerNode {
    Entity entity;

    public EntityNode(Entity e) {
        super(new Context(e));
        this.entity = e;
    }

    public String getDisplayName() {
        Entity entity = this.entity;
        if (entity instanceof Indi) {
            Indi i = (Indi)entity;
            return i.toString(true);
        }
        entity = this.entity;
        if (entity instanceof Fam) {
            Fam f = (Fam)entity;
            return f.toString(true);
        }
        entity = this.entity;
        if (entity instanceof Note) {
            Note n = (Note)entity;
            return n.getDelegate().getLines(true)[0] + " (" + this.entity.getId() + ")";
        }
        return this.entity.toString(true);
    }

    void fireChanges() {
        this.fireDisplayNameChange(null, this.getDisplayName());
        this.fireIconChange();
    }

    public String getHtmlDisplayName() {
        return null;
    }

    public Action getPreferredAction() {
        for (AncestrisTopComponent atc : AncestrisPlugin.lookupAll(AncestrisTopComponent.class)) {
            if (!this.getContext().getGedcom().equals(atc.getGedcom())) continue;
            atc.refreshPanel(this.getContext());
        }
        return new FireNodeSelection();
    }

    public Image getIcon(int type) {
        return this.entity.getImage().getImage();
    }

    Entity getEntity() {
        return this.entity;
    }

    @Override
    public int compareTo(EntityNode that) {
        Entity o;
        Entity entity = this.entity;
        if (entity instanceof Indi) {
            Indi i = (Indi)entity;
            o = (Indi)that.getEntity();
            return i.getDisplayComparator().compare((Object)i, (Object)o);
        }
        o = this.entity;
        if (o instanceof Fam) {
            Fam i = (Fam)o;
            o = (Fam)that.getEntity();
            return i.getDisplayComparator().compare((Object)i, (Object)o);
        }
        return this.entity.getDisplayComparator().compare((Object)this.entity, (Object)that.getEntity());
    }

    @Override
    public Context getContext() {
        return new Context(this.entity);
    }

    protected class FireNodeSelection
    extends AbstractAction {
        protected FireNodeSelection() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectionDispatcher.fireSelection((Context)EntityNode.this.getContext());
        }
    }
}

