/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.gedcom.GedcomDirectory;
import ancestris.util.Utilities;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyNote;
import java.util.List;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;

public class FamQuickSearch
implements SearchProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(SearchRequest request, SearchResponse response) {
        String req = request.getText();
        FamQuickSearch famQuickSearch = this;
        synchronized (famQuickSearch) {
            List contexts = GedcomDirectory.getDefault().getContexts();
            boolean many = contexts.size() > 1;
            int index = 0;
            for (Context context : contexts) {
                String gedcomName = context.getGedcom().getDisplayName();
                for (Fam fam : context.getGedcom().getFamilies()) {
                    if (!Utilities.wordsMatch((String)this.getStringFromFam(fam), (String)req)) continue;
                    String famName = fam.toString(true);
                    if (response.addResult(this.createAction((Entity)fam), Utilities.createHtmlDisplayName((String)famName, (String)req, (int)index, (String)(many ? gedcomName : "")))) continue;
                    return;
                }
                ++index;
            }
        }
    }

    private Runnable createAction(Entity entity) {
        return () -> SelectionDispatcher.fireSelection((Context)new Context(entity));
    }

    private String getStringFromFam(Fam fam) {
        Indi wife;
        Object ret = "";
        Indi husb = fam.getHusband();
        if (husb != null) {
            String[] names;
            for (String name : names = husb.getLastNames()) {
                ret = (String)ret + name + " ";
            }
            String[] firstnames = husb.getFirstNames();
            for (String firstname : firstnames) {
                ret = (String)ret + (String)firstname + " ";
            }
        }
        if ((wife = fam.getWife()) != null) {
            String[] firstnames;
            String[] names = wife.getLastNames();
            for (String name : names) {
                ret = (String)ret + (String)name + " ";
            }
            for (String firstname : firstnames = wife.getFirstNames()) {
                ret = (String)ret + firstname + " ";
            }
        }
        List properties = fam.getAllProperties("NOTE");
        for (Property noteProp : properties) {
            String text;
            if (noteProp == null || noteProp instanceof PropertyNote || (text = noteProp.getDisplayValue().replaceAll("(\\r|\\n)", "").trim()).isEmpty()) continue;
            ret = (String)ret + " " + text;
        }
        ret = (String)ret + fam.toString(true);
        return ((String)ret).toLowerCase();
    }
}

