/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.app.ActionAPropos;
import ancestris.app.ActionNew;
import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.gedcom.GedcomDirectory;
import ancestris.util.Utilities;
import ancestris.view.Images;
import genj.util.Registry;
import genj.util.swing.ImageIcon;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Scanner;
import java.util.regex.MatchResult;
import javax.swing.Icon;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ActionOpenRepositories
extends AbstractAncestrisAction {
    private FileObject fileToOpen = null;

    public ActionOpenRepositories() {
        this.setText(NbBundle.getMessage(ActionNew.class, (String)"CTL_ActionOpenRepositories"));
        this.setTip(NbBundle.getMessage(ActionNew.class, (String)"HINT_ActionOpenRepositories"));
        this.setImage((Icon)new ImageIcon(Images.class, "images/OpenRepositories"));
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.getRepositoriesFile()) {
            try {
                GedcomDirectory.getDefault().openGedcom(this.fileToOpen);
            }
            catch (Exception e) {
                System.out.println("Error opening repositories:" + e);
            }
        } else {
            System.out.println("Error opening repositories. File Repositories.ged not found.");
        }
    }

    private boolean getRepositoriesFile() {
        boolean firstTime = false;
        boolean overwrite = false;
        String filename = "Repositories";
        String fileExt = ".ged";
        String localFilename = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)filename);
        File file = Utilities.getResourceAsFile(((Object)((Object)this)).getClass(), (String)("resources/" + filename + fileExt), (String)fileExt);
        if (file == null || !file.exists()) {
            return false;
        }
        int newVersion = this.getVersionFromFile(file);
        File destFolder = new File(System.getProperty("user.home.ancestris") + File.separator + "repositories");
        File destFile = new File(destFolder.getPath() + File.separator + localFilename + fileExt);
        int oldVersion = this.getVersionFromFile(destFile);
        if (destFile.isFile()) {
            if (newVersion > oldVersion) {
                String title = NbBundle.getMessage(ActionAPropos.class, (String)"CTL_ActionOpenRepositories").replaceAll("&", "");
                String text = NbBundle.getMessage(ActionAPropos.class, (String)"ActionOpenRepositories_Overwrite");
                NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)text, title, 0, 3);
                Iterator o = DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                if (o.equals(NotifyDescriptor.YES_OPTION)) {
                    destFile.delete();
                    overwrite = true;
                }
            }
        } else {
            firstTime = true;
            overwrite = true;
        }
        if (overwrite) {
            try {
                destFolder.mkdirs();
                this.fileToOpen = FileUtil.copyFile((FileObject)FileUtil.toFileObject((File)file), (FileObject)FileUtil.toFileObject((File)destFolder), (String)localFilename);
                firstTime = true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        } else {
            this.fileToOpen = FileUtil.toFileObject((File)destFile);
        }
        String propertiesExt = ".properties";
        file = Utilities.getResourceAsFile(((Object)((Object)this)).getClass(), (String)("resources/" + filename + fileExt + propertiesExt), (String)propertiesExt);
        if (file != null && file.exists()) {
            Registry sourceRegistry = new Registry(file);
            Registry gedcomRegistry = Registry.get((String)("gedcoms/settings/" + localFilename + fileExt));
            if (gedcomRegistry.get("context", "").equals("")) {
                for (String key : sourceRegistry.getProperties()) {
                    String value = sourceRegistry.get(key, "");
                    if (key.equals("context")) {
                        value = value.replace(filename, localFilename);
                    }
                    gedcomRegistry.put(key, value);
                }
                firstTime = true;
            }
        }
        if (firstTime && this.fileToOpen.isValid()) {
            String title = NbBundle.getMessage(ActionAPropos.class, (String)"CTL_ActionOpenRepositories");
            String text = NbBundle.getMessage(ActionAPropos.class, (String)"ActionOpenRepositories_Text");
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)text, title, -1, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        }
        return this.fileToOpen.isValid();
    }

    private int getVersionFromFile(File f) {
        int ret = 0;
        try {
            Scanner scanner = new Scanner(f);
            while (scanner.hasNextLine()) {
                String str = scanner.findInLine("..NOTE Version (\\d+)");
                if (str != null) {
                    MatchResult results = scanner.match();
                    String version = results.group(1).trim();
                    ret = Integer.valueOf(version);
                    break;
                }
                scanner.nextLine();
            }
            scanner.close();
        }
        catch (FileNotFoundException | IllegalStateException exception) {
            // empty catch block
        }
        return ret;
    }
}

