/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare;

import ancestris.modules.gedcomcompare.GedcomCompareTopComponent;
import ancestris.modules.gedcomcompare.tools.ConnectedUserFrame;
import java.util.ArrayList;
import java.util.List;

public class SearchUsers
extends Thread {
    public static int SEARCH_TYPE_MAPS = 0;
    public static int SEARCH_TYPE_EVENTS = 1;
    private final GedcomCompareTopComponent owner;
    private volatile boolean stopRun;
    private int searchType;
    private ConnectedUserFrame user;

    public SearchUsers(GedcomCompareTopComponent tstc, int searchType, ConnectedUserFrame user) {
        this.owner = tstc;
        this.searchType = searchType;
        this.user = user;
    }

    @Override
    public void run() {
        this.stopRun = false;
        this.owner.setRotatingIcon(true);
        while (!this.stopRun) {
            this.owner.updateConnectedUsers(false);
            if (this.searchType == SEARCH_TYPE_MAPS) {
                this.getUsersMaps(this.user);
            }
            if (this.searchType == SEARCH_TYPE_EVENTS) {
                this.getUsersEvents(this.user);
            }
            this.stopGracefully();
        }
    }

    public void stopGracefully() {
        this.stopRun = true;
        this.owner.setRotatingIcon(false);
        this.owner.displaySearchedUser("");
    }

    private void getUsersMaps(ConnectedUserFrame user) {
        List copyOfUsers = null;
        if (user == null) {
            copyOfUsers = (List)((ArrayList)this.owner.getConnectedUsers()).clone();
        } else {
            copyOfUsers = new ArrayList<ConnectedUserFrame>();
            copyOfUsers.add(user);
        }
        for (ConnectedUserFrame cuf : copyOfUsers) {
            if (!cuf.isIncluded() || cuf.isComplete()) continue;
            if (!cuf.isActive()) {
                cuf.resetIcon(1);
                continue;
            }
            this.owner.displaySearchedUser(cuf.getName());
            boolean ok = this.owner.getCommHandler().getMapCapsule(this.owner.getMapCapsule(), cuf);
            if (ok) {
                this.owner.addConnection();
            } else {
                cuf.resetIcon(1);
            }
            this.owner.getCommHandler().clearUserCommunication(cuf);
        }
    }

    private void getUsersEvents(ConnectedUserFrame user) {
        if (!user.isIncluded() || !user.isActive()) {
            user.resetIcon(2);
            return;
        }
        this.owner.displaySearchedUser(user.getName());
        boolean ok = this.owner.getCommHandler().getMapEventsCapsule(this.owner.getMapEventsCapsule(user), user);
        if (ok) {
            ok = this.owner.getCommHandler().getUserProfile(this.owner.getMyProfile(), user);
            if (ok) {
                this.owner.addConnection();
            } else {
                user.resetIcon(2);
            }
        } else {
            user.resetIcon(2);
        }
        this.owner.getCommHandler().clearUserCommunication(user);
    }
}

