/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.exports.genealogieonline;

import ancestris.gedcom.GedcomDirectory;
import ancestris.gedcom.GedcomMgr;
import ancestris.gedcom.SaveOptionsWidget;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.io.GedcomReader;
import genj.io.GedcomReaderContext;
import genj.io.GedcomReaderFactory;
import genj.util.Origin;
import genj.util.Trackable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import spin.Spin;

public class GenealogieonlineExport
implements Runnable,
Trackable {
    private static final Logger LOG = Logger.getLogger("ancestris.export", null);
    private final Gedcom gedcom;
    private final File exportFile;
    private final SaveOptionsWidget options;
    private Gedcom gedcomExported;
    private String state = "";
    private int progress = 0;

    public GenealogieonlineExport(Gedcom gedcom, File exportFile, SaveOptionsWidget options) {
        this.gedcom = gedcom;
        this.exportFile = exportFile;
        this.options = options;
    }

    @Override
    public void run() {
        File[] foundFiles;
        this.state = NbBundle.getMessage(GenealogieonlineExport.class, (String)"GenealogieonlineExport.Step1");
        GedcomDirectory.getDefault().saveGedcom(new Context(this.gedcom));
        Entity header = this.gedcom.getFirstEntity("HEAD");
        String fileValue = header.getProperty("FILE").getValue();
        this.state = NbBundle.getMessage(GenealogieonlineExport.class, (String)"GenealogieonlineExport.Step2");
        this.progress = 0;
        Origin pOrigin = this.gedcom.getOrigin();
        try {
            Origin nOrigin = Origin.create((URL)Utilities.toURI((File)this.exportFile).toURL());
            this.gedcom.setOrigin(nOrigin);
            GedcomMgr.getDefault().saveGedcomImpl(this.gedcom, this.options.getFilters(), null, this.options.getSort());
            this.gedcom.setOrigin(pOrigin);
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "Can't create new file ", e);
            this.displayError();
            return;
        }
        header.getProperty("FILE").setValue(fileValue);
        this.state = NbBundle.getMessage(GenealogieonlineExport.class, (String)"GenealogieonlineExport.Step3");
        this.progress = 25;
        Context context = this.openGedcomQuietly(FileUtil.toFileObject((File)this.exportFile), this.gedcom.getPassword());
        if (context == null || context.getGedcom() == null) {
            this.displayError();
            return;
        }
        this.gedcomExported = context.getGedcom();
        this.state = NbBundle.getMessage(GenealogieonlineExport.class, (String)"GenealogieonlineExport.Step4");
        this.progress = 50;
        this.convert();
        this.state = NbBundle.getMessage(GenealogieonlineExport.class, (String)"GenealogieonlineExport.Step5");
        this.progress = 75;
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        GedcomMgr.getDefault().saveGedcomImpl(this.gedcomExported, null, null, false);
        this.state = NbBundle.getMessage(GenealogieonlineExport.class, (String)"GenealogieonlineExport.Step6");
        this.progress = 90;
        String str = this.gedcomExported.getName().replace(".ged", "") + "_";
        File dir = new File(this.exportFile.getParent());
        for (File file : foundFiles = dir.listFiles((dir1, name) -> name.startsWith(str))) {
            file.delete();
        }
        this.progress = 100;
        this.displaySuccess();
    }

    private void displaySuccess() {
        DialogManager.create((String)NbBundle.getMessage(GenealogieonlineExport.class, (String)"FileChooserTitle", (Object)this.gedcom.getName()), (String)NbBundle.getMessage(GenealogieonlineExport.class, (String)"SavedAs", (Object)this.exportFile.getName())).show();
    }

    private void displayError() {
        DialogManager.createError((String)NbBundle.getMessage(GenealogieonlineExport.class, (String)"FileChooserTitle", (Object)this.gedcom.getName()), (String)NbBundle.getMessage(GenealogieonlineExport.class, (String)"ErrorSavingAs", (Object)this.exportFile.getName())).show();
    }

    private Context openGedcomQuietly(FileObject input, final String password) {
        Context context;
        if (input == null) {
            return null;
        }
        try {
            Origin origin = Origin.create((FileObject)input);
            GedcomReader reader = (GedcomReader)Spin.off((Object)GedcomReaderFactory.createReader((Origin)origin, (GedcomReaderContext)((GedcomReaderContext)Spin.over((Object)new GedcomReaderContext(){

                public String getPassword() {
                    return password;
                }

                public void handleWarning(int line, String warning, Context context) {
                }
            }))));
            Gedcom localGedcom = reader.read();
            context = new Context(localGedcom);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Unable to open copied gedcom", ex);
            return null;
        }
        return context;
    }

    private void convert() {
        this.convertHeader();
        for (Entity entity : this.gedcomExported.getIndis()) {
            Property givn;
            Indi indi = (Indi)entity;
            String firstname = indi.getFirstName().replaceAll(",", "");
            Property name = indi.getProperty("NAME");
            if (name == null || (givn = name.getProperty("GIVN")) == null) continue;
            givn.setValue(firstname);
        }
    }

    private boolean convertHeader() {
        Entity entity = this.gedcomExported.getFirstEntity("HEAD");
        Property property = entity.getProperty("NOTE");
        String note = NbBundle.getMessage(GenealogieonlineExport.class, (String)"GenealogieonlineExport.NoteWarning");
        if (property != null) {
            property.setValue(note);
        } else {
            entity.addProperty("NOTE", note);
        }
        this.gedcomExported.setDestination("Genealogieonline");
        LOG.log(Level.INFO, note);
        return true;
    }

    public void cancelTrackable() {
    }

    public int getProgress() {
        return this.progress;
    }

    public String getState() {
        return this.state;
    }

    public String getTaskName() {
        return NbBundle.getMessage(GenealogieonlineExport.class, (String)"FileChooserTitle", (Object)this.gedcom.getName());
    }
}

