/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.jdesktop.swingx.mapviewer.util.GeoUtil;

public abstract class TileFactory {
    private TileFactoryInfo info;

    protected TileFactory(TileFactoryInfo info) {
        this.info = info;
    }

    public int getTileSize(int zoom) {
        return this.getInfo().getTileSize(zoom);
    }

    public Dimension getMapSize(int zoom) {
        return GeoUtil.getMapSize(zoom, this.getInfo());
    }

    public abstract Tile getTile(int var1, int var2, int var3);

    public GeoPosition pixelToGeo(Point2D pixelCoordinate, int zoom) {
        return GeoUtil.getPosition(pixelCoordinate, zoom, this.getInfo());
    }

    public Point2D geoToPixel(GeoPosition c, int zoomLevel) {
        return GeoUtil.getBitmapCoordinate(c, zoomLevel, this.getInfo());
    }

    public TileFactoryInfo getInfo() {
        return this.info;
    }

    protected abstract void startLoading(Tile var1);
}

