/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchdupes;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.openide.util.NbPreferences;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class Log {
    private static final String BAR = "=".repeat(130);
    private static final int MARGIN = 3;
    private final InputOutput io;
    private PrintWriter outFile;
    public boolean NORMAL = true;
    public boolean ERROR = false;
    private File logFile;

    public Log(String title, String logname) {
        this.io = IOProvider.getDefault().getIO(title, true);
        this.io.select();
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime());
        String str = new File(System.getProperty("user.home.ancestris")).getParent() + File.separator + "config/Preferences";
        String path = NbPreferences.forModule(Log.class).absolutePath();
        this.logFile = new File(str + path + File.separator + logname.replace(" ", "") + "_" + timeStamp + ".log");
        try {
            this.outFile = new PrintWriter(new FileWriter(this.logFile));
        }
        catch (IOException ioe) {
            this.io.getErr().println("IO Exception!");
            ioe.printStackTrace();
        }
    }

    public void write(String text) {
        this.write(this.NORMAL, text);
    }

    public void error(String text) {
        this.write(this.ERROR, text);
    }

    public void write(boolean mode, String text) {
        if (mode) {
            this.io.getOut().println(text);
        } else {
            this.io.getErr().println(text);
        }
        this.outFile.println(text);
    }

    public void close() {
        if (this.outFile != null) {
            this.outFile.flush();
            this.outFile.close();
        }
    }

    public void timeStamp() {
        this.write(this.NORMAL, Calendar.getInstance().getTime().toString());
    }

    public void printStackTrace(Exception ex) {
        ex.printStackTrace((PrintWriter)this.io.getErr());
    }

    public void tellLogFile() {
        this.write(this.NORMAL, "---");
        this.write(this.NORMAL, "(" + this.logFile.getAbsolutePath() + ")");
        this.write(this.NORMAL, " ");
    }

    public void title(String title) {
        String bit = " ".repeat((BAR.length() - title.length()) / 2);
        int plug = BAR.length() - bit.length() * 2 - title.length();
        this.write(this.NORMAL, "+" + BAR + "+");
        this.write(this.NORMAL, "|" + bit + title + bit + " ".repeat(plug) + "|");
        this.write(this.NORMAL, "+" + BAR + "+");
        this.write(this.NORMAL, " ");
    }

    public void underline(String str) {
        this.write(this.NORMAL, str);
        this.write(this.NORMAL, "=".repeat(str.length()));
        this.write(this.NORMAL, " ");
    }

    public void bar() {
        this.write(this.NORMAL, "=" + BAR + "=");
    }

    public void table(boolean type, Col[] cols) {
        this.table(type, cols, false);
    }

    public void table(boolean type, Col[] cols, boolean header) {
        int nbLines = 0;
        int totalWidth = 0;
        for (Col col : cols) {
            if (col.lines.size() > nbLines) {
                nbLines = col.lines.size();
            }
            totalWidth += col.width;
        }
        for (int l = 0; l < nbLines; ++l) {
            Object line = "";
            for (Col col : cols) {
                String bit = l < col.lines.size() ? col.lines.get(l) : " ".repeat(col.width);
                line = (String)line + bit;
            }
            this.write(type, (String)line);
        }
        if (header) {
            this.write(type, "=".repeat(totalWidth));
        }
        if (header || nbLines > 1) {
            this.write(type, " ");
        }
    }

    public Col getCol(int width, String str) {
        return new Col(width, str);
    }

    public class Col {
        public int width = 0;
        public String str = "";
        public List<String> lines;

        public Col(int width, String str) {
            this.width = width;
            this.str = str;
            this.lines = this.getLinesFromString(str, width);
        }

        private List<String> getLinesFromString(String str, int width) {
            ArrayList<String> ret = new ArrayList<String>();
            for (String line : str.split("(\\r\\n|\\r|\\n)")) {
                if (line.length() + 3 <= width) {
                    ret.add(line + " ".repeat(width - line.length()));
                    continue;
                }
                List<String> words = this.splitLine(line, width);
                StringBuilder trimmedLine = new StringBuilder();
                for (String word : words) {
                    if (trimmedLine.length() + word.length() + 3 <= width) {
                        trimmedLine.append(word).append(" ");
                        continue;
                    }
                    ret.add(trimmedLine.toString() + " ".repeat(width - trimmedLine.length()));
                    trimmedLine = new StringBuilder();
                    trimmedLine.append(word).append(" ");
                }
                if (trimmedLine.length() <= 0) continue;
                ret.add(trimmedLine.toString() + " ".repeat(width - trimmedLine.length()));
            }
            return ret;
        }

        private List<String> splitLine(String line, int width) {
            ArrayList<String> ret = new ArrayList<String>();
            for (String word : line.split(" ")) {
                while (word.length() + 3 > width) {
                    ret.add(word.substring(0, width - 3));
                    word = word.substring(width - 3);
                }
                ret.add(word);
            }
            return ret;
        }
    }
}

