/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.renderer.DPI;
import genj.util.ByteArray;
import genj.util.Dimension2d;
import genj.util.ImageSniffer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageFilter;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;

public class ImageIcon
extends javax.swing.ImageIcon {
    private static final ImageFilter GRAYSCALE_FILTER = new BufferedImageFilter(new GrayscaleFilter());
    private DPI dpi = null;
    private Map<Object, ImageIcon> overlays = new WeakHashMap<Object, ImageIcon>();

    public ImageIcon(Image copy) {
        super(copy);
    }

    public ImageIcon(Icon icon) {
        if (icon instanceof javax.swing.ImageIcon) {
            this.setImage(((javax.swing.ImageIcon)icon).getImage());
        } else {
            BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            icon.paintIcon(null, image.getGraphics(), 0, 0);
            this.setImage(image);
        }
    }

    public ImageIcon(String naMe, byte[] data) {
        super(data);
        if (this.getImageLoadStatus() != 8) {
            throw new RuntimeException("load status incomplete");
        }
        if (this.getIconHeight() < 0 || this.getIconWidth() < 0) {
            throw new RuntimeException("image with invalid width/height");
        }
        this.setDescription(naMe);
        this.dpi = new ImageSniffer(new ByteArrayInputStream(data)).getDPI();
    }

    public ImageIcon(Object from, String resource) {
        this(from.getClass(), resource);
    }

    private static String patchPNG(String resource) {
        return resource.indexOf(46) < 0 ? resource + ".png" : resource;
    }

    public ImageIcon(Class<?> from, String resource) {
        this(from.getName() + "#" + resource, from.getResourceAsStream(ImageIcon.patchPNG(resource)), true);
    }

    public ImageIcon(String name, InputStream in) {
        this(name, in, false);
    }

    private ImageIcon(String name, InputStream in, boolean close) {
        this(name, ImageIcon.read(name, in, close));
    }

    public DPI getResolution() {
        return this.dpi;
    }

    public Dimension2D getSizeInInches() {
        if (this.dpi == null) {
            return null;
        }
        return new Dimension2d((double)this.getIconWidth() / (double)this.dpi.horizontal(), (double)this.getIconHeight() / (double)this.dpi.vertical());
    }

    public Dimension getSizeInPoints(DPI dpiTarget) {
        Dimension2D sizeInInches = this.getSizeInInches();
        if (sizeInInches == null) {
            return new Dimension(this.getIconWidth(), this.getIconHeight());
        }
        return new Dimension((int)(sizeInInches.getWidth() * (double)dpiTarget.horizontal()), (int)(sizeInInches.getHeight() * (double)dpiTarget.vertical()));
    }

    public ImageIcon paintIcon(Graphics g, int x, int y) {
        super.paintIcon(null, g, x, y);
        return this;
    }

    private static byte[] read(String name, InputStream in, boolean close) {
        if (in == null) {
            throw new IllegalArgumentException("no stream for " + name);
        }
        try {
            byte[] byArray = new ByteArray(in).getBytes();
            return byArray;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("can't read " + name + ": " + ex.getMessage());
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("interrupted while reading " + name);
        }
        finally {
            if (close) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ImageIcon getGrayedOut() {
        ImageIcon result = this.overlays.get("grayedout");
        if (result != null) {
            return result;
        }
        FilteredImageSource prod = new FilteredImageSource(this.getImage().getSource(), GRAYSCALE_FILTER);
        Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
        result = new ImageIcon(grayImage);
        result.dpi = this.dpi;
        result.setDescription(this.getDescription());
        this.overlays.put("grayedout", result);
        return result;
    }

    public ImageIcon getTransparent(final int threshold) {
        ImageIcon result = this.overlays.get(Integer.toString(threshold));
        if (result != null) {
            return result;
        }
        if (threshold < 0 || threshold > 255) {
            throw new IllegalArgumentException("!(0<=threshold<=255)");
        }
        FilteredImageSource prod = new FilteredImageSource(this.getImage().getSource(), new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                int alpha = rgb >> 24 & 0xFF;
                alpha = alpha * threshold / 255;
                return rgb & 0xFFFFFF | alpha << 24;
            }
        });
        result = new ImageIcon(Toolkit.getDefaultToolkit().createImage(prod));
        result.dpi = this.dpi;
        result.setDescription(this.getDescription());
        this.overlays.put(Integer.toString(threshold), result);
        return result;
    }

    public ImageIcon getOverLayed(ImageIcon overlay) {
        ImageIcon result = this.overlays.get(overlay);
        if (result != null) {
            return result;
        }
        int height = Math.max(this.getIconHeight(), overlay.getIconHeight());
        int width = Math.max(this.getIconWidth(), overlay.getIconWidth());
        Image image1 = this.getImage();
        Image image2 = overlay.getImage();
        BufferedImage composite = new BufferedImage(width, height, 2);
        Graphics2D g = composite.createGraphics();
        g.setClip(0, 0, width, height);
        g.drawImage(image1, 0, 0, null);
        g.drawImage(image2, 0, 0, null);
        g.dispose();
        result = new ImageIcon(composite);
        result.dpi = this.dpi;
        result.setDescription(this.getDescription());
        this.overlays.put(overlay, result);
        return result;
    }

    private static class GrayscaleFilter
    implements BufferedImageOp {
        private GrayscaleFilter() {
        }

        @Override
        public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
            if (dstCM == null) {
                dstCM = src.getColorModel();
            }
            return new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), dstCM.isAlphaPremultiplied(), null);
        }

        @Override
        public Rectangle2D getBounds2D(BufferedImage src) {
            return new Rectangle(0, 0, src.getWidth(), src.getHeight());
        }

        @Override
        public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
            if (dstPt == null) {
                dstPt = new Point2D.Double();
            }
            dstPt.setLocation(srcPt.getX(), srcPt.getY());
            return dstPt;
        }

        @Override
        public RenderingHints getRenderingHints() {
            return null;
        }

        @Override
        public BufferedImage filter(BufferedImage src, BufferedImage dst) {
            int width = src.getWidth();
            int height = src.getHeight();
            int type = src.getType();
            WritableRaster srcRaster = src.getRaster();
            if (dst == null) {
                dst = this.createCompatibleDestImage(src, null);
            }
            WritableRaster dstRaster = dst.getRaster();
            int[] inPixels = new int[width];
            for (int y = 0; y < height; ++y) {
                int x;
                if (type == 2) {
                    srcRaster.getDataElements(0, y, width, 1, inPixels);
                    for (x = 0; x < width; ++x) {
                        inPixels[x] = this.filterRGB(x, y, inPixels[x]);
                    }
                    dstRaster.setDataElements(0, y, width, 1, inPixels);
                    continue;
                }
                src.getRGB(0, y, width, 1, inPixels, 0, width);
                for (x = 0; x < width; ++x) {
                    inPixels[x] = this.filterRGB(x, y, inPixels[x]);
                }
                dst.setRGB(0, y, width, 1, inPixels, 0, width);
            }
            return dst;
        }

        private int filterRGB(int x, int y, int rgb) {
            int a = rgb & 0xFF000000;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            rgb = r * 77 + g * 151 + b * 28 >> 8;
            return a | rgb << 16 | rgb << 8 | rgb;
        }
    }
}

