/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class HeapStatusWidget
extends JProgressBar {
    private static final NumberFormat FORMAT = new DecimalFormat("0.0");
    private MessageFormat tooltip = new MessageFormat("Heap: {0}MB used {1}MB free {2}MB max");

    public HeapStatusWidget() {
        super(0, 100);
        this.setValue(0);
        this.setBorderPainted(false);
        this.setStringPainted(true);
        new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapStatusWidget.this.update();
            }
        }).start();
    }

    private void update() {
        Runtime r = Runtime.getRuntime();
        long max = r.maxMemory();
        long free = r.freeMemory();
        long total = r.totalMemory();
        long used = total - free;
        int percent = (int)Math.round((double)used * 100.0 / (double)max);
        this.setValue(percent);
        this.setString(this.format(used, true) + "MB (" + percent + "%)");
        super.setToolTipText(null);
        super.setToolTipText(this.tooltip.format(new String[]{this.format(used, false), this.format(free, false), this.format(max, false)}));
    }

    private String format(long mb, boolean decimals) {
        double val = (double)mb / 1000000.0;
        return decimals ? FORMAT.format((double)mb / 1000000.0) : Integer.toString((int)Math.round(val));
    }

    @Override
    public void setToolTipText(String text) {
        this.tooltip = new MessageFormat(text);
        super.setToolTipText("");
    }
}

