/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.gedcom.GedcomException;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyXRef;
import genj.io.GedcomFormatException;
import genj.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.NoSuchElementException;

public class PropertyReader {
    protected static final Resources RESOURCES = Resources.get(PropertyReader.class);
    protected boolean useIndents = false;
    protected int lines = 0;
    protected String line = null;
    protected boolean cont = true;
    protected Collection<PropertyXRef> collectXRefs;
    protected boolean isMerge = false;
    protected boolean sameGedcom = false;
    protected int level;
    protected String tag;
    protected String xref;
    protected String value;
    protected String bit = "";
    protected BufferedReader in;

    public PropertyReader(Reader in, Collection collectXRefs, boolean useIndents) {
        this(new BufferedReader(in), (Collection<PropertyXRef>)collectXRefs, useIndents);
    }

    public PropertyReader(BufferedReader in, Collection<PropertyXRef> collectXRefs, boolean useIndents) {
        this.in = in;
        this.useIndents = useIndents;
        this.collectXRefs = collectXRefs;
    }

    public int getLines() {
        return this.lines;
    }

    public void read(Property prop) throws IOException {
        this.read(prop, -1);
    }

    public void read(Property prop, int index) throws IOException {
        this.readProperties(prop, 0, index);
        if (this.line != null) {
            this.line = null;
            this.in.reset();
        }
    }

    public void setMerge(boolean isMerge, boolean sameGedcom) {
        this.isMerge = isMerge;
        this.sameGedcom = sameGedcom;
    }

    protected void readProperties(Property prop, int currentLevel, int pos) throws IOException {
        if (prop instanceof MultiLineProperty) {
            MultiLineProperty.Collector collector = ((MultiLineProperty)((Object)prop)).getLineCollector();
            while (this.readLine(false, true) && this.level >= currentLevel + 1 && collector.append(this.level - currentLevel, this.tag, this.value)) {
                this.line = null;
            }
            prop.setValue(collector.getValue().replaceAll("@@", "@"));
        }
        while (this.readLine(false, true)) {
            if (this.level < currentLevel + 1) {
                return;
            }
            this.line = null;
            if (this.level > currentLevel + 1) {
                this.trackBadLevel(this.level, prop);
                for (int i = currentLevel; i < Math.min(this.level - 1, 20); ++i) {
                    prop = prop.addProperty("_LEVEL_PATCHED", "");
                }
            }
            int lineNoForChild = this.lines;
            String prevValue = this.value;
            String prevTag = this.tag;
            Property child = prevTag.equalsIgnoreCase("NAME") ? this.addProperty(prop, this.tag, "", pos) : this.addProperty(prop, this.tag, this.value, pos);
            if ("_LINE_PATCHED".equals(this.tag)) {
                this.trackInvalidLine(child);
            }
            this.readProperties(child, this.level, 0);
            if (prevTag.equalsIgnoreCase("NAME") || prevTag.equalsIgnoreCase("FILE")) {
                child.setValue(prevValue != null ? prevValue.replaceAll("@@", "@") : "");
                this.readProperties(child, this.level, 0);
            }
            if (child instanceof PropertyXRef) {
                this.link((PropertyXRef)child, lineNoForChild);
            }
            if (pos < 0) continue;
            ++pos;
        }
        return;
    }

    protected Property addProperty(Property prop, String tag, String localValue, int pos) {
        Property child;
        if (this.isMerge && (child = prop.getProperty(tag, false)) != null && !(child instanceof PropertyXRef)) {
            if (prop.getMetaProperty().getNested(tag, false).isSingleton()) {
                child.setValue(localValue);
                return child;
            }
            String oldValue = child.getValue();
            if (!this.sameGedcom && !this.value.isBlank()) {
                if (oldValue.isBlank()) {
                    return child;
                }
                if (child instanceof PropertyName) {
                    String newSurName;
                    PropertyName pName = (PropertyName)child;
                    String oldSurName = pName.getLastName();
                    String[] parts = this.value.split("/", -1);
                    String string = newSurName = parts.length > 1 ? parts[1] : "";
                    if (oldSurName.equals(newSurName)) {
                        String firstName = pName.getFirstName();
                        parts = firstName.split("\\s", -1);
                        boolean merge = true;
                        for (String part : parts) {
                            if (this.value.contains(part)) continue;
                            merge = false;
                            break;
                        }
                        if (merge) {
                            return child;
                        }
                    }
                } else if (oldValue.equals(this.value)) {
                    return child;
                }
            }
        }
        try {
            if (prop instanceof PropertyName) {
                Property p = prop.addProperty(tag, localValue, pos);
                p.setValue(localValue != null ? localValue.replaceAll("@@", "@") : "");
                return p;
            }
            return prop.addProperty(tag, localValue, pos);
        }
        catch (GedcomException e) {
            Property fallback = prop.addSimpleProperty(tag, localValue, pos);
            this.trackBadProperty(fallback, e.getMessage());
            return fallback;
        }
    }

    protected boolean readLine(boolean consume, boolean stopIfException) throws IOException {
        if (this.line == null) {
            while (this.line == null) {
                int i;
                this.line = this.in.readLine();
                if (this.line == null) {
                    return false;
                }
                ++this.lines;
                if (this.line.trim().isEmpty()) {
                    this.trackEmptyLine();
                    this.line = null;
                    continue;
                }
                if (this.useIndents) continue;
                for (i = 0; i < this.line.length() && Character.isWhitespace(this.line.charAt(i)); ++i) {
                }
                this.line = this.line.substring(i);
            }
            String[] splitLine = this.line.split("\\s", -1);
            int current_token = 0;
            try {
                try {
                    if (this.useIndents) {
                        this.level = 0;
                        while (this.line.charAt(this.level) == ' ') {
                            ++this.level;
                            ++current_token;
                        }
                        ++this.level;
                    } else {
                        this.level = Integer.parseInt(splitLine[current_token], 10);
                        ++current_token;
                    }
                }
                catch (NumberFormatException nfe) {
                    this.line = this.level + " _LINE_PATCHED " + this.line;
                    splitLine = this.line.split("\\s", -1);
                    ++current_token;
                }
                if (splitLine.length > 0) {
                    while (current_token < splitLine.length) {
                        this.tag = splitLine[current_token];
                        ++current_token;
                        if (this.tag == null || this.tag.isEmpty()) {
                            if (!this.tag.isEmpty()) continue;
                            this.tag = "_LINE_PATCHED";
                            continue;
                        }
                        break;
                    }
                } else {
                    this.tag = "_LINE_PATCHED";
                }
                if (this.level == 0 && this.tag.startsWith("@")) {
                    if (!this.tag.endsWith("@") || this.tag.length() <= 2) {
                        while (current_token < splitLine.length && !this.tag.endsWith("@")) {
                            this.tag = this.tag + " " + splitLine[current_token];
                            ++current_token;
                        }
                    }
                    if (!this.tag.endsWith("@") || this.tag.length() <= 2) {
                        throw new GedcomFormatException(RESOURCES.getString("read.error.invalidid"), this.lines);
                    }
                    this.xref = this.tag.substring(1, this.tag.length() - 1);
                    this.tag = splitLine[current_token];
                    ++current_token;
                    if (this.tag.equals("HEAD")) {
                        this.xref = "";
                    }
                } else {
                    this.xref = "";
                }
                if (current_token < splitLine.length) {
                    this.value = splitLine[current_token];
                    ++current_token;
                    while (current_token < splitLine.length) {
                        this.value = this.value + " " + splitLine[current_token];
                        ++current_token;
                    }
                } else {
                    this.value = "";
                }
            }
            catch (NoSuchElementException ex) {
                throw new GedcomFormatException(RESOURCES.getString("read.error.cantparse"), this.lines);
            }
            this.tag = this.tag.intern();
        }
        if (consume) {
            this.line = null;
        }
        return true;
    }

    protected void link(PropertyXRef xref, int line) {
        if (this.collectXRefs != null) {
            this.collectXRefs.add(xref);
        } else {
            try {
                xref.link();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void trackInvalidLine(Property prop) {
    }

    protected void trackEmptyLine() {
    }

    protected void trackBadLevel(int level, Property parent) {
    }

    protected void trackBadProperty(Property property, String message) {
    }
}

