/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Property;

public class Repository
extends Entity {
    public Repository(String tag, String id) {
        super(tag, id);
        this.assertTag("REPO");
    }

    @Override
    public boolean isValid() {
        return this.getValue().isEmpty();
    }

    @Override
    public void moveEntityValue() {
        String value = this.getValue();
        if (!value.isEmpty()) {
            if (this.getRepositoryName().isEmpty()) {
                this.setRepositoryName(value);
                this.setValue("");
            } else {
                super.moveEntityValue();
            }
        }
    }

    @Override
    protected String getToStringPrefix(boolean showIds) {
        return this.getRepositoryName();
    }

    @Override
    public String getDisplayTitle() {
        return this.getDisplayTitle(true);
    }

    @Override
    public String getDisplayTitle(boolean showIds) {
        int cut;
        int len;
        int maxLen = 30;
        String str = this.getRepositoryName().trim();
        if (!str.isEmpty() && maxLen != 0 && (len = str.length()) > maxLen && (cut = str.indexOf(" ", maxLen)) != -1) {
            str = str.substring(0, cut);
        }
        if (str.isEmpty()) {
            str = "?";
        }
        if (showIds) {
            return this.getId() + " - " + str;
        }
        return str;
    }

    public String getRepositoryName() {
        Property name = this.getProperty("NAME");
        return name != null ? name.getValue() : "";
    }

    public void setRepositoryName(String name) {
        Property property = this.getProperty("NAME");
        if (property == null) {
            property = this.addProperty("NAME", name);
        } else {
            property.setValue(name);
        }
    }

    public String getNote() {
        Property p = this.getProperty("NOTE");
        return p != null ? p.getValue() : "";
    }

    public String getSearchString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRepositoryName());
        sb.append(" ");
        sb.append(this.getNote());
        sb.append(" ");
        sb.append(this.getId());
        sb.append(" ");
        return sb.toString();
    }
}

