/*
 * Decompiled with CFR 0.152.
 */
package ancestris.view;

import ancestris.renderer.Renderer;
import genj.gedcom.Entity;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.plaf.ToolTipUI;
import javax.swing.text.html.HTMLDocument;
import org.openide.util.Exceptions;

public class TemplateToolTip
extends JToolTip {
    private Entity entity;
    private final JEditorPane theEditorPane;
    private final JScrollPane pane;
    private int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
    private static final int dismissDelayMinutes = (int)TimeUnit.MINUTES.toMillis(10L);
    Entity prevEntity = null;
    String prevTT = null;

    @Override
    public void addNotify() {
        super.addNotify();
        this.defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().setDismissDelay(this.defaultDismissTimeout);
    }

    public TemplateToolTip() {
        this.setLayout(new BorderLayout());
        LookAndFeel.installBorder(this, "ToolTip.border");
        LookAndFeel.installColors(this, "ToolTip.background", "ToolTip.foreground");
        this.theEditorPane = new JEditorPane();
        this.theEditorPane.setContentType("text/html");
        this.theEditorPane.setEditable(false);
        this.pane = new JScrollPane(this.theEditorPane);
        this.add(this.pane);
    }

    @Override
    public void setTipText(String tipText) {
        if (tipText != null && !tipText.equals(this.prevTT)) {
            String TPL = "ancestris/templates/" + this.entity.getTag() + "/popup";
            Renderer render = Renderer.Lookup.lookup(TPL);
            render.put("INDI", this.entity);
            render.put("FAM", this.entity);
            StringWriter w = new StringWriter();
            render.render(TPL, w);
            w.flush();
            String tt = w.toString();
            try {
                w.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.theEditorPane.setText(tt);
            this.prevTT = tipText;
        }
        try {
            if (this.entity != null) {
                ((HTMLDocument)this.theEditorPane.getDocument()).setBase(new URL(this.entity.getGedcom().getOrigin().toString()));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.theEditorPane.setCaretPosition(0);
        super.setTipText(tipText);
    }

    @Override
    public void updateUI() {
        this.setUI(new ToolTipUI(){});
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 400);
    }
}

