/*
 * Decompiled with CFR 0.152.
 */
package org.geonames;

import java.util.HashSet;
import java.util.Set;
import org.geonames.BoundingBox;
import org.geonames.FeatureClass;
import org.geonames.InvalidParameterException;
import org.geonames.Style;

public class ToponymSearchCriteria {
    private String q;
    private String countryCode;
    private Set<String> countryCodes;
    private String countryBias;
    private String continentCode;
    private String name;
    private String nameEquals;
    private String nameStartsWith;
    private String tag;
    private String language;
    private Style style;
    private FeatureClass featureClass;
    private String[] featureCodes;
    private String adminCode1;
    private String adminCode2;
    private String adminCode3;
    private String adminCode4;
    private int maxRows;
    private int startRow;
    private double fuzzy = 1.0;
    private BoundingBox boundingBox;

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) throws InvalidParameterException {
        if (countryCode != null && countryCode.length() != 2) {
            throw new InvalidParameterException("invalid country code " + countryCode);
        }
        this.countryCode = countryCode;
    }

    public void addCountryCode(String countryCode) throws InvalidParameterException {
        if (countryCode != null && countryCode.length() != 2) {
            throw new InvalidParameterException("invalid country code " + countryCode);
        }
        if (this.countryCodes == null) {
            this.countryCodes = new HashSet<String>();
        }
        this.countryCodes.add(countryCode);
    }

    public Set<String> getCountryCodes() {
        return this.countryCodes;
    }

    public void setCountryCodes(Set<String> countryCodes) {
        this.countryCodes = countryCodes;
    }

    public String getCountryBias() {
        return this.countryBias;
    }

    public void setCountryBias(String countryBias) {
        this.countryBias = countryBias;
    }

    public String getContinentCode() {
        return this.continentCode;
    }

    public void setContinentCode(String continentCode) {
        this.continentCode = continentCode;
    }

    public String getNameEquals() {
        return this.nameEquals;
    }

    public void setNameEquals(String exactName) {
        this.nameEquals = exactName;
    }

    public String[] getFeatureCodes() {
        return this.featureCodes;
    }

    public void setFeatureCodes(String[] featureCodes) {
        this.featureCodes = featureCodes;
    }

    public void setFeatureCode(String featureCode) {
        this.featureCodes = new String[]{featureCode};
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getNameStartsWith() {
        return this.nameStartsWith;
    }

    public void setNameStartsWith(String nameStartsWith) {
        this.nameStartsWith = nameStartsWith;
    }

    public FeatureClass getFeatureClass() {
        return this.featureClass;
    }

    public void setFeatureClass(FeatureClass featureClass) {
        this.featureClass = featureClass;
    }

    public String getAdminCode1() {
        return this.adminCode1;
    }

    public void setAdminCode1(String adminCode1) {
        this.adminCode1 = adminCode1;
    }

    public String getAdminCode2() {
        return this.adminCode2;
    }

    public void setAdminCode2(String adminCode2) {
        this.adminCode2 = adminCode2;
    }

    public String getAdminCode3() {
        return this.adminCode3;
    }

    public void setAdminCode3(String adminCode3) {
        this.adminCode3 = adminCode3;
    }

    public String getAdminCode4() {
        return this.adminCode4;
    }

    public void setAdminCode4(String adminCode4) {
        this.adminCode4 = adminCode4;
    }

    public double getFuzzy() {
        return this.fuzzy;
    }

    public void setFuzzy(double fuzzy) {
        this.fuzzy = fuzzy;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }
}

