/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.search;

import ancestris.modules.releve.MenuCommandProvider;
import ancestris.modules.releve.file.FileExtensionFilter;
import ancestris.modules.releve.file.FileManager;
import ancestris.modules.releve.file.ReleveFileExport;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.BeanField;
import ancestris.modules.releve.model.BeanGroup;
import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.model.Field;
import ancestris.modules.releve.model.FieldDate;
import ancestris.modules.releve.model.FieldSex;
import ancestris.modules.releve.model.FieldSimpleValue;
import ancestris.modules.releve.model.RecordModelAbstract;
import ancestris.modules.releve.search.ResultBuffer;
import ancestris.modules.releve.table.ColumnGroup;
import ancestris.modules.releve.table.GroupableTableColumnModel;
import ancestris.modules.releve.table.GroupableTableHeader;
import ancestris.modules.releve.table.TableModelRecordCheck;
import ancestris.util.swing.FileChooserBuilder;
import genj.util.WordBuffer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.oxbow.swingbits.table.filter.TableRowFilterSupport;

public class SearchDialog
extends JFrame {
    static SearchDialog dialog = null;
    private MenuCommandProvider menuCommandeProvider;
    private DataManager dataManager;
    private TableModelRecordCheck checkModel;
    private ResultBuffer resultBuffer;
    JScrollPane jScrollPane1;
    JTableRowHeader jTableRowHeader;
    JTableResult jTableResult;
    OutputTableModel outputModel = new OutputTableModel();
    RowHeaderModel rowHeaderModel = new RowHeaderModel();
    private int[] columnWidth;
    private JButton jButtonClear;
    private JButton jButtonFind;
    private JButton jButtonStandalone;
    private JCheckBoxMenuItem jCheckBoxMenuMaskEmptyColumn;
    private JCheckBoxMenuItem jCheckBoxMenuShowAlwaysAllData;
    private JLabel jLabelResult;
    private JList<ResultBuffer.ResultItem> jListResult;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenu jMenuDisplay;
    private JMenuItem jMenuItemExport;
    private JPanel jPanelMain;
    private JPanel jPanelMenu;
    private JPanel jPanelResult;
    private JScrollPane jScrollPaneResult;
    private JTextField jTextFieldFind;

    public static SearchDialog show(Frame parent, MenuCommandProvider menuCommandeProvider, DataManager dataManager, ResultBuffer resultBuffer, File outputFile) {
        if (dialog == null) {
            dialog = new SearchDialog(parent);
            dialog.setLocationRelativeTo(null);
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            String size = NbPreferences.forModule(SearchDialog.class).get("ResultDialogBounds", "600,400,0,0");
            String[] dimensions = size.split(",");
            if (dimensions.length >= 4) {
                int width = Integer.parseInt(dimensions[0]);
                int height = Integer.parseInt(dimensions[1]);
                int x = Integer.parseInt(dimensions[2]);
                int y = Integer.parseInt(dimensions[3]);
                if (width < 100) {
                    width = 100;
                }
                if (height < 100) {
                    height = 100;
                }
                if (x < 10 || x > screen.width - 10) {
                    x = screen.width / 2 - width / 2;
                }
                if (y < 10 || y > screen.height - 10) {
                    y = screen.height / 2 - height / 2;
                }
                dialog.setBounds(x, y, width, height);
            } else {
                dialog.setBounds(screen.width / 2 - 100, screen.height / 2 - 100, 300, 450);
            }
            dialog.setDefaultCloseOperation(0);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    SearchDialog.closeComponent();
                }
            });
        } else {
            dialog.toFront();
        }
        dialog.initData(menuCommandeProvider, dataManager, resultBuffer, outputFile);
        dialog.setVisible(true);
        return dialog;
    }

    public SearchDialog(Frame parent) {
        this.initComponents();
        ImageIcon icon = new ImageIcon(SearchDialog.class.getResource("/ancestris/modules/releve/images/Search.png"));
        this.setIconImage(icon.getImage());
    }

    protected static void closeComponent() {
        if (dialog.getExtendedState() != 0) {
            dialog.setExtendedState(0);
        }
        Rectangle bounds = dialog.getBounds();
        String size = String.valueOf((int)bounds.getWidth()) + "," + String.valueOf((int)bounds.getHeight()) + "," + String.valueOf(bounds.getLocation().x + "," + String.valueOf(bounds.getLocation().y));
        NbPreferences.forModule(SearchDialog.class).put("ResultDialogBounds", size);
        dialog.saveColumnLayout();
        dialog.setVisible(false);
        dialog.dispose();
    }

    private void initData(MenuCommandProvider menuCommandeProvider, DataManager dataManager, final ResultBuffer resultBuffer, File outputFile) {
        this.menuCommandeProvider = menuCommandeProvider;
        this.dataManager = dataManager;
        this.checkModel = new TableModelRecordCheck(dataManager.getDataModel());
        this.resultBuffer = resultBuffer;
        if (outputFile != null) {
            this.setTitle(outputFile.getName());
        }
        if (this.jScrollPane1 != null) {
            this.jPanelMain.remove(this.jScrollPane1);
        }
        this.columnWidth = new int[this.outputModel.getColumnCount()];
        RowFilter<OutputTableModel, Integer> checkFilter = new RowFilter<OutputTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends OutputTableModel, ? extends Integer> entry) {
                if (SearchDialog.this.jCheckBoxMenuShowAlwaysAllData.getState() || SearchDialog.this.jTextFieldFind.getText().isEmpty()) {
                    return true;
                }
                return resultBuffer.hasResult(entry.getIdentifier());
            }
        };
        TableRowSorter<OutputTableModel> checkSorter = new TableRowSorter<OutputTableModel>(this.outputModel);
        checkSorter.setRowFilter(checkFilter);
        this.jTableResult = new JTableResult();
        this.jTableResult.setColumnModel(new GroupableTableColumnModel());
        this.jTableResult.setTableHeader(new GroupableTableHeader((GroupableTableColumnModel)this.jTableResult.getColumnModel()));
        this.jTableResult.setModel(this.outputModel);
        TableRowFilterSupport tableRowFilterSupport = TableRowFilterSupport.forTable(this.jTableResult);
        tableRowFilterSupport.apply();
        this.jTableResult.setRowSorter(checkSorter);
        this.loadColumnLayout();
        GroupableTableColumnModel cm = (GroupableTableColumnModel)this.jTableResult.getColumnModel();
        int col = 1;
        for (BeanGroup beanGroup : BeanGroup.getGroups(AbstractRecord.RecordType.MISC)) {
            ColumnGroup columnGroup = new ColumnGroup(beanGroup.getTitle());
            for (BeanField beanField : beanGroup.getFields()) {
                columnGroup.add(cm.getColumn(col));
                ++col;
            }
            cm.addColumnGroup(columnGroup);
        }
        this.jTableRowHeader = new JTableRowHeader(this.rowHeaderModel);
        this.jTableResult.setRowSorter(checkSorter);
        this.jTableRowHeader.setRowSorter(this.jTableResult.getRowSorter());
        this.jScrollPane1 = new JScrollPane(this.jTableResult);
        JViewport viewport = new JViewport();
        viewport.setView(this.jTableRowHeader);
        viewport.setPreferredSize(this.jTableRowHeader.getPreferredSize());
        this.jScrollPane1.setRowHeaderView(viewport);
        this.jScrollPane1.setCorner("UPPER_LEFT_CORNER", this.jTableRowHeader.getTableHeader());
        this.jPanelMain.add((Component)this.jScrollPane1, "Center");
        if (this.jCheckBoxMenuMaskEmptyColumn.getState()) {
            this.hideEmptyColumns(false);
            this.hideEmptyColumns(true);
        }
        this.jLabelResult.setText(resultBuffer.getResultText());
        this.jListResult.setListData((ResultBuffer.ResultItem[])resultBuffer.getResults());
    }

    private void synchronizeSelection(boolean isHeaderTable) {
        int selectedIndex;
        int fixedSelectedIndex = this.jTableRowHeader.getSelectedRow();
        if (fixedSelectedIndex != (selectedIndex = this.jTableResult.getSelectedRow())) {
            if (isHeaderTable) {
                if (fixedSelectedIndex != -1) {
                    this.jTableResult.setRowSelectionInterval(fixedSelectedIndex, fixedSelectedIndex);
                } else {
                    this.jTableResult.clearSelection();
                }
            } else if (selectedIndex != -1) {
                this.jTableRowHeader.setRowSelectionInterval(selectedIndex, selectedIndex);
            } else {
                this.jTableRowHeader.clearSelection();
            }
        }
    }

    protected void loadColumnLayout() {
        if (this.jTableResult.getModel() != null) {
            String columnLayout = NbPreferences.forModule(SearchDialog.class).get("ResultDialogColumnLayout", "0");
            StringTokenizer tokens = new StringTokenizer(columnLayout, ",");
            int n = Integer.parseInt(tokens.nextToken());
            TableColumnModel columns = this.jTableResult.getColumnModel();
            for (int i = 0; i < n && i < columns.getColumnCount(); ++i) {
                TableColumn col = columns.getColumn(i);
                int w = Integer.parseInt(tokens.nextToken());
                if (i == 0) {
                    col.setMaxWidth(0);
                    col.setMinWidth(0);
                    col.setWidth(0);
                    col.setPreferredWidth(0);
                    col.setResizable(false);
                    continue;
                }
                col.setWidth(w);
                col.setPreferredWidth(w);
                col.setResizable(true);
            }
        }
    }

    protected void saveColumnLayout() {
        if (this.jTableResult.getModel() != null) {
            TableColumnModel columns = this.jTableResult.getColumnModel();
            WordBuffer columnLayout = new WordBuffer(",");
            columnLayout.append(columns.getColumnCount());
            for (int c = 0; c < columns.getColumnCount(); ++c) {
                if (this.columnWidth[c] != 0) {
                    columnLayout.append(this.columnWidth[c]);
                    continue;
                }
                columnLayout.append(columns.getColumn(c).getWidth());
            }
            NbPreferences.forModule(SearchDialog.class).put("ResultDialogColumnLayout", columnLayout.toString());
        }
    }

    protected void hideEmptyColumns(boolean hide) {
        if (hide) {
            for (int col = 1; col < this.jTableResult.getColumnCount(); ++col) {
                boolean emptyCol = true;
                for (int row = 0; row < this.outputModel.getRowCount(); ++row) {
                    if (this.outputModel.getValueAt(row, col).toString().isEmpty()) continue;
                    emptyCol = false;
                    break;
                }
                if (!emptyCol) continue;
                TableColumn column = this.jTableResult.getColumnModel().getColumn(col);
                this.columnWidth[col] = column.getPreferredWidth();
                column.setMinWidth(0);
                column.setPreferredWidth(0);
            }
        } else {
            for (int col = 1; col < this.jTableResult.getColumnCount(); ++col) {
                if (this.columnWidth[col] == 0) continue;
                TableColumn column = this.jTableResult.getColumnModel().getColumn(col);
                column.setPreferredWidth(this.columnWidth[col]);
                column.setMinWidth(15);
                this.columnWidth[col] = 0;
            }
        }
    }

    protected void findString(AbstractTableModel fileBuffer, String findValue, ResultBuffer resultBuffer) {
        resultBuffer.removeAll();
        if (!findValue.isEmpty()) {
            GroupableTableColumnModel cm = (GroupableTableColumnModel)this.jTableResult.getColumnModel();
            for (int row = 0; row < fileBuffer.getRowCount(); ++row) {
                for (int col = 0; col < fileBuffer.getColumnCount(); ++col) {
                    String svalue = fileBuffer.getValueAt(row, col).toString();
                    if (!svalue.contains(findValue)) continue;
                    Iterator<TableColumn> gourpIter = cm.getColumnGroups(cm.getColumn(col + 1));
                    Object message = "";
                    while (gourpIter.hasNext()) {
                        ColumnGroup columnGroup = (ColumnGroup)gourpIter.next();
                        message = (String)message + columnGroup.getHeaderValue().toString() + " ";
                    }
                    message = (String)message + fileBuffer.getColumnName(col);
                    resultBuffer.addResult(row, col, (String)message);
                }
            }
        }
        if (this.outputModel.getRowCount() > 0) {
            this.outputModel.fireTableDataChanged();
            this.rowHeaderModel.fireTableDataChanged();
        }
        this.jLabelResult.setText(resultBuffer.getResultText());
        this.jListResult.setListData((ResultBuffer.ResultItem[])resultBuffer.getResults());
    }

    protected void exportFile() {
        JPanel panelExport = new JPanel();
        JPanel jPanelFormat = new JPanel();
        JRadioButton jRadioButtonEgmt = new JRadioButton();
        JRadioButton jRadioButtonNimegue = new JRadioButton();
        JRadioButton jRadioButtonHtml = new JRadioButton();
        JRadioButton jRadioButtonPdf = new JRadioButton();
        ButtonGroup buttonGroupFormat = new ButtonGroup();
        buttonGroupFormat.add(jRadioButtonEgmt);
        buttonGroupFormat.add(jRadioButtonNimegue);
        buttonGroupFormat.add(jRadioButtonHtml);
        buttonGroupFormat.add(jRadioButtonPdf);
        JRadioButton jRadioButtonAll = new JRadioButton();
        JRadioButton jRadioButtonBirth = new JRadioButton();
        JRadioButton jRadioButtonMarriage = new JRadioButton();
        JRadioButton jRadioButtonDeath = new JRadioButton();
        JRadioButton jRadioButtonMisc = new JRadioButton();
        ButtonGroup buttonGroupModel = new ButtonGroup();
        buttonGroupModel.add(jRadioButtonAll);
        buttonGroupModel.add(jRadioButtonBirth);
        buttonGroupModel.add(jRadioButtonMarriage);
        buttonGroupModel.add(jRadioButtonDeath);
        buttonGroupModel.add(jRadioButtonMisc);
        JPanel jPanelModel = new JPanel();
        panelExport.setLayout(new GridBagLayout());
        jPanelFormat.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jPanelFormat.border.title")));
        jPanelFormat.setLayout(new GridLayout(2, 1, 2, 2));
        jRadioButtonEgmt.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonEgmt.text"));
        jPanelFormat.add(jRadioButtonEgmt);
        jRadioButtonNimegue.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonNimegue.text"));
        jPanelFormat.add(jRadioButtonNimegue);
        jRadioButtonHtml.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonHtml.text"));
        jPanelFormat.add(jRadioButtonHtml);
        jRadioButtonPdf.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonPdf.text"));
        jPanelFormat.add(jRadioButtonPdf);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        panelExport.add((Component)jPanelFormat, gridBagConstraints);
        jPanelModel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jPanelModel.border.title")));
        jPanelModel.setLayout(new GridLayout(5, 1, 2, 2));
        jRadioButtonAll.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonAll.text"));
        jPanelModel.add(jRadioButtonAll);
        jRadioButtonBirth.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonBirth.text"));
        jPanelModel.add(jRadioButtonBirth);
        jRadioButtonMarriage.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonMarriage.text"));
        jPanelModel.add(jRadioButtonMarriage);
        jRadioButtonDeath.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonDeath.text"));
        jPanelModel.add(jRadioButtonDeath);
        jRadioButtonMisc.setText(NbBundle.getMessage(ReleveFileExport.class, (String)"ReleveFileExport.jRadioButtonMisc.text"));
        jPanelModel.add(jRadioButtonMisc);
        FileChooserBuilder fcb = new FileChooserBuilder(SearchDialog.class);
        ActionListener rbActionListener = evt -> {
            String extension = "txt";
            String recordType = jRadioButtonAll.isSelected() ? "" : (jRadioButtonBirth.isSelected() ? "_B" : (jRadioButtonMarriage.isSelected() ? "_M" : (jRadioButtonDeath.isSelected() ? "_D" : (jRadioButtonMisc.isSelected() ? "_V" : ""))));
            String format = "";
            if (jRadioButtonEgmt.isSelected()) {
                format = "_EGMT";
                extension = "csv";
            } else if (jRadioButtonNimegue.isSelected()) {
                format = "_NIMEGUE";
                extension = "txt";
            } else if (jRadioButtonHtml.isSelected()) {
                format = "";
                extension = "html";
            } else if (jRadioButtonPdf.isSelected()) {
                format = "";
                extension = "pdf";
            }
            String defaultFileName = "export" + recordType + format + "." + extension;
            fcb.setDefaultExtension(extension);
            fcb.setSelectedFile(new File(defaultFileName));
            fcb.forceSelectedFile(new File(defaultFileName));
            fcb.forceFileFilter((FileFilter)new FileExtensionFilter(extension));
        };
        jRadioButtonEgmt.addActionListener(rbActionListener);
        jRadioButtonNimegue.addActionListener(rbActionListener);
        jRadioButtonHtml.addActionListener(rbActionListener);
        jRadioButtonPdf.addActionListener(rbActionListener);
        jRadioButtonAll.addActionListener(rbActionListener);
        jRadioButtonBirth.addActionListener(rbActionListener);
        jRadioButtonMarriage.addActionListener(rbActionListener);
        jRadioButtonDeath.addActionListener(rbActionListener);
        jRadioButtonMisc.addActionListener(rbActionListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        panelExport.add((Component)jPanelModel, gridBagConstraints);
        jRadioButtonEgmt.setSelected(true);
        jRadioButtonAll.setSelected(true);
        rbActionListener.actionPerformed(new ActionEvent(this, 1001, null){});
        fcb.setDefaultExtension("csv").setFileFilter((FileFilter)new FileExtensionFilter("csv")).setAccessory((JComponent)panelExport).setDefaultWorkingDirectory(FileManager.getPreferredDir()).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(this.getClass(), (String)"SearchDialog.jMenuItemExport.text")).setApproveText(NbBundle.getMessage(this.getClass(), (String)"SearchDialog.jMenuItemExport.text")).setFileHiding(true).setAcceptAllFileFilterUsed(false);
        File file = fcb.showSaveDialog();
        if (file != null) {
            FileManager.putPreferredDir(file.getParentFile());
            FileManager.FileFormat fileFormat = FileManager.FileFormat.FILE_TYPE_UNKNOW;
            if (jRadioButtonEgmt.isSelected()) {
                fileFormat = FileManager.FileFormat.FILE_TYPE_EGMT;
            } else if (jRadioButtonNimegue.isSelected()) {
                fileFormat = FileManager.FileFormat.FILE_TYPE_NIMEGUE;
            } else if (jRadioButtonHtml.isSelected()) {
                fileFormat = FileManager.FileFormat.FILE_TYPE_HTML;
            } else if (jRadioButtonPdf.isSelected()) {
                fileFormat = FileManager.FileFormat.FILE_TYPE_PDF;
            }
            RecordModelAbstract filteredRecordModel = new RecordModelAbstract(){

                @Override
                public int getRowCount() {
                    return SearchDialog.this.jTableResult.getRowCount();
                }

                @Override
                public AbstractRecord getRecord(int index) {
                    return SearchDialog.this.outputModel.getRecord(SearchDialog.this.jTableResult.convertRowIndexToModel(index));
                }
            };
            StringBuilder saveResult = new StringBuilder();
            AbstractRecord.RecordType recordType = jRadioButtonBirth.isSelected() ? AbstractRecord.RecordType.BIRTH : (jRadioButtonMarriage.isSelected() ? AbstractRecord.RecordType.MARRIAGE : (jRadioButtonDeath.isSelected() ? AbstractRecord.RecordType.DEATH : (jRadioButtonMisc.isSelected() ? AbstractRecord.RecordType.MISC : null)));
            FileManager.saveFile(file, fileFormat, filteredRecordModel, recordType);
            if (!saveResult.toString().isEmpty()) {
                String message = saveResult.toString();
                JOptionPane.showMessageDialog(this, message, NbBundle.getMessage(this.getClass(), (String)"SearchDialog.jMenuItemExport.text"), 0);
            }
        }
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jPanelMenu = new JPanel();
        this.jButtonFind = new JButton();
        this.jTextFieldFind = new JTextField();
        this.jButtonClear = new JButton();
        this.jButtonStandalone = new JButton();
        this.jPanelResult = new JPanel();
        this.jLabelResult = new JLabel();
        this.jScrollPaneResult = new JScrollPane();
        this.jListResult = new JList();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItemExport = new JMenuItem();
        this.jMenuDisplay = new JMenu();
        this.jCheckBoxMenuMaskEmptyColumn = new JCheckBoxMenuItem();
        this.jCheckBoxMenuShowAlwaysAllData = new JCheckBoxMenuItem();
        this.setDefaultCloseOperation(2);
        this.jPanelMain.setLayout(new BorderLayout());
        this.jPanelMenu.setPreferredSize(new Dimension(400, 28));
        this.jPanelMenu.setLayout(new FlowLayout(0, 5, 0));
        this.jButtonFind.setText(NbBundle.getMessage(SearchDialog.class, (String)"SearchDialog.jButtonFind.text"));
        this.jButtonFind.setPreferredSize(null);
        this.jButtonFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.jButtonFindActionPerformed(evt);
            }
        });
        this.jPanelMenu.add(this.jButtonFind);
        this.jTextFieldFind.setPreferredSize(new Dimension(100, 28));
        this.jTextFieldFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.jTextFieldFindActionPerformed(evt);
            }
        });
        this.jPanelMenu.add(this.jTextFieldFind);
        this.jButtonClear.setText(NbBundle.getMessage(SearchDialog.class, (String)"SearchDialog.jButtonClear.text"));
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.jButtonClearActionPerformed(evt);
            }
        });
        this.jPanelMenu.add(this.jButtonClear);
        this.jButtonStandalone.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Camera.png")));
        this.jButtonStandalone.setToolTipText(NbBundle.getMessage(SearchDialog.class, (String)"SearchDialog.jButtonStandalone.toolTipText"));
        this.jButtonStandalone.setMargin(new Insets(0, 4, 0, 4));
        this.jButtonStandalone.setMaximumSize(new Dimension(29, 18));
        this.jButtonStandalone.setPreferredSize(new Dimension(50, 28));
        this.jButtonStandalone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.jButtonStandaloneActionPerformed(evt);
            }
        });
        this.jPanelMenu.add(this.jButtonStandalone);
        this.jPanelMain.add((Component)this.jPanelMenu, "North");
        this.jPanelResult.setBorder(BorderFactory.createBevelBorder(0));
        this.jPanelResult.setLayout(new BorderLayout());
        this.jPanelResult.add((Component)this.jLabelResult, "North");
        this.jListResult.setSelectionMode(0);
        this.jListResult.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SearchDialog.this.jListResultValueChanged(evt);
            }
        });
        this.jScrollPaneResult.setViewportView(this.jListResult);
        this.jPanelResult.add((Component)this.jScrollPaneResult, "Center");
        this.jPanelMain.add((Component)this.jPanelResult, "South");
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        this.jMenu1.setText(NbBundle.getMessage(SearchDialog.class, (String)"SearchDialog.jMenu1.text"));
        this.jMenuItemExport.setText(NbBundle.getMessage(SearchDialog.class, (String)"SearchDialog.jMenuItemExport.text"));
        this.jMenuItemExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.jMenuItemExportActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItemExport);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuDisplay.setText(NbBundle.getMessage(SearchDialog.class, (String)"SearchDialog.jMenuDisplay.text"));
        this.jCheckBoxMenuMaskEmptyColumn.setText(NbBundle.getMessage(SearchDialog.class, (String)"SearchDialog.jCheckBoxMenuMaskEmptyColumn.text"));
        this.jCheckBoxMenuMaskEmptyColumn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SearchDialog.this.jCheckBoxMenuMaskEmptyColumnItemStateChanged(evt);
            }
        });
        this.jMenuDisplay.add(this.jCheckBoxMenuMaskEmptyColumn);
        this.jCheckBoxMenuShowAlwaysAllData.setText(NbBundle.getMessage(SearchDialog.class, (String)"SearchDialog.jCheckBoxMenuShowAlwaysAllData.text"));
        this.jCheckBoxMenuShowAlwaysAllData.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SearchDialog.this.jCheckBoxMenuShowAlwaysAllDataItemStateChanged(evt);
            }
        });
        this.jCheckBoxMenuShowAlwaysAllData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.jCheckBoxMenuShowAlwaysAllDataActionPerformed(evt);
            }
        });
        this.jMenuDisplay.add(this.jCheckBoxMenuShowAlwaysAllData);
        this.jMenuBar1.add(this.jMenuDisplay);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jListResultValueChanged(ListSelectionEvent evt) {
        ResultBuffer.ResultItem result;
        int resultIndex = evt.getFirstIndex();
        if (resultIndex != -1 && this.jTableResult.getSelectionModel() != null && (result = this.jListResult.getSelectedValue()) != null) {
            int rowtableIndex = this.jTableResult.convertRowIndexToView(result.row);
            this.jTableResult.getSelectionModel().setSelectionInterval(rowtableIndex, rowtableIndex);
            this.jTableResult.scrollRectToVisible(this.jTableResult.getCellRect(rowtableIndex, 0, false));
        }
    }

    private void jCheckBoxMenuMaskEmptyColumnItemStateChanged(ItemEvent evt) {
        this.hideEmptyColumns(this.jCheckBoxMenuMaskEmptyColumn.getState());
    }

    private void jCheckBoxMenuShowAlwaysAllDataItemStateChanged(ItemEvent evt) {
        this.outputModel.fireTableDataChanged();
        this.rowHeaderModel.fireTableDataChanged();
    }

    private void jButtonStandaloneActionPerformed(ActionEvent evt) {
        int row = this.jTableResult.getSelectedRow();
        if (row != -1) {
            int panelIndex = 4;
            this.menuCommandeProvider.showRecord(panelIndex, this.jTableResult.convertRowIndexToModel(row));
        }
    }

    private void jButtonFindActionPerformed(ActionEvent evt) {
        this.findString(this.checkModel, this.jTextFieldFind.getText(), this.resultBuffer);
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.resultBuffer.removeAll();
        this.jTextFieldFind.setText("");
        this.outputModel.fireTableDataChanged();
        this.rowHeaderModel.fireTableDataChanged();
        this.jLabelResult.setText(this.resultBuffer.getResultText());
        this.jListResult.setListData((ResultBuffer.ResultItem[])this.resultBuffer.getResults());
    }

    private void jMenuItemExportActionPerformed(ActionEvent evt) {
        this.exportFile();
    }

    private void jTextFieldFindActionPerformed(ActionEvent evt) {
        this.findString(this.checkModel, this.jTextFieldFind.getText(), this.resultBuffer);
    }

    private void jCheckBoxMenuShowAlwaysAllDataActionPerformed(ActionEvent evt) {
    }

    private class OutputTableModel
    extends AbstractTableModel {
        private OutputTableModel() {
        }

        AbstractRecord getRecord(int index) {
            return SearchDialog.this.checkModel.getRecord(index);
        }

        @Override
        public int getColumnCount() {
            return SearchDialog.this.checkModel.getColumnCount() + 1;
        }

        @Override
        public int getRowCount() {
            return SearchDialog.this.checkModel.getRowCount();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "";
            }
            return SearchDialog.this.checkModel.getColumnName(col - 1);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Integer.class;
            }
            return SearchDialog.this.checkModel.getColumnClass(col - 1);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return row + 1;
            }
            return SearchDialog.this.checkModel.getValueAt(row, col - 1);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col != 0 && value != null) {
                SearchDialog.this.checkModel.setValueAt(value, row + 1, col - 1);
            }
        }
    }

    private class RowHeaderModel
    extends AbstractTableModel {
        private RowHeaderModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return SearchDialog.this.checkModel.getRowCount();
        }

        @Override
        public String getColumnName(int col) {
            return "#";
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return row + 1;
        }
    }

    public class JTableResult
    extends JTable {
        JTableResult() {
            this.setAutoResizeMode(0);
            this.setSelectionMode(0);
            this.getTableHeader().setReorderingAllowed(false);
            this.setAutoCreateRowSorter(false);
            this.setDefaultRenderer(Field.class, new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focs, int row, int col) {
                    Object toolTipText;
                    this.setHorizontalAlignment(2);
                    if (value != null) {
                        if (value instanceof FieldDate) {
                            this.setText(((FieldDate)value).getDisplayValue());
                            this.setHorizontalAlignment(4);
                        } else if (value instanceof FieldSex) {
                            this.setText(((FieldSex)value).toString());
                            this.setHorizontalAlignment(0);
                        } else if (value instanceof FieldSimpleValue) {
                            this.setText(((FieldSimpleValue)value).toString());
                            this.setHorizontalAlignment(2);
                        } else {
                            this.setText(value.toString());
                            this.setHorizontalAlignment(2);
                        }
                    } else {
                        this.setText("");
                        this.setHorizontalAlignment(2);
                    }
                    ResultBuffer.ResultItem[] results = SearchDialog.this.resultBuffer.getResult(table.convertRowIndexToModel(row), table.convertColumnIndexToModel(col - 1));
                    if (results.length > 0) {
                        toolTipText = "<html>";
                        for (int i = 0; i < results.length; ++i) {
                            if (i >= 1) {
                                toolTipText = (String)toolTipText + "<br>";
                            }
                            toolTipText = (String)toolTipText + results[i].message;
                        }
                        toolTipText = (String)toolTipText + "</html>";
                    } else {
                        toolTipText = null;
                    }
                    this.setToolTipText((String)toolTipText);
                    if (selected) {
                        if (results.length > 0) {
                            this.setForeground(table.getSelectionForeground());
                            this.setBackground(Color.MAGENTA);
                        } else {
                            this.setForeground(table.getSelectionForeground());
                            this.setBackground(table.getSelectionBackground());
                        }
                        this.setOpaque(true);
                    } else {
                        if (results.length > 0) {
                            this.setForeground(table.getForeground());
                            this.setBackground(Color.PINK);
                        } else {
                            this.setForeground(table.getForeground());
                            this.setBackground(table.getBackground());
                        }
                        this.setOpaque(true);
                    }
                    return this;
                }
            });
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            SearchDialog.this.synchronizeSelection(false);
        }

        @Override
        public void sorterChanged(RowSorterEvent e) {
            super.sorterChanged(e);
            Object m = ((RowSorter)e.getSource()).getModel();
            if (m instanceof TableModel) {
                Object rs = e.getSource();
                SearchDialog.this.jTableRowHeader.setRowSorter((RowSorter<? extends TableModel>)rs);
            }
        }

        @Override
        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
            ResultBuffer.ResultItem resultItems = SearchDialog.this.jListResult.getSelectedValue();
            if (resultItems != null && resultItems.row != SearchDialog.this.jTableResult.getSelectedRow()) {
                SearchDialog.this.jListResult.clearSelection();
            }
        }
    }

    public class JTableRowHeader
    extends JTable {
        JTableRowHeader(TableModel model) {
            super(model);
            this.setAutoResizeMode(0);
            this.setSelectionMode(0);
            this.getTableHeader().setReorderingAllowed(false);
            TableColumnModel columns = this.getColumnModel();
            columns.getColumn(0).setResizable(false);
            columns.getColumn(0).setPreferredWidth(36);
            this.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focs, int row, int col) {
                    this.setHorizontalAlignment(0);
                    if (value != null) {
                        this.setText(value.toString());
                    } else {
                        this.setText("");
                    }
                    boolean hasError = SearchDialog.this.resultBuffer.hasResult(table.convertRowIndexToModel(row));
                    if (selected) {
                        this.setForeground(table.getSelectionForeground());
                        if (hasError) {
                            this.setBackground(Color.MAGENTA);
                        } else {
                            this.setBackground(table.getSelectionBackground());
                        }
                        this.setOpaque(true);
                    } else {
                        this.setForeground(table.getForeground());
                        if (hasError) {
                            this.setBackground(Color.PINK);
                        } else {
                            this.setBackground(table.getParent().getBackground());
                        }
                        this.setOpaque(true);
                    }
                    return this;
                }
            });
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            SearchDialog.this.synchronizeSelection(true);
        }
    }
}

