/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.imageBrowser;

import ancestris.gedcom.GedcomDirectory;
import ancestris.modules.releve.editor.BeanEventTag;
import ancestris.modules.releve.editor.MainPanelTranscriber;
import ancestris.modules.releve.imageBrowser.BrowserOptionsPanel;
import ancestris.modules.releve.imageBrowser.LLMResponseHandler;
import ancestris.modules.releve.imageBrowser.ProgressBarPanel;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.usage.UsageManager;
import ancestris.util.TimingUtility;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.PropertyPlace;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LLMService {
    private static final Logger LOG = Logger.getLogger("ancestris.app.releve.LLMService", null);
    private MainPanelTranscriber transcriber = null;
    private TimingUtility tu;

    public LLMService() {
        this.tu = new TimingUtility();
    }

    public LLMService(MainPanelTranscriber transcriber) {
        this.transcriber = transcriber;
        this.tu = new TimingUtility();
    }

    public void call_LLM_OCR(final String base64Image, String bearer, final boolean isPdf, final LLMResponseHandler handler) throws IOException, InterruptedException, ExecutionException {
        String userBearer = null;
        if (bearer == null) {
            bearer = this.getAncestrisBearer();
        } else {
            userBearer = bearer;
        }
        if (bearer == null) {
            this.process_LLM_Response_OCR(null, base64Image, null, isPdf, handler);
            return;
        }
        String language = Locale.getDefault().getDisplayLanguage();
        String apiUrl = "https://api.mistral.ai/v1/ocr";
        String api_type = "image_url";
        String api_data = "image/jpeg";
        if (isPdf) {
            api_type = "document_url";
            api_data = "application/pdf";
        }
        String requestBody = "{\"model\": \"mistral-ocr-latest\",\"document\": {\"type\": \"" + api_type + "\",\"" + api_type + "\": \"data:" + api_data + ";base64," + base64Image + "\"},\"include_image_base64\": true}";
        final HttpClient client = HttpClient.newHttpClient();
        final HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "Bearer " + bearer).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        ProgressBarPanel progressBar = new ProgressBarPanel();
        String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.inprogress");
        final DialogManager.ADialog dialog = DialogManager.create((String)title, (JComponent)progressBar, (boolean)false);
        dialog.setOptionType(10);
        dialog.show();
        final String finalBearer = userBearer;
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            String responseBody = "aborted";

            @Override
            protected Void doInBackground() throws Exception {
                LLMService.this.tu.reset();
                LOG.log(Level.INFO, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.calling"));
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                this.responseBody = response.body();
                return null;
            }

            @Override
            public void done() {
                dialog.cancel();
                LLMService.this.process_LLM_Response_OCR(this.responseBody, base64Image, finalBearer, isPdf, handler);
            }
        };
        progressBar.setTask(worker);
        SwingUtilities.invokeLater(() -> {
            progressBar.start();
            worker.execute();
        });
    }

    private void process_LLM_Response_OCR(String json, String base64Image, String userBearer, boolean isPdf, LLMResponseHandler handler) {
        LOG.log(Level.INFO, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.response", (Object)this.tu.getTimeHMS()));
        JSONObject jsonRoot = null;
        try {
            if (json == null || json.equals("Unauthorized")) {
                String msg;
                String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.title");
                String bearer = (String)DialogManager.InputLine.create((String)title, (String)(msg = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.unauthorized")), (String)"").setDialogId("BrowserPanel.extractService.msg.unauthorized").show();
                if (bearer == null) {
                    return;
                }
                this.call_LLM_OCR(base64Image, bearer, isPdf, handler);
            }
            if (json.equals("aborted")) {
                LOG.log(Level.INFO, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.aborted"));
                return;
            }
            if (userBearer != null && !userBearer.isBlank()) {
                BrowserOptionsPanel.setExtractionServiceAPIKey(userBearer);
            }
            jsonRoot = new JSONObject(json);
            JSONArray jsonPages = (JSONArray)jsonRoot.get("pages");
            JSONObject o = (JSONObject)jsonPages.get(0);
            String markdown = (String)o.get("markdown");
            markdown = markdown.replaceAll("!\\[img-[0-9].jpeg\\]\\(img-[0-9].jpeg\\)", "").replaceAll("\\^\\{\\\\circ\\}", "\u00b0");
            handler.apply(markdown);
        }
        catch (IOException | InterruptedException | JSONException ex) {
            LOG.log(Level.SEVERE, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.malfunction"));
            Exceptions.printStackTrace((Throwable)ex);
            if (jsonRoot != null) {
                LOG.log(Level.SEVERE, jsonRoot.toString());
            }
            String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.title");
            String msg = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.malfunction");
            DialogManager.createError((String)title, (String)msg).show();
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void call_LLM_QnA(final String text, String bearer, final LLMResponseHandler handler) throws IOException, InterruptedException, ExecutionException {
        String userBearer = null;
        if (bearer == null) {
            bearer = this.getAncestrisBearer();
        } else {
            userBearer = bearer;
        }
        if (bearer == null) {
            this.process_LLM_Response_QnA(null, text, null, handler);
            return;
        }
        String jsonText = text.replaceAll("\\n", "\\\\n").replace("\"", "'");
        String language = Locale.getDefault().getDisplayLanguage();
        String apiUrl = "https://api.mistral.ai/v1/chat/completions";
        String requestBody = "{\"model\": \"mistral-large-latest\",\"messages\": [{\"role\": \"user\",\"content\": \"Here is a document: " + jsonText + "Using this document, can you provide the following information in json format?certificate: The type of certificate event that this document represents, either 'birth', 'marriage', 'death', 'christening', 'burial', 'cremation', 'naturalization' or 'other',  (knowing for instance that a citizenship is also a naturalization)city: The city where this certificate is issued, in the format city, country., parish: The parish where this certificate is issued, notary: The notary who issued this certificate, date: The date at which the declaration was drawn up which can be the same day as the event or the day after or several days after the day of the event. All dates you will indicate should be in the format dd/mm/yyyy. ,register: The register identification of the certificate, number: The certificate number, summary: A summary in " + language + " of what you have understood in the document, tagtype: The type of certificate event in " + language + " that this document represents, individual: The main person to whom the certificate is referring to, indicating in the language of the document, the following 11 elements of this person separated by a vertical bar and stating '?' if unknown: lastname | firstname | sex | birthdate | birthplace with city and country | deathdate | deathplace with city and country | age of the person at the event | occupation | residence | whether this person is said to be DEAD or ALIVE at the time of the event., father: The same 11 elements as above for the father of main person, mother: The same 11 elements as above for the mother of main person, spouse: The same 11 elements as above for the spouse of main person, spousefather: The same 11 elements as above for the father of the spouse, spousemother: The same 11 elements as above for the mother of the spouse, firstwitness: For the first witness person or declaring person of his event, provide the lastname, firstname and occupation, separated by a vertical bar and stating '?' when unknown, secondwitness: The same information for the second witness of the event, thirdwitness: The same information for the third witness of the event, fourthwitness: The same information for the fourth witness of the event.\"}],\"response_format\": {\"type\": \"json_object\"}}";
        final HttpClient client = HttpClient.newHttpClient();
        final HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "Bearer " + bearer).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        ProgressBarPanel progressBar = new ProgressBarPanel();
        String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.inprogress");
        final DialogManager.ADialog dialog = DialogManager.create((String)title, (JComponent)progressBar, (boolean)false);
        dialog.setOptionType(10);
        dialog.show();
        final String finalBearer = userBearer;
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            String responseBody = "aborted";

            @Override
            protected Void doInBackground() throws Exception {
                LLMService.this.tu.reset();
                LOG.log(Level.INFO, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.calling"));
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                this.responseBody = response.body();
                return null;
            }

            @Override
            public void done() {
                dialog.cancel();
                LLMService.this.process_LLM_Response_QnA(this.responseBody, text, finalBearer, handler);
            }
        };
        progressBar.setTask(worker);
        SwingUtilities.invokeLater(() -> {
            progressBar.start();
            worker.execute();
        });
    }

    private void process_LLM_Response_QnA(String json, String text, String userBearer, LLMResponseHandler handler) {
        LOG.log(Level.INFO, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.response", (Object)this.tu.getTimeHMS()));
        JSONObject jsonRoot = null;
        String message = "";
        try {
            String objectStr;
            if (json == null || json.equals("Unauthorized")) {
                String msg;
                String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.title");
                String bearer = (String)DialogManager.InputLine.create((String)title, (String)(msg = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.unauthorized")), (String)"").setDialogId("BrowserPanel.extractService.msg.unauthorized").show();
                if (bearer == null) {
                    return;
                }
                this.call_LLM_QnA(text, bearer, handler);
            }
            if (json.equals("aborted")) {
                LOG.log(Level.INFO, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.aborted"));
                return;
            }
            if (userBearer != null && !userBearer.isBlank()) {
                BrowserOptionsPanel.setExtractionServiceAPIKey(userBearer);
            }
            if (!(objectStr = (String)(jsonRoot = new JSONObject(json)).get("object")).equals("chat.completion")) {
                if (objectStr.equals("error")) {
                    message = (String)jsonRoot.get("message");
                    throw new InterruptedException("LLM error");
                }
                message = jsonRoot.toString();
                throw new InterruptedException("LLM other error");
            }
            JSONArray jsonChoices = jsonRoot.getJSONArray("choices");
            JSONObject o = jsonChoices.getJSONObject(0);
            JSONObject jsonMessage = o.getJSONObject("message");
            String jsonContent = jsonMessage.getString("content");
            JSONObject jFields = new JSONObject(jsonContent);
            Map<AbstractRecord.FieldType, String> map = this.getMapFromFields(jFields, text);
            handler.apply(map);
        }
        catch (IOException | InterruptedException | JSONException ex) {
            LOG.log(Level.SEVERE, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.malfunction"));
            String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.title");
            Object msg = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.malfunction");
            if (!message.isBlank()) {
                LOG.log(Level.SEVERE, message);
                msg = (String)msg + "\n'" + message + "'";
            }
            DialogManager.createError((String)title, (String)msg).show();
            handler.apply(ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            handler.apply(ex);
        }
    }

    public void call_LLM(final String base64Image, String bearer, final boolean isPdf, final LLMResponseHandler handler) throws IOException, InterruptedException, ExecutionException {
        String userBearer = null;
        if (bearer == null) {
            bearer = this.getAncestrisBearer();
        } else {
            userBearer = bearer;
        }
        if (bearer == null) {
            this.processLLMResponse(null, base64Image, null, isPdf, handler);
            return;
        }
        String language = Locale.getDefault().getDisplayLanguage();
        String apiUrl = "https://api.mistral.ai/v1/ocr";
        String api_type = "image_url";
        String api_data = "image/jpeg";
        if (isPdf) {
            api_type = "document_url";
            api_data = "application/pdf";
        }
        String requestBody = "{\"model\": \"mistral-ocr-latest\",\"document\": {\"type\": \"" + api_type + "\",\"" + api_type + "\": \"data:" + api_data + ";base64," + base64Image + "\"},\"document_annotation_format\": {\"type\": \"json_schema\",\"json_schema\": {\"schema\": {\"properties\": {\"certificate\": {\"title\": \"type\", \"description\": \"The type of certificate event that this document represents, either 'birth', 'marriage', 'death', 'christening', 'burial', 'cremation', 'naturalization' or 'other'  (replacing citizenship by naturalization)\", \"type\": \"string\"},\"transcript\": {\"title\": \"transcript\", \"description\": \"Write in the language of the document the complete and exact transcription of the document respecting line breaks.\", \"type\": \"string\"},\"city\": {\"title\": \"city\", \"description\": \"The city where this certificate is issued, in the format city, country.\", \"type\": \"string\"},\"date\": {\"title\": \"date\", \"description\": \"The date at which the declaration was drawn up which can be the same day as the event, the day after or several days after the day of the event. All dates you will indicate should be in the format dd/mm/yyyy.\", \"type\": \"string\"},\"individual\": {\"title\": \"individual\", \"description\": \"The main person to whom the certificate is referring to, indicating in the language of the document, the following 11 elements of this person separated by a vertical bar and stating '?' if unknown: lastname | firstname | sex | birthdate | birthplace with city and country | deathdate | deathplace with city and country | age of the person at the event | occupation | residence | whether this person is said to be DEAD or ALIVE at the time of the event.\", \"type\": \"string\"},\"father\": {\"title\": \"father\", \"description\": \"The same 11 elements as above for the father of main person\", \"type\": \"string\"},\"mother\": {\"title\": \"mother\", \"description\": \"The same 11 elements as above for the mother of main person\", \"type\": \"string\"},\"spouse\": {\"title\": \"spouse\", \"description\": \"The same 11 elements as above for the spouse of main person\", \"type\": \"string\"},\"spousefather\": {\"title\": \"spousefather\", \"description\": \"The same 11 elements as above for the father of the spouse\", \"type\": \"string\"},\"spousemother\": {\"title\": \"spousemother\", \"description\": \"The same 11 elements as above for the mother of the spouse\", \"type\": \"string\"},\"firstwitness\": {\"title\": \"witness\", \"description\": \"For the first witness person or declaring person of his event, provide the lastname, firstname and occupation, separated by a vertical bar and stating '?' when unknown.\", \"type\": \"string\"},\"secondwitness\": {\"title\": \"witness\", \"description\": \"The same information for the second witness of the event.\", \"type\": \"string\"},\"thirdwitness\": {\"title\": \"witness\", \"description\": \"The same information for the third witness of the event.\", \"type\": \"string\"},\"fourthwitness\": {\"title\": \"witness\", \"description\": \"The same information for the fourth witness of the event.\", \"type\": \"string\"},\"summary\": {\"title\": \"content\", \"description\": \"Short summary in " + language + " of the document.\", \"type\": \"string\"},\"tagtype\": {\"tagtitle\": \"type\", \"description\": \"The type of certificate event in " + language + " that this document represents.\", \"type\": \"string\"}},\"required\": [\"certificate\"],\"title\": \"DocumentAnnotation\",\"type\": \"object\",\"additionalProperties\": false},\"name\": \"document_annotation\",\"strict\": true}},\"include_image_base64\": true}";
        final HttpClient client = HttpClient.newHttpClient();
        final HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "Bearer " + bearer).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        ProgressBarPanel progressBar = new ProgressBarPanel();
        String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.inprogress");
        final DialogManager.ADialog dialog = DialogManager.create((String)title, (JComponent)progressBar, (boolean)false);
        dialog.setOptionType(10);
        dialog.show();
        final String finalBearer = userBearer;
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            String responseBody = "aborted";

            @Override
            protected Void doInBackground() throws Exception {
                LLMService.this.tu.reset();
                LOG.log(Level.INFO, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.calling"));
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                this.responseBody = response.body();
                return null;
            }

            @Override
            public void done() {
                dialog.cancel();
                LLMService.this.processLLMResponse(this.responseBody, base64Image, finalBearer, isPdf, handler);
            }
        };
        progressBar.setTask(worker);
        SwingUtilities.invokeLater(() -> {
            progressBar.start();
            worker.execute();
        });
    }

    private void processLLMResponse(String json, String base64Image, String userBearer, boolean isPdf, LLMResponseHandler handler) {
        LOG.log(Level.INFO, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.response", (Object)this.tu.getTimeHMS()));
        JSONObject jsonRoot = null;
        String message = "";
        try {
            if (json == null || json.equals("Unauthorized")) {
                String msg;
                String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.title");
                String bearer = (String)DialogManager.InputLine.create((String)title, (String)(msg = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.unauthorized")), (String)"").setDialogId("BrowserPanel.extractService.msg.unauthorized").show();
                if (bearer == null) {
                    return;
                }
                this.call_LLM(base64Image, bearer, isPdf, handler);
            }
            if (json.equals("aborted")) {
                LOG.log(Level.INFO, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.aborted"));
                return;
            }
            if (userBearer != null && !userBearer.isBlank()) {
                BrowserOptionsPanel.setExtractionServiceAPIKey(userBearer);
            }
            if (!(jsonRoot = new JSONObject(json)).has("document_annotation")) {
                if (jsonRoot.has("object")) {
                    String objectStr = (String)jsonRoot.get("object");
                    if (objectStr.equals("error")) {
                        message = (String)jsonRoot.get("message");
                        throw new InterruptedException("LLM error");
                    }
                    message = jsonRoot.toString();
                    throw new InterruptedException("LLM other error");
                }
                message = jsonRoot.toString();
                throw new InterruptedException("LLM other error");
            }
            String jsonAnnotations = (String)jsonRoot.get("document_annotation");
            JSONObject jFields = new JSONObject(jsonAnnotations);
            Map<AbstractRecord.FieldType, String> map = this.getMapFromFields(jFields, null);
            handler.apply(map);
        }
        catch (IOException | InterruptedException | JSONException ex) {
            LOG.log(Level.SEVERE, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.malfunction"));
            String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.title");
            Object msg = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.malfunction");
            if (!message.isBlank()) {
                LOG.log(Level.SEVERE, message);
                msg = (String)msg + "\n'" + message + "'";
            }
            DialogManager.createError((String)title, (String)msg).show();
            handler.apply(ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            handler.apply(ex);
        }
    }

    private String getAncestrisBearer() {
        String ret = BrowserOptionsPanel.getExtractionServiceAPIKey();
        if (ret.isBlank()) {
            ret = UsageManager.getKey((String)"M00000A1");
        }
        if (ret == null || "".equals(ret)) {
            LOG.log(Level.SEVERE, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.idnotfound"));
            String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.title");
            Object msg = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.idnotfound");
            msg = (String)msg + "\n" + NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.idsolution");
            DialogManager.createError((String)title, (String)msg).show();
            return null;
        }
        return ret;
    }

    public String encodeImage(String fileName) throws IOException {
        byte[] fileContent = FileUtils.readFileToByteArray((File)new File(fileName));
        String encodedString = Base64.getEncoder().encodeToString(fileContent);
        return encodedString;
    }

    private String getFieldString(JSONObject jFields, String tag) {
        return jFields.has(tag) ? this.getValue(jFields.getString(tag)) : "";
    }

    private String getValue(String field) {
        return (field = field.trim()).equals("?") ? "" : field;
    }

    private String[] getSplit(String str, int i) {
        Object[] ret = new String[i];
        Arrays.fill(ret, "");
        String[] array = str.split("\\|");
        for (int k = 0; k < Math.min(array.length, i); ++k) {
            ret[k] = array[k];
        }
        return ret;
    }

    private String formatPlace(String place) {
        Gedcom gedcom;
        if (place.isBlank()) {
            return "";
        }
        String[] bits = place.split(",");
        String city = "";
        String country = "";
        if (bits.length > 0) {
            city = bits[0].trim();
        }
        if (bits.length > 1) {
            country = bits[1].trim();
        }
        Object ret = city + ", , , , " + country;
        Context context = GedcomDirectory.getDefault().getDefaultContext();
        Gedcom gedcom2 = gedcom = context != null ? context.getGedcom() : null;
        if (gedcom == null) {
            return ret;
        }
        String[] formatPlace = PropertyPlace.getFormat((Gedcom)gedcom);
        if (formatPlace.length == 0) {
            return ret;
        }
        Object[] retArray = new String[formatPlace.length];
        Arrays.fill(retArray, "");
        Integer cityTagIndex = PropertyPlace.getCityTagIndex((Gedcom)gedcom);
        Integer countryTagIndex = PropertyPlace.getCountryTagIndex((Gedcom)gedcom);
        retArray[cityTagIndex.intValue()] = city;
        retArray[countryTagIndex.intValue()] = country;
        ret = PropertyPlace.arrayToString((String[])retArray);
        return ret;
    }

    private Map<AbstractRecord.FieldType, String> getMapFromFields(JSONObject jFields, String transcript) {
        HashMap<AbstractRecord.FieldType, String> map = new HashMap<AbstractRecord.FieldType, String>();
        int type = 3;
        switch (this.getFieldString(jFields, "certificate")) {
            case "birth": {
                type = 0;
                map.put(AbstractRecord.FieldType.eventTag, "BIRT");
                break;
            }
            case "marriage": {
                type = 1;
                map.put(AbstractRecord.FieldType.eventTag, "MARR");
                break;
            }
            case "death": {
                type = 2;
                map.put(AbstractRecord.FieldType.eventTag, "DEAT");
                break;
            }
            default: {
                type = 3;
                String typeOfDocument = this.getFieldString(jFields, "tagtype");
                String tag = BeanEventTag.valueToTag(typeOfDocument);
                if (tag != null) {
                    map.put(AbstractRecord.FieldType.eventTag, tag);
                    break;
                }
                map.put(AbstractRecord.FieldType.eventType, typeOfDocument);
            }
        }
        map.put(AbstractRecord.FieldType.place, this.getFieldString(jFields, "city"));
        map.put(AbstractRecord.FieldType.eventDate, this.getFieldString(jFields, "date"));
        map.put(AbstractRecord.FieldType.parish, this.getFieldString(jFields, "parish"));
        String reg = this.getFieldString(jFields, "register").replace("?", "");
        String num = this.getFieldString(jFields, "number").replace("?", "");
        String delim = "";
        if (!reg.isBlank() && !num.isBlank()) {
            delim = "-";
        }
        map.put(AbstractRecord.FieldType.cote, reg + delim + num);
        map.put(AbstractRecord.FieldType.notary, this.getFieldString(jFields, "notary"));
        int size = 11;
        String mainIndi = this.getFieldString(jFields, "individual");
        String[] fields = this.getSplit(mainIndi, size);
        map.put(AbstractRecord.FieldType.indiLastName, this.getValue(fields[0]));
        map.put(AbstractRecord.FieldType.indiFirstName, this.getValue(fields[1]));
        map.put(AbstractRecord.FieldType.indiSex, this.getValue(fields[2]).toUpperCase());
        map.put(AbstractRecord.FieldType.indiBirthDate, this.getValue(fields[3]));
        map.put(AbstractRecord.FieldType.indiBirthPlace, this.formatPlace(this.getValue(fields[4])));
        map.put(AbstractRecord.FieldType.indiDeathDate, this.getValue(fields[5]));
        map.put(AbstractRecord.FieldType.indiDeathPlace, this.formatPlace(this.getValue(fields[6])));
        map.put(AbstractRecord.FieldType.indiAge, this.getValue(fields[7]) + "y");
        map.put(AbstractRecord.FieldType.indiOccupation, StringUtils.capitalize((String)this.getValue(fields[8])));
        map.put(AbstractRecord.FieldType.indiResidence, this.formatPlace(this.getValue(fields[9])));
        String father = this.getFieldString(jFields, "father");
        fields = this.getSplit(father, size);
        map.put(AbstractRecord.FieldType.indiFatherLastName, this.getValue(fields[0]));
        map.put(AbstractRecord.FieldType.indiFatherFirstName, this.getValue(fields[1]));
        map.put(AbstractRecord.FieldType.indiFatherDead, this.getValue(fields[10]).toUpperCase());
        map.put(AbstractRecord.FieldType.indiFatherAge, this.getValue(fields[7]) + "y");
        map.put(AbstractRecord.FieldType.indiFatherOccupation, StringUtils.capitalize((String)this.getValue(fields[8])));
        map.put(AbstractRecord.FieldType.indiFatherResidence, this.formatPlace(this.getValue(fields[9])));
        String mother = this.getFieldString(jFields, "mother");
        fields = this.getSplit(mother, size);
        map.put(AbstractRecord.FieldType.indiMotherLastName, this.getValue(fields[0]));
        map.put(AbstractRecord.FieldType.indiMotherFirstName, this.getValue(fields[1]));
        map.put(AbstractRecord.FieldType.indiMotherDead, this.getValue(fields[10]).toUpperCase());
        map.put(AbstractRecord.FieldType.indiMotherAge, this.getValue(fields[7]) + "y");
        map.put(AbstractRecord.FieldType.indiMotherOccupation, StringUtils.capitalize((String)this.getValue(fields[8])));
        map.put(AbstractRecord.FieldType.indiMotherResidence, this.formatPlace(this.getValue(fields[9])));
        if (type == 1) {
            wife = this.getFieldString(jFields, "spouse");
            fields = this.getSplit(wife, size);
            map.put(AbstractRecord.FieldType.wifeLastName, this.getValue(fields[0]));
            map.put(AbstractRecord.FieldType.wifeFirstName, this.getValue(fields[1]));
            map.put(AbstractRecord.FieldType.wifeBirthDate, this.getValue(fields[3]));
            map.put(AbstractRecord.FieldType.wifeBirthPlace, this.formatPlace(this.getValue(fields[4])));
            map.put(AbstractRecord.FieldType.wifeSex, this.getValue(fields[2]).toUpperCase());
            map.put(AbstractRecord.FieldType.wifeAge, this.getValue(fields[7]) + "y");
            map.put(AbstractRecord.FieldType.wifeOccupation, StringUtils.capitalize((String)this.getValue(fields[8])));
            map.put(AbstractRecord.FieldType.wifeResidence, this.formatPlace(this.getValue(fields[9])));
            String wifefather = this.getFieldString(jFields, "spousefather");
            fields = this.getSplit(wifefather, size);
            map.put(AbstractRecord.FieldType.wifeFatherLastName, this.getValue(fields[0]));
            map.put(AbstractRecord.FieldType.wifeFatherFirstName, this.getValue(fields[1]));
            map.put(AbstractRecord.FieldType.wifeFatherDead, this.getValue(fields[10]).toUpperCase());
            map.put(AbstractRecord.FieldType.wifeFatherAge, this.getValue(fields[7]) + "y");
            map.put(AbstractRecord.FieldType.wifeFatherOccupation, StringUtils.capitalize((String)this.getValue(fields[8])));
            map.put(AbstractRecord.FieldType.wifeFatherResidence, this.formatPlace(this.getValue(fields[9])));
            String wifemother = this.getFieldString(jFields, "spousemother");
            fields = this.getSplit(wifemother, size);
            map.put(AbstractRecord.FieldType.wifeMotherLastName, this.getValue(fields[0]));
            map.put(AbstractRecord.FieldType.wifeMotherFirstName, this.getValue(fields[1]));
            map.put(AbstractRecord.FieldType.wifeMotherDead, this.getValue(fields[10]).toUpperCase());
            map.put(AbstractRecord.FieldType.wifeMotherAge, this.getValue(fields[7]) + "y");
            map.put(AbstractRecord.FieldType.wifeMotherOccupation, StringUtils.capitalize((String)this.getValue(fields[8])));
            map.put(AbstractRecord.FieldType.wifeMotherResidence, this.formatPlace(this.getValue(fields[9])));
        } else {
            wife = this.getFieldString(jFields, "spouse");
            fields = this.getSplit(wife, size);
            map.put(AbstractRecord.FieldType.indiMarriedLastName, this.getValue(fields[0]));
            map.put(AbstractRecord.FieldType.indiMarriedFirstName, this.getValue(fields[1]));
            map.put(AbstractRecord.FieldType.indiMarriedDead, this.getValue(fields[10]));
            map.put(AbstractRecord.FieldType.indiMarriedOccupation, StringUtils.capitalize((String)this.getValue(fields[8])));
            map.put(AbstractRecord.FieldType.indiMarriedResidence, this.formatPlace(this.getValue(fields[9])));
        }
        size = 3;
        String firstwitness = this.getFieldString(jFields, "firstwitness");
        fields = this.getSplit(firstwitness, size);
        map.put(AbstractRecord.FieldType.witness1LastName, this.getValue(fields[0]));
        map.put(AbstractRecord.FieldType.witness1FirstName, this.getValue(fields[1]));
        map.put(AbstractRecord.FieldType.witness1Occupation, StringUtils.capitalize((String)this.getValue(fields[2])));
        String secondwitness = this.getFieldString(jFields, "secondwitness");
        fields = this.getSplit(secondwitness, size);
        map.put(AbstractRecord.FieldType.witness2LastName, this.getValue(fields[0]));
        map.put(AbstractRecord.FieldType.witness2FirstName, this.getValue(fields[1]));
        map.put(AbstractRecord.FieldType.witness2Occupation, StringUtils.capitalize((String)this.getValue(fields[2])));
        String thirdwitness = this.getFieldString(jFields, "thirdwitness");
        fields = this.getSplit(thirdwitness, size);
        map.put(AbstractRecord.FieldType.witness3LastName, this.getValue(fields[0]));
        map.put(AbstractRecord.FieldType.witness3FirstName, this.getValue(fields[1]));
        map.put(AbstractRecord.FieldType.witness3Occupation, StringUtils.capitalize((String)this.getValue(fields[2])));
        String fourthwitness = this.getFieldString(jFields, "fourthwitness");
        fields = this.getSplit(fourthwitness, size);
        map.put(AbstractRecord.FieldType.witness4LastName, this.getValue(fields[0]));
        map.put(AbstractRecord.FieldType.witness4FirstName, this.getValue(fields[1]));
        map.put(AbstractRecord.FieldType.witness4Occupation, StringUtils.capitalize((String)this.getValue(fields[2])));
        if (transcript != null && !transcript.isBlank()) {
            map.put(AbstractRecord.FieldType.deedText, transcript);
        } else {
            map.put(AbstractRecord.FieldType.deedText, this.getFieldString(jFields, "transcript"));
        }
        map.put(AbstractRecord.FieldType.generalComment, this.getFieldString(jFields, "summary"));
        map.put(AbstractRecord.FieldType.eventMedia, "");
        return map;
    }
}

